/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.Label;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.TaskRunAttempt;
import io.kestra.core.models.executions.Variables;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.Output;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.ExecutableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.ExecutableUtils;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.FlowMetaStoreInterface;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.SubflowExecution;
import io.kestra.core.runners.SubflowExecutionResult;
import io.kestra.core.serializers.ListOrMapOfLabelDeserializer;
import io.kestra.core.serializers.ListOrMapOfLabelSerializer;
import io.kestra.core.services.VariablesService;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.validations.NoSystemLabelValidation;
import io.kestra.plugin.core.flow.ChildFlowInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

@Schema(title="Create a subflow execution.", description="Subflows offer a modular way to reuse workflow logic by calling other flows just like calling a function in a programming language. Restarting a parent flow will restart any subflows that has previously been executed.")
@Plugin(examples={@Example(title="Run a subflow with custom inputs.", full=true, code={"id: parent_flow\nnamespace: company.team\n\ntasks:\n  - id: call_subflow\n    type: io.kestra.plugin.core.flow.Subflow\n    namespace: company.team\n    flowId: subflow\n    inputs:\n      user: Rick Astley\n      favorite_song: Never Gonna Give You Up\n    wait: true\n    transmitFailed: true\n"})}, aliases={"io.kestra.core.tasks.flows.Subflow", "io.kestra.core.tasks.flows.Flow"})
public class Subflow
extends Task
implements ExecutableTask<Output>,
ChildFlowInterface {
    static final String PLUGIN_FLOW_OUTPUTS_ENABLED = "outputs.enabled";
    @NotEmpty
    @Schema(title="The namespace of the subflow to be executed")
    @PluginProperty(dynamic=true)
    private String namespace;
    @NotNull
    @Schema(title="The identifier of the subflow to be executed")
    @PluginProperty(dynamic=true)
    private String flowId;
    @Schema(title="The revision of the subflow to be executed", description="By default, the last, i.e., the most recent, revision of the subflow is executed.")
    @PluginProperty(dynamic=true)
    @Min(value=1L)
    private @Min(value=1L) Integer revision;
    @Schema(title="The inputs to pass to the subflow to be executed")
    @PluginProperty(dynamic=true)
    private Map<String, Object> inputs;
    @Schema(title="The labels to pass to the subflow to be executed", implementation=Object.class, oneOf={List.class, Map.class})
    @PluginProperty(dynamic=true)
    @JsonSerialize(using=ListOrMapOfLabelSerializer.class)
    @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
    private List<@NoSystemLabelValidation Label> labels;
    @Schema(title="Flag specifying whether to wait for the subflow execution to finish before continuing the current execution.")
    @PluginProperty
    private final Boolean wait;
    @Schema(title="Flag specifying whether to fail the current execution if the subflow execution fails or is killed.", description="Note that this option works only if `wait` is set to `true`.")
    @PluginProperty
    private final Boolean transmitFailed;
    @Schema(title="Flag specifying whether the subflow should inherit labels from this execution that triggered it.", description="By default, labels are not passed to the subflow execution. If you set this option to `true`, the child flow execution will inherit all labels from the parent execution.")
    private final Property<Boolean> inheritLabels;
    @Schema(title="Outputs from the subflow executions", description="Specify outputs as key-value pairs to extract any outputs from the subflow execution into output of this task execution.This property is deprecated since v0.15.0, please use the `outputs` property on the Subflow definition for defining the output values available and exposed to this task execution.")
    @PluginProperty(dynamic=true)
    @Deprecated(since="0.15.0")
    private Map<String, Object> outputs;
    @Schema(title="Don't trigger the subflow now but schedule it on a specific date.")
    private Property<ZonedDateTime> scheduleDate;
    @Schema(title="Action to take when a failed execution is restarting", description="- RETRY_FAILED (default): will restart the subflow execution if it's failed.\n- NEW_EXECUTION: will create a new subflow execution.\"\"\n")
    @NotNull
    private ExecutableTask.RestartBehavior restartBehavior;

    @Override
    public List<SubflowExecution<?>> createSubflowExecutions(RunContext runContext, FlowMetaStoreInterface flowExecutorInterface, Flow currentFlow, Execution currentExecution, TaskRun currentTaskRun) throws InternalException {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        if (this.inputs != null) {
            inputs.putAll(runContext.render(this.inputs));
        }
        return ExecutableUtils.subflowExecution(runContext, flowExecutorInterface, currentExecution, currentFlow, this, currentTaskRun, inputs, this.labels, runContext.render(this.inheritLabels).as(Boolean.class).orElseThrow(), this.scheduleDate).map(subflowExecution -> List.of(subflowExecution)).orElse(Collections.emptyList());
    }

    @Override
    public Optional<SubflowExecutionResult> createSubflowExecutionResult(RunContext runContext, TaskRun taskRun, FlowInterface flow, Execution execution) {
        if (!taskRun.getState().isTerminated()) {
            return Optional.empty();
        }
        Output.OutputBuilder builder = Output.builder().executionId(execution.getId()).state(execution.getState().getCurrent());
        VariablesService variablesService = (VariablesService)((DefaultRunContext)runContext).getApplicationContext().getBean(VariablesService.class);
        if (this.wait.booleanValue()) {
            List<io.kestra.core.models.flows.Output> subflowOutputs = flow.getOutputs();
            if (subflowOutputs == null && this.getOutputs() != null) {
                boolean isOutputsAllowed = runContext.pluginConfiguration(PLUGIN_FLOW_OUTPUTS_ENABLED).orElse(true);
                if (isOutputsAllowed) {
                    try {
                        subflowOutputs = this.getOutputs().entrySet().stream().map(entry -> ((Output.OutputBuilder)((Output.OutputBuilder)((Output.OutputBuilder)io.kestra.core.models.flows.Output.builder().id((String)entry.getKey())).value(entry.getValue())).required(true)).build()).toList();
                    }
                    catch (Exception e) {
                        Variables variables = variablesService.of(StorageContext.forTask(taskRun), builder.build());
                        return this.failSubflowDueToOutput(runContext, taskRun, execution, e, variables);
                    }
                } else {
                    runContext.logger().warn("Defining outputs inside the Subflow task is not allowed.");
                }
            }
            if (subflowOutputs != null && !subflowOutputs.isEmpty()) {
                try {
                    Map<String, Object> rOutputs = FlowInputOutput.renderFlowOutputs(subflowOutputs, runContext);
                    FlowInputOutput flowInputOutput = (FlowInputOutput)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowInputOutput.class);
                    if (flow.getOutputs() != null && flowInputOutput != null) {
                        rOutputs = flowInputOutput.typedOutputs(flow, execution, rOutputs);
                    }
                    builder.outputs(rOutputs);
                }
                catch (Exception e) {
                    Variables variables = variablesService.of(StorageContext.forTask(taskRun), builder.build());
                    return this.failSubflowDueToOutput(runContext, taskRun, execution, e, variables);
                }
            }
        }
        Variables variables = variablesService.of(StorageContext.forTask(taskRun), builder.build());
        taskRun = taskRun.withOutputs(variables);
        State.Type finalState = ExecutableUtils.guessState(execution, this.transmitFailed, this.isAllowFailure(), this.isAllowWarning());
        if (taskRun.getState().getCurrent() != finalState) {
            taskRun = taskRun.withState(finalState);
        }
        if (finalState.isFailed()) {
            log = String.format("Subflow execution [[link execution=\"%s\" flowId=\"%s\" namespace=\"%s\"]] ends in FAILED state", execution.getId(), execution.getFlowId(), execution.getNamespace());
            runContext.logger().error(log);
        } else if (finalState == State.Type.WARNING) {
            log = String.format("Subflow execution [[link execution=\"%s\" flowId=\"%s\" namespace=\"%s\"]] ends in WARNING state", execution.getId(), execution.getFlowId(), execution.getNamespace());
            runContext.logger().warn(log);
        }
        return Optional.of(ExecutableUtils.subflowExecutionResult(taskRun, execution));
    }

    private Optional<SubflowExecutionResult> failSubflowDueToOutput(RunContext runContext, TaskRun taskRun, Execution execution, Exception e, Variables outputs) {
        runContext.logger().error("Failed to extract outputs with the error: '{}'", (Object)e.getLocalizedMessage(), (Object)e);
        State.Type state = State.Type.fail(this);
        taskRun = taskRun.withState(state).withAttempts(Collections.singletonList(TaskRunAttempt.builder().state(new State().withState(state)).build())).withOutputs(outputs);
        return Optional.of(SubflowExecutionResult.builder().executionId(execution.getId()).state(State.Type.FAILED).parentTaskRun(taskRun).build());
    }

    @Override
    public boolean waitForExecution() {
        return this.wait;
    }

    @Override
    public ExecutableTask.SubflowId subflowId() {
        return new ExecutableTask.SubflowId(this.namespace, this.flowId, Optional.ofNullable(this.revision));
    }

    @Generated
    private static Boolean $default$wait() {
        return true;
    }

    @Generated
    private static Boolean $default$transmitFailed() {
        return true;
    }

    @Generated
    private static Property<Boolean> $default$inheritLabels() {
        return Property.ofValue(false);
    }

    @Generated
    private static ExecutableTask.RestartBehavior $default$restartBehavior() {
        return ExecutableTask.RestartBehavior.RETRY_FAILED;
    }

    @Generated
    protected Subflow(SubflowBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.revision = b.revision;
        this.inputs = b.inputs;
        this.labels = b.labels;
        this.wait = b.wait$set ? b.wait$value : Subflow.$default$wait();
        this.transmitFailed = b.transmitFailed$set ? b.transmitFailed$value : Subflow.$default$transmitFailed();
        this.inheritLabels = b.inheritLabels$set ? b.inheritLabels$value : Subflow.$default$inheritLabels();
        this.outputs = b.outputs;
        this.scheduleDate = b.scheduleDate;
        this.restartBehavior = b.restartBehavior$set ? b.restartBehavior$value : Subflow.$default$restartBehavior();
    }

    @Generated
    public static SubflowBuilder<?, ?> builder() {
        return new SubflowBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Subflow(super=" + super.toString() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", revision=" + this.getRevision() + ", inputs=" + String.valueOf(this.getInputs()) + ", labels=" + String.valueOf(this.getLabels()) + ", wait=" + this.getWait() + ", transmitFailed=" + this.getTransmitFailed() + ", inheritLabels=" + String.valueOf(this.getInheritLabels()) + ", outputs=" + String.valueOf(this.getOutputs()) + ", scheduleDate=" + String.valueOf(this.getScheduleDate()) + ", restartBehavior=" + String.valueOf((Object)this.getRestartBehavior()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subflow)) {
            return false;
        }
        Subflow other = (Subflow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$revision = this.getRevision();
        Integer other$revision = other.getRevision();
        if (this$revision == null ? other$revision != null : !((Object)this$revision).equals(other$revision)) {
            return false;
        }
        Boolean this$wait = this.getWait();
        Boolean other$wait = other.getWait();
        if (this$wait == null ? other$wait != null : !((Object)this$wait).equals(other$wait)) {
            return false;
        }
        Boolean this$transmitFailed = this.getTransmitFailed();
        Boolean other$transmitFailed = other.getTransmitFailed();
        if (this$transmitFailed == null ? other$transmitFailed != null : !((Object)this$transmitFailed).equals(other$transmitFailed)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        Map<String, Object> this$inputs = this.getInputs();
        Map<String, Object> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<Label> this$labels = this.getLabels();
        List<Label> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Property<Boolean> this$inheritLabels = this.getInheritLabels();
        Property<Boolean> other$inheritLabels = other.getInheritLabels();
        if (this$inheritLabels == null ? other$inheritLabels != null : !((Object)this$inheritLabels).equals(other$inheritLabels)) {
            return false;
        }
        Map<String, Object> this$outputs = this.getOutputs();
        Map<String, Object> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        Property<ZonedDateTime> this$scheduleDate = this.getScheduleDate();
        Property<ZonedDateTime> other$scheduleDate = other.getScheduleDate();
        if (this$scheduleDate == null ? other$scheduleDate != null : !((Object)this$scheduleDate).equals(other$scheduleDate)) {
            return false;
        }
        ExecutableTask.RestartBehavior this$restartBehavior = this.getRestartBehavior();
        ExecutableTask.RestartBehavior other$restartBehavior = other.getRestartBehavior();
        return !(this$restartBehavior == null ? other$restartBehavior != null : !((Object)((Object)this$restartBehavior)).equals((Object)other$restartBehavior));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Subflow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $revision = this.getRevision();
        result = result * 59 + ($revision == null ? 43 : ((Object)$revision).hashCode());
        Boolean $wait = this.getWait();
        result = result * 59 + ($wait == null ? 43 : ((Object)$wait).hashCode());
        Boolean $transmitFailed = this.getTransmitFailed();
        result = result * 59 + ($transmitFailed == null ? 43 : ((Object)$transmitFailed).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        Map<String, Object> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<Label> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Property<Boolean> $inheritLabels = this.getInheritLabels();
        result = result * 59 + ($inheritLabels == null ? 43 : ((Object)$inheritLabels).hashCode());
        Map<String, Object> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        Property<ZonedDateTime> $scheduleDate = this.getScheduleDate();
        result = result * 59 + ($scheduleDate == null ? 43 : ((Object)$scheduleDate).hashCode());
        ExecutableTask.RestartBehavior $restartBehavior = this.getRestartBehavior();
        result = result * 59 + ($restartBehavior == null ? 43 : ((Object)((Object)$restartBehavior)).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public Integer getRevision() {
        return this.revision;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public List<@NoSystemLabelValidation Label> getLabels() {
        return this.labels;
    }

    @Generated
    public Boolean getWait() {
        return this.wait;
    }

    @Generated
    public Boolean getTransmitFailed() {
        return this.transmitFailed;
    }

    @Generated
    public Property<Boolean> getInheritLabels() {
        return this.inheritLabels;
    }

    @Deprecated
    @Generated
    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    @Generated
    public Property<ZonedDateTime> getScheduleDate() {
        return this.scheduleDate;
    }

    @Override
    @Generated
    public ExecutableTask.RestartBehavior getRestartBehavior() {
        return this.restartBehavior;
    }

    @Generated
    public Subflow() {
        this.wait = Subflow.$default$wait();
        this.transmitFailed = Subflow.$default$transmitFailed();
        this.inheritLabels = Subflow.$default$inheritLabels();
        this.restartBehavior = Subflow.$default$restartBehavior();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The subflow execution ID")
        private final String executionId;
        @Schema(title="The final state of the subflow execution", description="This output is only available if `wait` is set to `true`.")
        private final State.Type state;
        @Schema(title="The outputs returned by the subflow exectution")
        private final Map<String, Object> outputs;

        @ConstructorProperties(value={"executionId", "state", "outputs"})
        @Generated
        Output(String executionId, State.Type state, Map<String, Object> outputs) {
            this.executionId = executionId;
            this.state = state;
            this.outputs = outputs;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String getExecutionId() {
            return this.executionId;
        }

        @Generated
        public State.Type getState() {
            return this.state;
        }

        @Generated
        public Map<String, Object> getOutputs() {
            return this.outputs;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String executionId;
            @Generated
            private State.Type state;
            @Generated
            private Map<String, Object> outputs;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder executionId(String executionId) {
                this.executionId = executionId;
                return this;
            }

            @Generated
            public OutputBuilder state(State.Type state) {
                this.state = state;
                return this;
            }

            @Generated
            public OutputBuilder outputs(Map<String, Object> outputs) {
                this.outputs = outputs;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.executionId, this.state, this.outputs);
            }

            @Generated
            public String toString() {
                return "Subflow.Output.OutputBuilder(executionId=" + this.executionId + ", state=" + String.valueOf((Object)this.state) + ", outputs=" + String.valueOf(this.outputs) + ")";
            }
        }
    }

    @Generated
    public static abstract class SubflowBuilder<C extends Subflow, B extends SubflowBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private Integer revision;
        @Generated
        private Map<String, Object> inputs;
        @Generated
        private List<@NoSystemLabelValidation Label> labels;
        @Generated
        private boolean wait$set;
        @Generated
        private Boolean wait$value;
        @Generated
        private boolean transmitFailed$set;
        @Generated
        private Boolean transmitFailed$value;
        @Generated
        private boolean inheritLabels$set;
        @Generated
        private Property<Boolean> inheritLabels$value;
        @Generated
        private Map<String, Object> outputs;
        @Generated
        private Property<ZonedDateTime> scheduleDate;
        @Generated
        private boolean restartBehavior$set;
        @Generated
        private ExecutableTask.RestartBehavior restartBehavior$value;

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B revision(Integer revision) {
            this.revision = revision;
            return (B)this.self();
        }

        @Generated
        public B inputs(Map<String, Object> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
        @Generated
        public B labels(List<@NoSystemLabelValidation Label> labels) {
            this.labels = labels;
            return (B)this.self();
        }

        @Generated
        public B wait(Boolean wait) {
            this.wait$value = wait;
            this.wait$set = true;
            return (B)this.self();
        }

        @Generated
        public B transmitFailed(Boolean transmitFailed) {
            this.transmitFailed$value = transmitFailed;
            this.transmitFailed$set = true;
            return (B)this.self();
        }

        @Generated
        public B inheritLabels(Property<Boolean> inheritLabels) {
            this.inheritLabels$value = inheritLabels;
            this.inheritLabels$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B outputs(Map<String, Object> outputs) {
            this.outputs = outputs;
            return (B)this.self();
        }

        @Generated
        public B scheduleDate(Property<ZonedDateTime> scheduleDate) {
            this.scheduleDate = scheduleDate;
            return (B)this.self();
        }

        @Generated
        public B restartBehavior(ExecutableTask.RestartBehavior restartBehavior) {
            this.restartBehavior$value = restartBehavior;
            this.restartBehavior$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Subflow.SubflowBuilder(super=" + super.toString() + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", revision=" + this.revision + ", inputs=" + String.valueOf(this.inputs) + ", labels=" + String.valueOf(this.labels) + ", wait$value=" + this.wait$value + ", transmitFailed$value=" + this.transmitFailed$value + ", inheritLabels$value=" + String.valueOf(this.inheritLabels$value) + ", outputs=" + String.valueOf(this.outputs) + ", scheduleDate=" + String.valueOf(this.scheduleDate) + ", restartBehavior$value=" + String.valueOf((Object)this.restartBehavior$value) + ")";
        }
    }

    @Generated
    private static final class SubflowBuilderImpl
    extends SubflowBuilder<Subflow, SubflowBuilderImpl> {
        @Generated
        private SubflowBuilderImpl() {
        }

        @Override
        @Generated
        protected SubflowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Subflow build() {
            return new Subflow(this);
        }
    }
}

