/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.fasterxml.jackson.core.type.TypeReference;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.InputFilesInterface;
import io.kestra.core.models.tasks.NamespaceFiles;
import io.kestra.core.models.tasks.NamespaceFilesInterface;
import io.kestra.core.models.tasks.OutputFilesInterface;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.VoidOutput;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.FilesService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.NamespaceFilesUtils;
import io.kestra.core.validations.WorkingDirectoryTaskValidation;
import io.kestra.plugin.core.flow.Sequential;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.Generated;

@Schema(title="Run tasks sequentially in the same working directory.", description="Tasks are stateless by default. Kestra will launch each task within a temporary working directory on a Worker. The `WorkingDirectory` task allows reusing the same file system's working directory across multiple tasks so that multiple sequential tasks can use output files from previous tasks without having to use the `outputs.taskId.outputName` syntax. Note that the `WorkingDirectory` only works with runnable tasks because those tasks are executed directly on the Worker. This means that using flowable tasks such as the `Parallel` task within the `WorkingDirectory` task will not work. ")
@Plugin(examples={@Example(full=true, title="Clone a Git repository into the Working Directory and run a Python script in a Docker container.", code={"id: git_python\nnamespace: company.team\n\ntasks:\n  - id: wdir\n    type: io.kestra.plugin.core.flow.WorkingDirectory\n    tasks:\n      - id: clone_repository\n        type: io.kestra.plugin.git.Clone\n        url: https://github.com/kestra-io/examples\n        branch: main\n\n      - id: python\n        type: io.kestra.plugin.scripts.python.Commands\n        taskRunner:\n          type: io.kestra.plugin.scripts.runner.docker.Docker\n        containerImage: ghcr.io/kestra-io/pydata:latest\n        commands:\n          - python scripts/etl_script.py\n"}), @Example(full=true, title="Add input and output files within a Working Directory to use them in a Python script.", code={"    id: api_json_to_mongodb\n    namespace: company.team\n\n    tasks:\n      - id: wdir\n        type: io.kestra.plugin.core.flow.WorkingDirectory\n        outputFiles:\n          - output.json\n        inputFiles:\n          query.sql: |\n            SELECT sum(total) as total, avg(quantity) as avg_quantity\n            FROM sales;\n        tasks:\n          - id: inline_script\n            type: io.kestra.plugin.scripts.python.Script\n            taskRunner:\n              type: io.kestra.plugin.scripts.runner.docker.Docker\n            containerImage: python:3.11-slim\n            beforeCommands:\n              - pip install requests kestra > /dev/null\n            script: |\n              import requests\n              import json\n              from kestra import Kestra\n\n              with open('query.sql', 'r') as input_file:\n                  sql = input_file.read()\n\n              response = requests.get('https://api.github.com')\n              data = response.json()\n\n              with open('output.json', 'w') as output_file:\n                  json.dump(data, output_file)\n\n              Kestra.outputs({'receivedSQL': sql, 'status': response.status_code})\n\n      - id: load_to_mongodb\n        type: io.kestra.plugin.mongodb.Load\n        connection:\n          uri: mongodb://host.docker.internal:27017/\n        database: local\n        collection: github\n        from: \"{{ outputs.wdir.uris['output.json'] }}\"\n"}), @Example(full=true, code={"id: working_directory\nnamespace: company.team\n\ntasks:\n  - id: working_directory\n    type: io.kestra.plugin.core.flow.WorkingDirectory\n    tasks:\n      - id: first\n        type: io.kestra.plugin.scripts.shell.Commands\n        commands:\n        - 'echo \"{{ taskrun.id }}\" > {{ workingDir }}/stay.txt'\n      - id: second\n        type: io.kestra.plugin.scripts.shell.Commands\n        commands:\n        - |\n          echo '::{\"outputs\": {\"stay\":\"'$(cat {{ workingDir }}/stay.txt)'\"}}::''\n"}), @Example(full=true, title="A working directory with a cache of the node_modules directory.", code={"id: node_with_cache\nnamespace: company.team\n\ntasks:\n  - id: working_dir\n    type: io.kestra.plugin.core.flow.WorkingDirectory\n    cache:\n      patterns:\n        - node_modules/**\n      ttl: PT1H\n    tasks:\n      - id: script\n        type: io.kestra.plugin.scripts.node.Script\n        beforeCommands:\n          - npm install colors\n        script: |\n          const colors = require(\"colors\");\n          console.log(colors.red(\"Hello\"));\n"})}, aliases={"io.kestra.core.tasks.flows.WorkingDirectory", "io.kestra.core.tasks.flows.Worker"})
@WorkingDirectoryTaskValidation
public class WorkingDirectory
extends Sequential
implements NamespaceFilesInterface,
InputFilesInterface,
OutputFilesInterface {
    private static final String OUTPUTS_FILE = "outputs.ion";
    @Schema(title="Cache configuration", description="When a cache is configured, an archive of the files denoted by the cache configuration is created at the end of the task run and saved in Kestra's internal storage.\nThen, at the beginning of the next task execution, the file archive is retrieved and the working directory is initialized with it.\n")
    @PluginProperty
    private Cache cache;
    private NamespaceFiles namespaceFiles;
    private transient long cacheDownloadedTime;
    private Object inputFiles;
    private Property<List<String>> outputFiles;

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        List<ResolvedTask> childTasks = this.childTasks(runContext, parentTaskRun);
        if (execution.hasFailed(childTasks, parentTaskRun)) {
            return super.resolveNexts(runContext, execution, parentTaskRun);
        }
        return Collections.emptyList();
    }

    public WorkerTask workerTask(TaskRun parent, Task task, RunContext runContext) {
        return WorkerTask.builder().task(task).taskRun(TaskRun.builder().id(IdUtils.create()).tenantId(parent.getTenantId()).executionId(parent.getExecutionId()).namespace(parent.getNamespace()).flowId(parent.getFlowId()).taskId(task.getId()).parentTaskRunId(parent.getId()).state(new State()).build()).runContext(runContext).build();
    }

    public void preExecuteTasks(RunContext runContext, TaskRun taskRun) throws Exception {
        Optional<InputStream> maybeCacheFile;
        if (this.cache != null && (maybeCacheFile = runContext.storage().getCacheFile(this.getId(), taskRun.getValue(), runContext.render(this.cache.ttl).as(Duration.class).orElse(null))).isPresent()) {
            runContext.logger().debug("Cache exist, downloading it");
            try (ZipInputStream archive = new ZipInputStream(maybeCacheFile.get());){
                ZipEntry entry;
                while ((entry = archive.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    try {
                        Path file = runContext.workingDir().path().resolve(entry.getName());
                        Files.createDirectories(file.getParent(), new FileAttribute[0]);
                        Files.createFile(file, new FileAttribute[0]);
                        Files.write(file, archive.readAllBytes(), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        runContext.logger().error("Unable to create the file {}", (Object)entry.getName(), (Object)e);
                    }
                }
            }
            this.cacheDownloadedTime = System.currentTimeMillis();
        }
        if (this.namespaceFiles != null && !Boolean.FALSE.equals(runContext.render(this.namespaceFiles.getEnabled()).as(Boolean.class).orElse(true))) {
            NamespaceFilesUtils namespaceFilesUtils = (NamespaceFilesUtils)((DefaultRunContext)runContext).getApplicationContext().getBean(NamespaceFilesUtils.class);
            namespaceFilesUtils.loadNamespaceFiles(runContext, this.namespaceFiles);
        }
        if (this.inputFiles != null) {
            FilesService.inputFiles(runContext, Map.of(), this.inputFiles);
        }
    }

    public void postExecuteTasks(RunContext runContext, TaskRun taskRun) throws Exception {
        block26: {
            block24: {
                if (this.outputFiles != null) {
                    try {
                        ByteArrayOutputStream os;
                        Map<String, URI> outputFilesURIs = FilesService.outputFiles(runContext, runContext.render(this.outputFiles).asList(String.class));
                        if (outputFilesURIs.isEmpty()) break block24;
                        try (ByteArrayOutputStream byteArrayOutputStream = os = new ByteArrayOutputStream();){
                            FileSerde.write(os, outputFilesURIs);
                        }
                        runContext.storage().putFile((InputStream)new ByteArrayInputStream(os.toByteArray()), OUTPUTS_FILE);
                    }
                    catch (Exception e) {
                        runContext.logger().error("Unable to capture WorkingDirectory output files", (Throwable)e);
                        throw e;
                    }
                }
            }
            if (this.cache == null) {
                return;
            }
            try {
                List<Path> matchesList = runContext.workingDir().findAllFilesMatching(runContext.render(this.cache.getPatterns()).asList(String.class));
                boolean cacheFilesAreUpdated = matchesList.stream().anyMatch(path -> {
                    try {
                        return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis() > this.cacheDownloadedTime;
                    }
                    catch (IOException e) {
                        runContext.logger().warn("Unable to retrieve files last modified time, will update the cache anyway", (Throwable)e);
                        return true;
                    }
                });
                if (cacheFilesAreUpdated) {
                    runContext.logger().debug("Cache files changed, we update the cache");
                    try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                         ZipOutputStream archive = new ZipOutputStream(bos);){
                        for (Path path2 : matchesList) {
                            File file = path2.toFile();
                            if (file.isDirectory() || !file.canRead()) continue;
                            String relativeFileName = file.getPath().substring(runContext.workingDir().path().toString().length() + 1);
                            ZipEntry zipEntry = new ZipEntry(relativeFileName);
                            archive.putNextEntry(zipEntry);
                            archive.write(Files.readAllBytes(path2));
                            archive.closeEntry();
                        }
                        archive.finish();
                        Path archiveFile = runContext.workingDir().createTempFile(".zip");
                        Files.write(archiveFile, bos.toByteArray(), new OpenOption[0]);
                        URI uri = runContext.storage().putCacheFile(archiveFile.toFile(), this.getId(), taskRun.getValue());
                        runContext.logger().debug("Caching in {}", (Object)uri);
                        break block26;
                    }
                }
                runContext.logger().debug("Cache files didn't change, skip updating it");
            }
            catch (IOException e) {
                runContext.logger().error("Unable to execute WorkingDirectory post actions", (Throwable)e);
            }
        }
    }

    @Override
    public Outputs outputs(RunContext runContext) throws IOException {
        URI uri = URI.create("kestra://" + String.valueOf(runContext.storage().getContextBaseURI()) + "/").resolve(OUTPUTS_FILE);
        if (!runContext.storage().isFileExist(uri)) {
            return null;
        }
        try (BufferedReader is = new BufferedReader(new InputStreamReader(runContext.storage().getFile(uri)));){
            Map outputs = (Map)FileSerde.readAll((Reader)is, new TypeReference<Map<String, URI>>(this){}).blockFirst();
            Outputs outputs2 = new Outputs(outputs);
            return outputs2;
        }
    }

    @Generated
    private static long $default$cacheDownloadedTime() {
        return 0L;
    }

    @Generated
    protected WorkingDirectory(WorkingDirectoryBuilder<?, ?> b) {
        super((Sequential.SequentialBuilder<?, ?>)b);
        this.cache = b.cache;
        this.namespaceFiles = b.namespaceFiles;
        this.cacheDownloadedTime = b.cacheDownloadedTime$set ? b.cacheDownloadedTime$value : WorkingDirectory.$default$cacheDownloadedTime();
        this.inputFiles = b.inputFiles;
        this.outputFiles = b.outputFiles;
    }

    @Generated
    public static WorkingDirectoryBuilder<?, ?> builder() {
        return new WorkingDirectoryBuilderImpl();
    }

    @Generated
    public WorkingDirectoryBuilder<?, ?> toBuilder() {
        return new WorkingDirectoryBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String toString() {
        return "WorkingDirectory(super=" + super.toString() + ", cache=" + String.valueOf(this.getCache()) + ", namespaceFiles=" + String.valueOf(this.getNamespaceFiles()) + ", cacheDownloadedTime=" + this.getCacheDownloadedTime() + ", inputFiles=" + String.valueOf(this.getInputFiles()) + ", outputFiles=" + String.valueOf(this.getOutputFiles()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkingDirectory)) {
            return false;
        }
        WorkingDirectory other = (WorkingDirectory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Cache this$cache = this.getCache();
        Cache other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        NamespaceFiles this$namespaceFiles = this.getNamespaceFiles();
        NamespaceFiles other$namespaceFiles = other.getNamespaceFiles();
        if (this$namespaceFiles == null ? other$namespaceFiles != null : !this$namespaceFiles.equals(other$namespaceFiles)) {
            return false;
        }
        Object this$inputFiles = this.getInputFiles();
        Object other$inputFiles = other.getInputFiles();
        if (this$inputFiles == null ? other$inputFiles != null : !this$inputFiles.equals(other$inputFiles)) {
            return false;
        }
        Property<List<String>> this$outputFiles = this.getOutputFiles();
        Property<List<String>> other$outputFiles = other.getOutputFiles();
        return !(this$outputFiles == null ? other$outputFiles != null : !((Object)this$outputFiles).equals(other$outputFiles));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkingDirectory;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Cache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        NamespaceFiles $namespaceFiles = this.getNamespaceFiles();
        result = result * 59 + ($namespaceFiles == null ? 43 : $namespaceFiles.hashCode());
        Object $inputFiles = this.getInputFiles();
        result = result * 59 + ($inputFiles == null ? 43 : $inputFiles.hashCode());
        Property<List<String>> $outputFiles = this.getOutputFiles();
        result = result * 59 + ($outputFiles == null ? 43 : ((Object)$outputFiles).hashCode());
        return result;
    }

    @Generated
    public Cache getCache() {
        return this.cache;
    }

    @Override
    @Generated
    public NamespaceFiles getNamespaceFiles() {
        return this.namespaceFiles;
    }

    @Override
    @Generated
    public Object getInputFiles() {
        return this.inputFiles;
    }

    @Override
    @Generated
    public Property<List<String>> getOutputFiles() {
        return this.outputFiles;
    }

    @Generated
    public WorkingDirectory() {
        this.cacheDownloadedTime = WorkingDirectory.$default$cacheDownloadedTime();
    }

    @Generated
    private long getCacheDownloadedTime() {
        return this.cacheDownloadedTime;
    }

    public static class Cache {
        @Schema(title="Cache TTL (Time To Live), after this duration the cache will be deleted.")
        private Property<Duration> ttl;
        @Schema(title="List of file [glob](https://en.wikipedia.org/wiki/Glob_(programming)) patterns to include in the cache", description="For example, 'node_modules/**' will include all files of the node_modules directory including sub-directories.")
        @NotNull
        private Property<List<String>> patterns;

        @Generated
        protected Cache(CacheBuilder<?, ?> b) {
            this.ttl = b.ttl;
            this.patterns = b.patterns;
        }

        @Generated
        public static CacheBuilder<?, ?> builder() {
            return new CacheBuilderImpl();
        }

        @Generated
        public String toString() {
            return "WorkingDirectory.Cache(ttl=" + String.valueOf(this.getTtl()) + ", patterns=" + String.valueOf(this.getPatterns()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cache)) {
                return false;
            }
            Cache other = (Cache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Property<Duration> this$ttl = this.getTtl();
            Property<Duration> other$ttl = other.getTtl();
            if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
                return false;
            }
            Property<List<String>> this$patterns = this.getPatterns();
            Property<List<String>> other$patterns = other.getPatterns();
            return !(this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cache;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Property<Duration> $ttl = this.getTtl();
            result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
            Property<List<String>> $patterns = this.getPatterns();
            result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
            return result;
        }

        @Generated
        public Property<Duration> getTtl() {
            return this.ttl;
        }

        @Generated
        public Property<List<String>> getPatterns() {
            return this.patterns;
        }

        @Generated
        public Cache() {
        }

        @Generated
        public static abstract class CacheBuilder<C extends Cache, B extends CacheBuilder<C, B>> {
            @Generated
            private Property<Duration> ttl;
            @Generated
            private Property<List<String>> patterns;

            @Generated
            public B ttl(Property<Duration> ttl) {
                this.ttl = ttl;
                return this.self();
            }

            @Generated
            public B patterns(Property<List<String>> patterns) {
                this.patterns = patterns;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "WorkingDirectory.Cache.CacheBuilder(ttl=" + String.valueOf(this.ttl) + ", patterns=" + String.valueOf(this.patterns) + ")";
            }
        }

        @Generated
        private static final class CacheBuilderImpl
        extends CacheBuilder<Cache, CacheBuilderImpl> {
            @Generated
            private CacheBuilderImpl() {
            }

            @Override
            @Generated
            protected CacheBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Cache build() {
                return new Cache(this);
            }
        }
    }

    public static class Outputs
    extends VoidOutput {
        @Schema(title="The URIs for output files")
        private final Map<String, URI> outputFiles;

        public Outputs(Map<String, URI> outputsFiles) {
            this.outputFiles = outputsFiles;
        }

        @Generated
        public Map<String, URI> getOutputFiles() {
            return this.outputFiles;
        }
    }

    @Generated
    public static abstract class WorkingDirectoryBuilder<C extends WorkingDirectory, B extends WorkingDirectoryBuilder<C, B>>
    extends Sequential.SequentialBuilder<C, B> {
        @Generated
        private Cache cache;
        @Generated
        private NamespaceFiles namespaceFiles;
        @Generated
        private boolean cacheDownloadedTime$set;
        @Generated
        private long cacheDownloadedTime$value;
        @Generated
        private Object inputFiles;
        @Generated
        private Property<List<String>> outputFiles;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            WorkingDirectoryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(WorkingDirectory instance, WorkingDirectoryBuilder<?, ?> b) {
            b.cache(instance.cache);
            b.namespaceFiles(instance.namespaceFiles);
            b.cacheDownloadedTime(instance.cacheDownloadedTime);
            b.inputFiles(instance.inputFiles);
            b.outputFiles(instance.outputFiles);
        }

        @Generated
        public B cache(Cache cache) {
            this.cache = cache;
            return (B)this.self();
        }

        @Generated
        public B namespaceFiles(NamespaceFiles namespaceFiles) {
            this.namespaceFiles = namespaceFiles;
            return (B)this.self();
        }

        @Generated
        public B cacheDownloadedTime(long cacheDownloadedTime) {
            this.cacheDownloadedTime$value = cacheDownloadedTime;
            this.cacheDownloadedTime$set = true;
            return (B)this.self();
        }

        @Generated
        public B inputFiles(Object inputFiles) {
            this.inputFiles = inputFiles;
            return (B)this.self();
        }

        @Generated
        public B outputFiles(Property<List<String>> outputFiles) {
            this.outputFiles = outputFiles;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "WorkingDirectory.WorkingDirectoryBuilder(super=" + super.toString() + ", cache=" + String.valueOf(this.cache) + ", namespaceFiles=" + String.valueOf(this.namespaceFiles) + ", cacheDownloadedTime$value=" + this.cacheDownloadedTime$value + ", inputFiles=" + String.valueOf(this.inputFiles) + ", outputFiles=" + String.valueOf(this.outputFiles) + ")";
        }
    }

    @Generated
    private static final class WorkingDirectoryBuilderImpl
    extends WorkingDirectoryBuilder<WorkingDirectory, WorkingDirectoryBuilderImpl> {
        @Generated
        private WorkingDirectoryBuilderImpl() {
        }

        @Override
        @Generated
        protected WorkingDirectoryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public WorkingDirectory build() {
            return new WorkingDirectory(this);
        }
    }
}

