/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.log;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.FlowService;
import io.kestra.core.services.LogService;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.event.Level;

@Schema(title="Purge flow execution logs and trigger-related logs.", description="This task can be used to purge flow execution and trigger logs for all flows, for a specific namespace, or for a specific flow.")
@Plugin(examples={@Example(title="Purge all logs that has been created more than one month ago.", code={"endDate: \"{{ now() | dateAdd(-1, 'MONTHS') }}\""}), @Example(title="Purge all logs that has been created more than one month ago, but keep error logs.", code={"endDate: \"{{ now() | dateAdd(-1, 'MONTHS') }}\"", "logLevels:", "  - TRACE", "  - DEBUG", "  - INFO", "  - WARN"})})
public class PurgeLogs
extends Task
implements RunnableTask<Output> {
    @Schema(title="Namespace of logs that need to be purged", description="If `flowId` isn't provided, this is a namespace prefix, else the namespace of the flow.")
    private Property<String> namespace;
    @Schema(title="The flow ID of the logs to be purged", description="You need to provide the `namespace` property if you want to purge flow logs.")
    private Property<String> flowId;
    @Schema(title="The Execution ID of the logs to be purged")
    private Property<String> executionId;
    @Schema(title="The levels of the logs to be purged", description="If not set, log for all levels will be purged.")
    private Property<List<Level>> logLevels;
    @Schema(title="The minimum date to be purged", description="All logs after this date will be purged.")
    private Property<String> startDate;
    @Schema(title="The maximum date to be purged", description="All logs before this date will be purged.")
    @NotNull
    private Property<String> endDate;

    @Override
    public Output run(RunContext runContext) throws Exception {
        LogService logService = (LogService)((DefaultRunContext)runContext).getApplicationContext().getBean(LogService.class);
        FlowService flowService = (FlowService)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowService.class);
        RunContext.FlowInfo flowInfo = runContext.flowInfo();
        if (this.namespace == null) {
            flowService.checkAllowedAllNamespaces(flowInfo.tenantId(), flowInfo.tenantId(), flowInfo.namespace());
        } else if (!flowInfo.namespace().equals(runContext.render(this.namespace).as(String.class).orElse(null))) {
            flowService.checkAllowedNamespace(flowInfo.tenantId(), runContext.render(this.namespace).as(String.class).orElse(null), flowInfo.tenantId(), flowInfo.namespace());
        }
        List<Level> logLevelsRendered = runContext.render(this.logLevels).asList(Level.class);
        String renderedDate = runContext.render(this.startDate).as(String.class).orElse(null);
        int deleted = logService.purge(flowInfo.tenantId(), runContext.render(this.namespace).as(String.class).orElse(null), runContext.render(this.flowId).as(String.class).orElse(null), runContext.render(this.executionId).as(String.class).orElse(null), logLevelsRendered.isEmpty() ? null : logLevelsRendered, renderedDate != null ? ZonedDateTime.parse(renderedDate) : null, ZonedDateTime.parse(runContext.render(this.endDate).as(String.class).orElseThrow()));
        return ((Output.OutputBuilder)Output.builder().count(deleted)).build();
    }

    @Generated
    protected PurgeLogs(PurgeLogsBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.executionId = b.executionId;
        this.logLevels = b.logLevels;
        this.startDate = b.startDate;
        this.endDate = b.endDate;
    }

    @Generated
    public static PurgeLogsBuilder<?, ?> builder() {
        return new PurgeLogsBuilderImpl();
    }

    @Generated
    public String toString() {
        return "PurgeLogs(super=" + super.toString() + ", namespace=" + String.valueOf(this.getNamespace()) + ", flowId=" + String.valueOf(this.getFlowId()) + ", executionId=" + String.valueOf(this.getExecutionId()) + ", logLevels=" + String.valueOf(this.getLogLevels()) + ", startDate=" + String.valueOf(this.getStartDate()) + ", endDate=" + String.valueOf(this.getEndDate()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PurgeLogs)) {
            return false;
        }
        PurgeLogs other = (PurgeLogs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$namespace = this.getNamespace();
        Property<String> other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !((Object)this$namespace).equals(other$namespace)) {
            return false;
        }
        Property<String> this$flowId = this.getFlowId();
        Property<String> other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !((Object)this$flowId).equals(other$flowId)) {
            return false;
        }
        Property<String> this$executionId = this.getExecutionId();
        Property<String> other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !((Object)this$executionId).equals(other$executionId)) {
            return false;
        }
        Property<List<Level>> this$logLevels = this.getLogLevels();
        Property<List<Level>> other$logLevels = other.getLogLevels();
        if (this$logLevels == null ? other$logLevels != null : !((Object)this$logLevels).equals(other$logLevels)) {
            return false;
        }
        Property<String> this$startDate = this.getStartDate();
        Property<String> other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Property<String> this$endDate = this.getEndDate();
        Property<String> other$endDate = other.getEndDate();
        return !(this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PurgeLogs;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : ((Object)$namespace).hashCode());
        Property<String> $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : ((Object)$flowId).hashCode());
        Property<String> $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : ((Object)$executionId).hashCode());
        Property<List<Level>> $logLevels = this.getLogLevels();
        result = result * 59 + ($logLevels == null ? 43 : ((Object)$logLevels).hashCode());
        Property<String> $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Property<String> $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        return result;
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Property<String> getFlowId() {
        return this.flowId;
    }

    @Generated
    public Property<String> getExecutionId() {
        return this.executionId;
    }

    @Generated
    public Property<List<Level>> getLogLevels() {
        return this.logLevels;
    }

    @Generated
    public Property<String> getStartDate() {
        return this.startDate;
    }

    @Generated
    public Property<String> getEndDate() {
        return this.endDate;
    }

    @Generated
    public PurgeLogs() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The count of deleted logs")
        private int count;

        @Generated
        protected Output(OutputBuilder<?, ?> b) {
            this.count = b.count;
        }

        @Generated
        public static OutputBuilder<?, ?> builder() {
            return new OutputBuilderImpl();
        }

        @Generated
        public OutputBuilder<?, ?> toBuilder() {
            return new OutputBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public int getCount() {
            return this.count;
        }

        @Generated
        public static abstract class OutputBuilder<C extends Output, B extends OutputBuilder<C, B>> {
            @Generated
            private int count;

            @Generated
            protected B $fillValuesFrom(C instance) {
                OutputBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Output instance, OutputBuilder<?, ?> b) {
                b.count(instance.count);
            }

            @Generated
            public B count(int count) {
                this.count = count;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "PurgeLogs.Output.OutputBuilder(count=" + this.count + ")";
            }
        }

        @Generated
        private static final class OutputBuilderImpl
        extends OutputBuilder<Output, OutputBuilderImpl> {
            @Generated
            private OutputBuilderImpl() {
            }

            @Override
            @Generated
            protected OutputBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Output build() {
                return new Output(this);
            }
        }
    }

    @Generated
    public static abstract class PurgeLogsBuilder<C extends PurgeLogs, B extends PurgeLogsBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> namespace;
        @Generated
        private Property<String> flowId;
        @Generated
        private Property<String> executionId;
        @Generated
        private Property<List<Level>> logLevels;
        @Generated
        private Property<String> startDate;
        @Generated
        private Property<String> endDate;

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B flowId(Property<String> flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B executionId(Property<String> executionId) {
            this.executionId = executionId;
            return (B)this.self();
        }

        @Generated
        public B logLevels(Property<List<Level>> logLevels) {
            this.logLevels = logLevels;
            return (B)this.self();
        }

        @Generated
        public B startDate(Property<String> startDate) {
            this.startDate = startDate;
            return (B)this.self();
        }

        @Generated
        public B endDate(Property<String> endDate) {
            this.endDate = endDate;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PurgeLogs.PurgeLogsBuilder(super=" + super.toString() + ", namespace=" + String.valueOf(this.namespace) + ", flowId=" + String.valueOf(this.flowId) + ", executionId=" + String.valueOf(this.executionId) + ", logLevels=" + String.valueOf(this.logLevels) + ", startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ")";
        }
    }

    @Generated
    private static final class PurgeLogsBuilderImpl
    extends PurgeLogsBuilder<PurgeLogs, PurgeLogsBuilderImpl> {
        @Generated
        private PurgeLogsBuilderImpl() {
        }

        @Override
        @Generated
        protected PurgeLogsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PurgeLogs build() {
            return new PurgeLogs(this);
        }
    }
}

