/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.namespace;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.Namespace;
import io.kestra.core.storages.NamespaceFile;
import io.kestra.core.utils.PathMatcherPredicate;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;

@Schema(title="Delete one or multiple files from your namespace files.")
@Plugin(examples={@Example(title="Delete namespace files that match a specific regex glob pattern.", full=true, code={"id: delete_files\nnamespace: company.team\ntasks:\n  - id: delete\n    type: io.kestra.plugin.core.namespace.DeleteFiles\n    namespace: tutorial\n    files:\n      - \"**.upl\"\n"}), @Example(title="Delete all namespace files from a specific namespace.", full=true, code={"id: delete_all_files\nnamespace: company.team\ntasks:\n  - id: delete\n    type: io.kestra.plugin.core.namespace.DeleteFiles\n    namespace: tutorial\n    files:\n      - \"**\"\n"})})
public class DeleteFiles
extends Task
implements RunnableTask<Output> {
    @NotNull
    @Schema(title="The namespace from which the files should be deleted")
    private Property<String> namespace;
    @NotNull
    @Schema(title="A file or a list of files from the given namespace", description="String or a list of strings; each string can either be a regex glob pattern or a file path URI.", anyOf={List.class, String.class})
    @PluginProperty(dynamic=true)
    private Object files;
    @Schema(title="Flag specifying whether to delete empty parent folders after deleting files", description="If true, parent folders that become empty after file deletion will also be removed.", defaultValue="false")
    private Property<Boolean> deleteParentFolder;

    @Override
    public Output run(RunContext runContext) throws Exception {
        List<String> renderedFiles;
        Logger logger = runContext.logger();
        String renderedNamespace = runContext.render(this.namespace).as(String.class).orElseThrow();
        Namespace namespace = runContext.storage().namespace(renderedNamespace);
        Object object = this.files;
        if (object instanceof String) {
            String filesString = (String)object;
            renderedFiles = List.of(runContext.render(filesString));
        } else {
            object = this.files;
            if (object instanceof List) {
                List filesList = (List)object;
                renderedFiles = runContext.render(filesList);
            } else {
                throw new IllegalArgumentException("Files must be a String or a list of String");
            }
        }
        Boolean deleteParent = runContext.render(this.deleteParentFolder).as(Boolean.class).orElseThrow();
        List<NamespaceFile> matched = namespace.findAllFilesMatching(PathMatcherPredicate.matches(renderedFiles));
        TreeSet<String> parentFolders = Boolean.TRUE.equals(deleteParent) ? new TreeSet<String>() : null;
        long count = matched.stream().map(Rethrow.throwFunction(file -> {
            if (namespace.delete(NamespaceFile.of(renderedNamespace, Path.of(file.path().replace("\\", "/"), new String[0])).storagePath())) {
                logger.debug(String.format("Deleted %s", file.path()));
                if (Boolean.TRUE.equals(deleteParent)) {
                    this.trackParentFolder((NamespaceFile)file, (Set<String>)parentFolders);
                }
                return true;
            }
            return false;
        })).filter(Boolean::booleanValue).count();
        if (parentFolders != null && !parentFolders.isEmpty()) {
            this.deleteEmptyFolders(namespace, parentFolders, logger);
        }
        runContext.metric(Counter.of("deleted", count, new String[0]));
        return Output.builder().build();
    }

    private void deleteEmptyFolders(Namespace namespace, Set<String> folders, Logger logger) {
        folders.stream().sorted((a, b) -> b.split("/").length - a.split("/").length).forEach(folderPath -> {
            try {
                NamespaceFile folder;
                if (namespace.isDirectoryEmpty((String)folderPath) && namespace.deleteDirectory(folder = NamespaceFile.of(namespace.namespace(), URI.create(folderPath + "/")))) {
                    logger.debug("Deleted empty folder: {}", folderPath);
                }
            }
            catch (IOException e) {
                logger.warn("Failed to delete folder: " + folderPath, (Throwable)e);
            }
        });
    }

    private void trackParentFolder(NamespaceFile file, Set<String> parentFolders) {
        String path = file.path();
        int lastSlash = path.lastIndexOf(47);
        while (lastSlash > 0) {
            path = path.substring(0, lastSlash);
            parentFolders.add(path);
            lastSlash = path.lastIndexOf(47);
        }
    }

    @Generated
    private static Property<Boolean> $default$deleteParentFolder() {
        return Property.ofValue(false);
    }

    @Generated
    protected DeleteFiles(DeleteFilesBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.files = b.files;
        this.deleteParentFolder = b.deleteParentFolder$set ? b.deleteParentFolder$value : DeleteFiles.$default$deleteParentFolder();
    }

    @Generated
    public static DeleteFilesBuilder<?, ?> builder() {
        return new DeleteFilesBuilderImpl();
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Object getFiles() {
        return this.files;
    }

    @Generated
    public Property<Boolean> getDeleteParentFolder() {
        return this.deleteParentFolder;
    }

    @Generated
    public DeleteFiles() {
        this.deleteParentFolder = DeleteFiles.$default$deleteParentFolder();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        private final Map<String, URI> files;

        @ConstructorProperties(value={"files"})
        @Generated
        Output(Map<String, URI> files) {
            this.files = files;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Map<String, URI> getFiles() {
            return this.files;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Map<String, URI> files;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder files(Map<String, URI> files) {
                this.files = files;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.files);
            }

            @Generated
            public String toString() {
                return "DeleteFiles.Output.OutputBuilder(files=" + String.valueOf(this.files) + ")";
            }
        }
    }

    @Generated
    public static abstract class DeleteFilesBuilder<C extends DeleteFiles, B extends DeleteFilesBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> namespace;
        @Generated
        private Object files;
        @Generated
        private boolean deleteParentFolder$set;
        @Generated
        private Property<Boolean> deleteParentFolder$value;

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B files(Object files) {
            this.files = files;
            return (B)this.self();
        }

        @Generated
        public B deleteParentFolder(Property<Boolean> deleteParentFolder) {
            this.deleteParentFolder$value = deleteParentFolder;
            this.deleteParentFolder$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DeleteFiles.DeleteFilesBuilder(super=" + super.toString() + ", namespace=" + String.valueOf(this.namespace) + ", files=" + String.valueOf(this.files) + ", deleteParentFolder$value=" + String.valueOf(this.deleteParentFolder$value) + ")";
        }
    }

    @Generated
    private static final class DeleteFilesBuilderImpl
    extends DeleteFilesBuilder<DeleteFiles, DeleteFilesBuilderImpl> {
        @Generated
        private DeleteFilesBuilderImpl() {
        }

        @Override
        @Generated
        protected DeleteFilesBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DeleteFiles build() {
            return new DeleteFiles(this);
        }
    }
}

