/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.state;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.runners.RunContext;
import io.kestra.plugin.core.state.AbstractState;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.io.FileNotFoundException;
import lombok.Generated;

@Schema(title="Delete a state from the state store (Deprecated).")
@Plugin(examples={@Example(title="Delete the default state for the current flow.", code={"id: delete_state", "type: io.kestra.plugin.core.state.Delete"}, full=true), @Example(title="Delete the `myState` state for the current flow.", code={"id: delete_state", "type: io.kestra.plugin.core.state.Delete", "name: myState"}, full=true)}, aliases={"io.kestra.core.tasks.states.Delete"})
public class Delete
extends AbstractState
implements RunnableTask<Output> {
    @Schema(title="Raise an error if the state is not found.")
    private final Property<Boolean> errorOnMissing;

    @Override
    public Output run(RunContext runContext) throws Exception {
        boolean delete = this.delete(runContext);
        if (Boolean.TRUE.equals(runContext.render(this.errorOnMissing).as(Boolean.class).orElseThrow()) && !delete) {
            throw new FileNotFoundException("Unable to find the state file '" + runContext.render(this.name).as(String.class).orElseThrow() + "'");
        }
        return Output.builder().deleted(delete).build();
    }

    @Generated
    private static Property<Boolean> $default$errorOnMissing() {
        return Property.ofValue(false);
    }

    @Generated
    protected Delete(DeleteBuilder<?, ?> b) {
        super((AbstractState.AbstractStateBuilder<?, ?>)b);
        this.errorOnMissing = b.errorOnMissing$set ? b.errorOnMissing$value : Delete.$default$errorOnMissing();
    }

    @Generated
    public static DeleteBuilder<?, ?> builder() {
        return new DeleteBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "Delete(super=" + super.toString() + ", errorOnMissing=" + String.valueOf(this.getErrorOnMissing()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Delete)) {
            return false;
        }
        Delete other = (Delete)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Boolean> this$errorOnMissing = this.getErrorOnMissing();
        Property<Boolean> other$errorOnMissing = other.getErrorOnMissing();
        return !(this$errorOnMissing == null ? other$errorOnMissing != null : !((Object)this$errorOnMissing).equals(other$errorOnMissing));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Delete;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Boolean> $errorOnMissing = this.getErrorOnMissing();
        result = result * 59 + ($errorOnMissing == null ? 43 : ((Object)$errorOnMissing).hashCode());
        return result;
    }

    @Generated
    public Property<Boolean> getErrorOnMissing() {
        return this.errorOnMissing;
    }

    @Generated
    public Delete() {
        this.errorOnMissing = Delete.$default$errorOnMissing();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="Flag specifying whether the state file was deleted")
        private final Boolean deleted;

        @ConstructorProperties(value={"deleted"})
        @Generated
        Output(Boolean deleted) {
            this.deleted = deleted;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Boolean getDeleted() {
            return this.deleted;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Boolean deleted;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder deleted(Boolean deleted) {
                this.deleted = deleted;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.deleted);
            }

            @Generated
            public String toString() {
                return "Delete.Output.OutputBuilder(deleted=" + this.deleted + ")";
            }
        }
    }

    @Generated
    public static abstract class DeleteBuilder<C extends Delete, B extends DeleteBuilder<C, B>>
    extends AbstractState.AbstractStateBuilder<C, B> {
        @Generated
        private boolean errorOnMissing$set;
        @Generated
        private Property<Boolean> errorOnMissing$value;

        @Generated
        public B errorOnMissing(Property<Boolean> errorOnMissing) {
            this.errorOnMissing$value = errorOnMissing;
            this.errorOnMissing$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Delete.DeleteBuilder(super=" + super.toString() + ", errorOnMissing$value=" + String.valueOf(this.errorOnMissing$value) + ")";
        }
    }

    @Generated
    private static final class DeleteBuilderImpl
    extends DeleteBuilder<Delete, DeleteBuilderImpl> {
        @Generated
        private DeleteBuilderImpl() {
        }

        @Override
        @Generated
        protected DeleteBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Delete build() {
            return new Delete(this);
        }
    }
}

