/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.StorageService;
import io.kestra.core.storages.StorageSplitInterface;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.List;
import lombok.Generated;

@Schema(title="Split a file from Kestra's internal storage into multiple files.")
@Plugin(examples={@Example(title="Split a file by size.", code={"from: \"kestra://long/url/file1.txt\"", "bytes: 10MB"}), @Example(title="Split a file by rows count.", code={"from: \"kestra://long/url/file1.txt\"", "rows: 1000"}), @Example(title="Split a file in a defined number of partitions.", code={"from: \"kestra://long/url/file1.txt\"", "partitions: 8"})}, aliases={"io.kestra.core.tasks.storages.Split"})
public class Split
extends Task
implements RunnableTask<Output>,
StorageSplitInterface {
    @Schema(title="The file to be split")
    @NotNull
    @PluginProperty(internalStorageURI=true)
    private Property<String> from;
    private Property<String> bytes;
    private Property<Integer> partitions;
    private Property<Integer> rows;
    private Property<String> separator;

    @Override
    public Output run(RunContext runContext) throws Exception {
        URI from = new URI(runContext.render(this.from).as(String.class).orElseThrow());
        return Output.builder().uris(StorageService.split(runContext, this, from)).build();
    }

    @Generated
    private static Property<String> $default$separator() {
        return Property.ofValue("\n");
    }

    @Generated
    protected Split(SplitBuilder<?, ?> b) {
        super(b);
        this.from = b.from;
        this.bytes = b.bytes;
        this.partitions = b.partitions;
        this.rows = b.rows;
        this.separator = b.separator$set ? b.separator$value : Split.$default$separator();
    }

    @Generated
    public static SplitBuilder<?, ?> builder() {
        return new SplitBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Split(super=" + super.toString() + ", from=" + String.valueOf(this.getFrom()) + ", bytes=" + String.valueOf(this.getBytes()) + ", partitions=" + String.valueOf(this.getPartitions()) + ", rows=" + String.valueOf(this.getRows()) + ", separator=" + String.valueOf(this.getSeparator()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Split)) {
            return false;
        }
        Split other = (Split)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$from = this.getFrom();
        Property<String> other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Property<String> this$bytes = this.getBytes();
        Property<String> other$bytes = other.getBytes();
        if (this$bytes == null ? other$bytes != null : !((Object)this$bytes).equals(other$bytes)) {
            return false;
        }
        Property<Integer> this$partitions = this.getPartitions();
        Property<Integer> other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        Property<Integer> this$rows = this.getRows();
        Property<Integer> other$rows = other.getRows();
        if (this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows)) {
            return false;
        }
        Property<String> this$separator = this.getSeparator();
        Property<String> other$separator = other.getSeparator();
        return !(this$separator == null ? other$separator != null : !((Object)this$separator).equals(other$separator));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Split;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Property<String> $bytes = this.getBytes();
        result = result * 59 + ($bytes == null ? 43 : ((Object)$bytes).hashCode());
        Property<Integer> $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        Property<Integer> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        Property<String> $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : ((Object)$separator).hashCode());
        return result;
    }

    @Generated
    public Property<String> getFrom() {
        return this.from;
    }

    @Override
    @Generated
    public Property<String> getBytes() {
        return this.bytes;
    }

    @Override
    @Generated
    public Property<Integer> getPartitions() {
        return this.partitions;
    }

    @Override
    @Generated
    public Property<Integer> getRows() {
        return this.rows;
    }

    @Override
    @Generated
    public Property<String> getSeparator() {
        return this.separator;
    }

    @Generated
    public Split() {
        this.separator = Split.$default$separator();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The URIs of split files in Kestra's internal storage")
        private final List<URI> uris;

        @ConstructorProperties(value={"uris"})
        @Generated
        Output(List<URI> uris) {
            this.uris = uris;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public List<URI> getUris() {
            return this.uris;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private List<URI> uris;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uris(List<URI> uris) {
                this.uris = uris;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uris);
            }

            @Generated
            public String toString() {
                return "Split.Output.OutputBuilder(uris=" + String.valueOf(this.uris) + ")";
            }
        }
    }

    @Generated
    public static abstract class SplitBuilder<C extends Split, B extends SplitBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> from;
        @Generated
        private Property<String> bytes;
        @Generated
        private Property<Integer> partitions;
        @Generated
        private Property<Integer> rows;
        @Generated
        private boolean separator$set;
        @Generated
        private Property<String> separator$value;

        @Generated
        public B from(Property<String> from) {
            this.from = from;
            return (B)this.self();
        }

        @Generated
        public B bytes(Property<String> bytes) {
            this.bytes = bytes;
            return (B)this.self();
        }

        @Generated
        public B partitions(Property<Integer> partitions) {
            this.partitions = partitions;
            return (B)this.self();
        }

        @Generated
        public B rows(Property<Integer> rows) {
            this.rows = rows;
            return (B)this.self();
        }

        @Generated
        public B separator(Property<String> separator) {
            this.separator$value = separator;
            this.separator$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Split.SplitBuilder(super=" + super.toString() + ", from=" + String.valueOf(this.from) + ", bytes=" + String.valueOf(this.bytes) + ", partitions=" + String.valueOf(this.partitions) + ", rows=" + String.valueOf(this.rows) + ", separator$value=" + String.valueOf(this.separator$value) + ")";
        }
    }

    @Generated
    private static final class SplitBuilderImpl
    extends SplitBuilder<Split, SplitBuilderImpl> {
        @Generated
        private SplitBuilderImpl() {
        }

        @Override
        @Generated
        protected SplitBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Split build() {
            return new Split(this);
        }
    }
}

