/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.storage;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;

@Schema(title="Write data to a file in Kestra\u2019s internal storage.", description="Use the Write task to store outputs as files internally and then reference the stored file for processing further down your flow.")
@Plugin(examples={@Example(title="Write data to a file in the internal storage.", full=true, code={"id: write\nnamespace: company.team\n\ntasks:\n- id: write\n  type: io.kestra.plugin.core.storage.Write\n  content: Hello World\n  extension: .txt"})})
public class Write
extends Task
implements RunnableTask<Output> {
    @Schema(title="The file content")
    @NotNull
    private Property<String> content;
    @Schema(title="The file extension")
    private Property<String> extension;

    @Override
    public Output run(RunContext runContext) throws Exception {
        byte[] bytes = runContext.render(this.content).as(String.class).map(s -> s.getBytes()).orElseThrow();
        Optional<String> maybeExtension = runContext.render(this.extension).as(String.class);
        Path path = maybeExtension.map(Rethrow.throwFunction(ext -> runContext.workingDir().createTempFile(bytes, (String)ext))).orElseGet(Rethrow.throwSupplier(() -> runContext.workingDir().createTempFile(bytes)));
        return Output.builder().uri(runContext.storage().putFile(path.toFile())).build();
    }

    @Generated
    protected Write(WriteBuilder<?, ?> b) {
        super(b);
        this.content = b.content;
        this.extension = b.extension;
    }

    @Generated
    public static WriteBuilder<?, ?> builder() {
        return new WriteBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Write(super=" + super.toString() + ", content=" + String.valueOf(this.getContent()) + ", extension=" + String.valueOf(this.getExtension()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Write)) {
            return false;
        }
        Write other = (Write)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$content = this.getContent();
        Property<String> other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        Property<String> this$extension = this.getExtension();
        Property<String> other$extension = other.getExtension();
        return !(this$extension == null ? other$extension != null : !((Object)this$extension).equals(other$extension));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Write;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        Property<String> $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : ((Object)$extension).hashCode());
        return result;
    }

    @Generated
    public Property<String> getContent() {
        return this.content;
    }

    @Generated
    public Property<String> getExtension() {
        return this.extension;
    }

    @Generated
    public Write() {
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The created file URI")
        private final URI uri;

        @ConstructorProperties(value={"uri"})
        @Generated
        Output(URI uri) {
            this.uri = uri;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public URI getUri() {
            return this.uri;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private URI uri;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.uri);
            }

            @Generated
            public String toString() {
                return "Write.Output.OutputBuilder(uri=" + String.valueOf(this.uri) + ")";
            }
        }
    }

    @Generated
    public static abstract class WriteBuilder<C extends Write, B extends WriteBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> content;
        @Generated
        private Property<String> extension;

        @Generated
        public B content(Property<String> content) {
            this.content = content;
            return (B)this.self();
        }

        @Generated
        public B extension(Property<String> extension) {
            this.extension = extension;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Write.WriteBuilder(super=" + super.toString() + ", content=" + String.valueOf(this.content) + ", extension=" + String.valueOf(this.extension) + ")";
        }
    }

    @Generated
    private static final class WriteBuilderImpl
    extends WriteBuilder<Write, WriteBuilderImpl> {
        @Generated
        private WriteBuilderImpl() {
        }

        @Override
        @Generated
        protected WriteBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Write build() {
            return new Write(this);
        }
    }
}

