/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.trigger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.Label;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TimeWindow;
import io.kestra.core.models.triggers.TriggerOutput;
import io.kestra.core.models.triggers.multipleflows.MultipleCondition;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionStorageInterface;
import io.kestra.core.models.triggers.multipleflows.MultipleConditionWindow;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.LabelService;
import io.kestra.core.topologies.FlowTopologyService;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.MapUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.utils.TruthUtils;
import io.kestra.core.validations.PreconditionFilterValidation;
import io.micronaut.core.annotation.Nullable;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.ConstructorProperties;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.stream.Streams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(title="Trigger a flow in response to a state change in one or more other flows.", description="You can trigger a flow as soon as another flow ends. This allows you to add implicit dependencies between multiple flows, which can often be managed by different teams.\n\nA flow trigger must have `preconditions` which filter on other flow executions.\nIt can also have standard trigger `conditions`. Neither condition type can use Pebble templating expressions; they must be declaratively defined.\nUpstream execution outputs will be available in a `trigger.outputs` variable.")
@Plugin(examples={@Example(full=true, title="1) Trigger the `transform` flow after the `extract` flow finishes successfully. The `extract` flow generates a `date` output that is passed to the `transform` flow as an input. \n```yaml\nid: extract\nnamespace: company.team\n\ntasks:\n  - id: final_date\n    type: io.kestra.plugin.core.debug.Return\n    format: \"{{ execution.startDate | dateAdd(-2, 'DAYS') | date('yyyy-MM-dd') }}\"\n\noutputs:\n  - id: date\n    type: STRING\n    value: \"{{ outputs.final_date.value }}\"\n```\n\nThe `transform` flow is triggered after the `extract` flow finishes successfully.", code={"id: transform\nnamespace: company.team\n\ninputs:\n  - id: date\n    type: STRING\n    defaults: \"2025-01-01\"\n\nvariables:\n  result: |\n    Ingestion done in {{ trigger.executionId }}.\n    Now transforming data up to {{ inputs.date }}\n\ntasks:\n  - id: run_transform\n    type: io.kestra.plugin.core.debug.Return\n    format: \"{{ render(vars.result) }}\"\n\n  - id: log\n    type: io.kestra.plugin.core.log.Log\n    message: \"{{ render(vars.result) }}\"\n\ntriggers:\n  - id: run_after_extract\n    type: io.kestra.plugin.core.trigger.Flow\n    inputs:\n      date: \"{{ trigger.outputs.date }}\"\n    preconditions:\n      id: flows\n      flows:\n        - namespace: company.team\n          flowId: extract\n          states: [SUCCESS]"}), @Example(full=true, title="2) Trigger the `silver_layer` flow once the `bronze_layer` flow finishes successfully by 9 AM.\n\n```yaml\nid: bronze_layer\nnamespace: company.team\n\ntasks:\n  - id: raw_data\n    type: io.kestra.plugin.core.log.Log\n    message: Ingesting raw data\n```", code={"id: silver_layer\nnamespace: company.team\n\ntasks:\n  - id: transform_data\n    type: io.kestra.plugin.core.log.Log\n    message: deduplication, cleaning, and minor aggregations\n\ntriggers:\n  - id: flow_trigger\n    type: io.kestra.plugin.core.trigger.Flow\n    preconditions:\n      id: bronze_layer\n      timeWindow:\n        type: DAILY_TIME_DEADLINE\n        deadline: \"09:00:00\"\n      flows:\n        - namespace: company.team\n          flowId: bronze_layer\n          states: [SUCCESS]"}), @Example(full=true, title="3) Create a `System Flow` to send a Slack alert on any failure or warning state within the `company` namespace. This example uses the Slack webhook secret to notify the `#general` channel about the failed flow.", code={"id: alert\nnamespace: system\n\ntasks:\n  - id: send_alert\n    type: io.kestra.plugin.notifications.slack.SlackExecution\n    url: \"{{secret('SLACK_WEBHOOK')}}\" # format: https://hooks.slack.com/services/xzy/xyz/xyz\n    channel: \"#general\"\n    executionId: \"{{trigger.executionId}}\"\n\ntriggers:\n  - id: alert_on_failure\n    type: io.kestra.plugin.core.trigger.Flow\n    states:\n      - FAILED\n      - WARNING\n    preconditions:\n      id: company_namespace\n      where:\n        - id: company\n          filters:\n            - field: NAMESPACE\n              type: STARTS_WITH\n              value: company"}), @Example(full=true, title="4) Create a `System Flow` to send a Sentry issue on any failure or warning state within the `company.payroll` namespace. This example uses the Sentry Execution task and a Flow trigger with `conditions`.", code={"id: sentry_execution_example\nnamespace: company.team\n\ntasks:\n- id: send_alert\n  type: io.kestra.plugin.notifications.sentry.SentryExecution\n    executionId: \"{{ trigger.executionId }}\"\n    transaction: \"/execution/id/{{ trigger.executionId }}\"\n    dsn: \"{{ secret('SENTRY_DSN') }}\"\n    level: ERROR\n\ntriggers:\n- id: failed_prod_workflows\n    type: io.kestra.plugin.core.trigger.Flow\n    conditions:\n    - type: io.kestra.plugin.core.condition.ExecutionStatus\n        in:\n        - FAILED\n        - WARNING\n    - type: io.kestra.plugin.core.condition.ExecutionNamespace\n        namespace: company.payroll\n        prefix: false"})}, aliases={"io.kestra.core.models.triggers.types.Flow"})
public class Flow
extends AbstractTrigger
implements TriggerOutput<Output> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Flow.class);
    private static final String TRIGGER_VAR = "trigger";
    private static final String OUTPUTS_VAR = "outputs";
    @Nullable
    @Schema(title="Pass upstream flow's outputs to inputs of the current flow.", description="The inputs property passes data objects or a file to the downstream flow as long as those outputs are defined on the flow-level in the upstream flow.\n::alert{type=\"warning\"}\nMake sure that the inputs and task outputs defined in this Flow trigger match the outputs of the upstream flow. Otherwise, the downstream flow execution will not to be created. If that happens, go to the Logs tab on the Flow page to investigate the error.\n::")
    @PluginProperty
    private Map<String, Object> inputs;
    @Nullable
    @Schema(title="List of execution states that will be evaluated by the trigger", description="By default, only executions in a terminal state or in the PAUSED state will be evaluated.\nAny `ExecutionStatus`-type condition will be evaluated after the list of `states`. Note that a Flow trigger cannot react to the `CREATED` state because the Flow trigger reacts to state transitions. The `CREATED` state is the initial state of an execution and does not represent a state transition.\n::alert{type=\"info\"}\nThe trigger will be evaluated for each state change of matching executions. If a flow has two `Pause` tasks, the execution will transition from PAUSED to a RUNNING state twice \u2014 one for each Pause task. In this case, a Flow trigger listening to a `PAUSED` state will be evaluated twice.\n::")
    private List<State.Type> states;
    @Valid
    @Schema(title="Preconditions on upstream flow executions", description="Express preconditions to be met, on a time window, for the flow trigger to be evaluated.")
    @PluginProperty
    private Preconditions preconditions;

    public Optional<Execution> evaluate(Optional<MultipleConditionStorageInterface> multipleConditionStorage, RunContext runContext, io.kestra.core.models.flows.Flow flow, Execution current) {
        Logger logger = runContext.logger();
        Map<String, Object> outputs = current.getOutputs();
        if (multipleConditionStorage.isPresent()) {
            ArrayList<String> multipleConditionIds = new ArrayList<String>();
            if (this.preconditions != null) {
                multipleConditionIds.add(this.preconditions.getId());
            }
            ListUtils.emptyOnNull(this.conditions).stream().filter(condition -> condition instanceof io.kestra.plugin.core.condition.MultipleCondition).map(condition -> (io.kestra.plugin.core.condition.MultipleCondition)condition).forEach(condition -> multipleConditionIds.add(condition.getId()));
            for (String id : multipleConditionIds) {
                Optional<MultipleConditionWindow> multipleConditionWindow = multipleConditionStorage.get().get(flow, id);
                if (!multipleConditionWindow.isPresent()) continue;
                outputs = MapUtils.deepMerge(outputs, multipleConditionWindow.get().getOutputs());
            }
        }
        List<Label> labels = LabelService.fromTrigger(runContext, flow, this);
        Streams.of(current.getLabels()).filter(label -> label.key().equals("system.correlationId")).findFirst().ifPresent(label -> labels.add((Label)label));
        Execution.ExecutionBuilder builder = Execution.builder().id(IdUtils.create()).tenantId(flow.getTenantId()).namespace(flow.getNamespace()).flowId(flow.getId()).flowRevision(flow.getRevision()).labels(labels).state(new State()).trigger(ExecutionTrigger.of((AbstractTrigger)this, Output.builder().executionId(current.getId()).executionLabels(Label.toNestedMap(current.getLabels().stream().filter(label -> !label.key().equals("system.correlationId")).collect(Collectors.toList()))).namespace(current.getNamespace()).flowId(current.getFlowId()).flowRevision(current.getFlowRevision()).state(current.getState().getCurrent()).outputs(outputs).build()));
        try {
            if (this.inputs != null) {
                if (outputs != null && !outputs.isEmpty()) {
                    builder.inputs(runContext.render(this.inputs, Map.of(TRIGGER_VAR, Map.of(OUTPUTS_VAR, outputs))));
                } else {
                    builder.inputs(runContext.render(this.inputs));
                }
            } else {
                builder.inputs(new HashMap<String, Object>());
            }
            return Optional.of(builder.build());
        }
        catch (Exception e) {
            logger.warn("Failed to trigger flow {}.{} for trigger {}, invalid inputs", new Object[]{flow.getNamespace(), flow.getId(), this.getId(), e});
            return Optional.empty();
        }
    }

    @Generated
    private static List<State.Type> $default$states() {
        return ListUtils.concat(State.Type.terminatedTypes(), List.of(State.Type.PAUSED));
    }

    @Generated
    protected Flow(FlowBuilder<?, ?> b) {
        super(b);
        this.inputs = b.inputs;
        this.states = b.states$set ? b.states$value : Flow.$default$states();
        this.preconditions = b.preconditions;
    }

    @Generated
    public static FlowBuilder<?, ?> builder() {
        return new FlowBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Flow(super=" + super.toString() + ", inputs=" + String.valueOf(this.getInputs()) + ", states=" + String.valueOf(this.getStates()) + ", preconditions=" + String.valueOf(this.getPreconditions()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$inputs = this.getInputs();
        Map<String, Object> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        List<State.Type> this$states = this.getStates();
        List<State.Type> other$states = other.getStates();
        if (this$states == null ? other$states != null : !((Object)this$states).equals(other$states)) {
            return false;
        }
        Preconditions this$preconditions = this.getPreconditions();
        Preconditions other$preconditions = other.getPreconditions();
        return !(this$preconditions == null ? other$preconditions != null : !this$preconditions.equals(other$preconditions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Flow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        List<State.Type> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        Preconditions $preconditions = this.getPreconditions();
        result = result * 59 + ($preconditions == null ? 43 : $preconditions.hashCode());
        return result;
    }

    @Generated
    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    @Generated
    public List<State.Type> getStates() {
        return this.states;
    }

    @Generated
    public Preconditions getPreconditions() {
        return this.preconditions;
    }

    @Generated
    public Flow() {
        this.states = Flow.$default$states();
    }

    public static class Preconditions
    implements MultipleCondition {
        @NotNull
        @NotBlank
        @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9_-]*")
        @Schema(title="A unique id for the preconditions")
        @PluginProperty
        private @NotNull @NotBlank @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9_-]*") String id;
        @Schema(title="Define the time window for evaluating preconditions.", description="You can set the `type` of `timeWindow` to one of the following values:\n1. `DURATION_WINDOW`: this is the default `type`. It uses a start time (`windowAdvance`) and end time (`window`) that advance to the next interval whenever the evaluation time reaches the end time, based on the defined duration `window`. For example, with a 1-day window (the default option: `window: PT1D`), the preconditions are evaluated during a 24-hour period starting at midnight (i.e., at \"00:00:00+00:00\") each day. If you set `windowAdvance: PT6H`, the window will start at 6 AM each day. If you set `windowAdvance: PT6H` and also override the `window` property to `PT6H`, the window will start at 6 AM and last for 6 hours. In this configuration, the preconditions will be evaluated during the following intervals: 06:00 to 12:00, 12:00 to 18:00, 18:00 to 00:00, and 00:00 to 06:00.\n2. `SLIDING_WINDOW`: this option evaluates preconditions over a fixed time `window` but always goes backward from the current time. For example, a sliding window of 1 hour (`window: PT1H`) evaluates executions within the past hour (from one hour ago up to now). It uses a default window of 1 day.\n3. `DAILY_TIME_DEADLINE`: this option declares that preconditions should be met \"before a specific time in a day.\" Using the string property `deadline`, you can configure a daily cutoff for evaluating preconditions. For example, `deadline: \"09:00:00\"` specifies that preconditions must be met from midnight until 9 AM UTC time each day; otherwise, the flow will not be triggered.\n4. `DAILY_TIME_WINDOW`: this option declares that preconditions should be met \"within a specific time range in a day\". For example, a window from `startTime: \"06:00:00\"` to `endTime: \"09:00:00\"` evaluates executions within that interval each day. This option is particularly useful for defining freshness conditions declaratively when building data pipelines that span multiple teams and namespaces. Normally, a failure in any task in your flow will block the entire pipeline, but with this decoupled flow trigger alternative, you can proceed as soon as the data is successfully refreshed within the specified time window.")
        @PluginProperty
        @Valid
        protected TimeWindow timeWindow;
        @Schema(title="Whether to reset the evaluation results of preconditions after a first successful evaluation within the given time window", description="By default, after a successful evaluation of the set of preconditions, the evaluation result is reset. This means the same set of conditions needs to be successfully evaluated again within the same time window to trigger a new execution.\nIn this setup, to create multiple executions, the same set of conditions must be evaluated to `true` multiple times within the defined window.\nYou can disable this by setting this property to `false`, so that within the same window, each time one of the conditions is satisfied again after a successful evaluation, it will trigger a new execution.")
        @PluginProperty
        private Boolean resetOnSuccess;
        @Schema(title="A list of preconditions to meet, in the form of upstream flows")
        @PluginProperty
        private List<UpstreamFlow> flows;
        @Valid
        @PluginProperty
        @Schema(title="A list of preconditions to meet, in the form of execution filters")
        private List<ExecutionFilter> where;

        @Override
        @JsonIgnore
        public Map<String, Condition> getConditions() {
            AtomicInteger conditionId = new AtomicInteger();
            Map<String, Condition> flowsCondition = ListUtils.emptyOnNull(this.flows).stream().map(upstreamFlow -> Map.entry("condition_" + conditionId.incrementAndGet(), new UpstreamFlowCondition((UpstreamFlow)upstreamFlow))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, Condition> whereConditions = ListUtils.emptyOnNull(this.where).stream().map(filter -> Map.entry("condition_" + conditionId.incrementAndGet() + "_" + filter.getId(), new FilterCondition((ExecutionFilter)filter))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            HashMap<String, Condition> conditions = HashMap.newHashMap(flowsCondition.size() + whereConditions.size());
            conditions.putAll(flowsCondition);
            conditions.putAll(whereConditions);
            return conditions;
        }

        @JsonIgnore
        public Map<String, Condition> getUpstreamFlowsConditions() {
            AtomicInteger conditionId = new AtomicInteger();
            return ListUtils.emptyOnNull(this.flows).stream().map(upstreamFlow -> Map.entry("condition_" + conditionId.incrementAndGet(), new UpstreamFlowCondition((UpstreamFlow)upstreamFlow))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        @JsonIgnore
        public Map<String, Condition> getWhereConditions() {
            AtomicInteger conditionId = new AtomicInteger();
            return ListUtils.emptyOnNull(this.where).stream().map(filter -> Map.entry("condition_" + conditionId.incrementAndGet() + "_" + filter.getId(), new FilterCondition((ExecutionFilter)filter))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        @Override
        public Logger logger() {
            return log;
        }

        @Generated
        private static TimeWindow $default$timeWindow() {
            return TimeWindow.builder().build();
        }

        @Generated
        private static Boolean $default$resetOnSuccess() {
            return Boolean.TRUE;
        }

        @ConstructorProperties(value={"id", "timeWindow", "resetOnSuccess", "flows", "where"})
        @Generated
        Preconditions(String id, TimeWindow timeWindow, Boolean resetOnSuccess, List<UpstreamFlow> flows, List<ExecutionFilter> where) {
            this.id = id;
            this.timeWindow = timeWindow;
            this.resetOnSuccess = resetOnSuccess;
            this.flows = flows;
            this.where = where;
        }

        @Generated
        public static PreconditionsBuilder builder() {
            return new PreconditionsBuilder();
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }

        @Override
        @Generated
        public TimeWindow getTimeWindow() {
            return this.timeWindow;
        }

        @Override
        @Generated
        public Boolean getResetOnSuccess() {
            return this.resetOnSuccess;
        }

        @Generated
        public List<UpstreamFlow> getFlows() {
            return this.flows;
        }

        @Generated
        public List<ExecutionFilter> getWhere() {
            return this.where;
        }

        @Generated
        public static class PreconditionsBuilder {
            @Generated
            private String id;
            @Generated
            private boolean timeWindow$set;
            @Generated
            private TimeWindow timeWindow$value;
            @Generated
            private boolean resetOnSuccess$set;
            @Generated
            private Boolean resetOnSuccess$value;
            @Generated
            private List<UpstreamFlow> flows;
            @Generated
            private List<ExecutionFilter> where;

            @Generated
            PreconditionsBuilder() {
            }

            @Generated
            public PreconditionsBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public PreconditionsBuilder timeWindow(TimeWindow timeWindow) {
                this.timeWindow$value = timeWindow;
                this.timeWindow$set = true;
                return this;
            }

            @Generated
            public PreconditionsBuilder resetOnSuccess(Boolean resetOnSuccess) {
                this.resetOnSuccess$value = resetOnSuccess;
                this.resetOnSuccess$set = true;
                return this;
            }

            @Generated
            public PreconditionsBuilder flows(List<UpstreamFlow> flows) {
                this.flows = flows;
                return this;
            }

            @Generated
            public PreconditionsBuilder where(List<ExecutionFilter> where) {
                this.where = where;
                return this;
            }

            @Generated
            public Preconditions build() {
                TimeWindow timeWindow$value = this.timeWindow$value;
                if (!this.timeWindow$set) {
                    timeWindow$value = Preconditions.$default$timeWindow();
                }
                Boolean resetOnSuccess$value = this.resetOnSuccess$value;
                if (!this.resetOnSuccess$set) {
                    resetOnSuccess$value = Preconditions.$default$resetOnSuccess();
                }
                return new Preconditions(this.id, timeWindow$value, resetOnSuccess$value, this.flows, this.where);
            }

            @Generated
            public String toString() {
                return "Flow.Preconditions.PreconditionsBuilder(id=" + this.id + ", timeWindow$value=" + String.valueOf(this.timeWindow$value) + ", resetOnSuccess$value=" + this.resetOnSuccess$value + ", flows=" + String.valueOf(this.flows) + ", where=" + String.valueOf(this.where) + ")";
            }
        }
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The execution ID that triggered the current flow")
        @NotNull
        private String executionId;
        @Schema(title="The execution labels that triggered the current flow")
        @NotNull
        private Map<String, Object> executionLabels;
        @Schema(title="The execution state")
        @NotNull
        private State.Type state;
        @Schema(title="The namespace of the flow that triggered the current flow")
        @NotNull
        private String namespace;
        @Schema(title="The flow ID whose execution triggered the current flow")
        @NotNull
        private String flowId;
        @Schema(title="The flow revision that triggered the current flow")
        @NotNull
        private Integer flowRevision;
        @Schema(title="The extracted outputs from the flow that triggered the current flow")
        private Map<String, Object> outputs;

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public String toString() {
            return "Flow.Output(executionId=" + this.getExecutionId() + ", executionLabels=" + String.valueOf(this.getExecutionLabels()) + ", state=" + String.valueOf((Object)this.getState()) + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", flowRevision=" + this.getFlowRevision() + ", outputs=" + String.valueOf(this.getOutputs()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Output)) {
                return false;
            }
            Output other = (Output)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$flowRevision = this.getFlowRevision();
            Integer other$flowRevision = other.getFlowRevision();
            if (this$flowRevision == null ? other$flowRevision != null : !((Object)this$flowRevision).equals(other$flowRevision)) {
                return false;
            }
            String this$executionId = this.getExecutionId();
            String other$executionId = other.getExecutionId();
            if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
                return false;
            }
            Map<String, Object> this$executionLabels = this.getExecutionLabels();
            Map<String, Object> other$executionLabels = other.getExecutionLabels();
            if (this$executionLabels == null ? other$executionLabels != null : !((Object)this$executionLabels).equals(other$executionLabels)) {
                return false;
            }
            State.Type this$state = this.getState();
            State.Type other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$flowId = this.getFlowId();
            String other$flowId = other.getFlowId();
            if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
                return false;
            }
            Map<String, Object> this$outputs = this.getOutputs();
            Map<String, Object> other$outputs = other.getOutputs();
            return !(this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Output;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $flowRevision = this.getFlowRevision();
            result = result * 59 + ($flowRevision == null ? 43 : ((Object)$flowRevision).hashCode());
            String $executionId = this.getExecutionId();
            result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
            Map<String, Object> $executionLabels = this.getExecutionLabels();
            result = result * 59 + ($executionLabels == null ? 43 : ((Object)$executionLabels).hashCode());
            State.Type $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $flowId = this.getFlowId();
            result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
            Map<String, Object> $outputs = this.getOutputs();
            result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
            return result;
        }

        @Generated
        public String getExecutionId() {
            return this.executionId;
        }

        @Generated
        public Map<String, Object> getExecutionLabels() {
            return this.executionLabels;
        }

        @Generated
        public State.Type getState() {
            return this.state;
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getFlowId() {
            return this.flowId;
        }

        @Generated
        public Integer getFlowRevision() {
            return this.flowRevision;
        }

        @Generated
        public Map<String, Object> getOutputs() {
            return this.outputs;
        }

        @Generated
        public Output() {
        }

        @ConstructorProperties(value={"executionId", "executionLabels", "state", "namespace", "flowId", "flowRevision", "outputs"})
        @Generated
        public Output(String executionId, Map<String, Object> executionLabels, State.Type state, String namespace, String flowId, Integer flowRevision, Map<String, Object> outputs) {
            this.executionId = executionId;
            this.executionLabels = executionLabels;
            this.state = state;
            this.namespace = namespace;
            this.flowId = flowId;
            this.flowRevision = flowRevision;
            this.outputs = outputs;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private String executionId;
            @Generated
            private Map<String, Object> executionLabels;
            @Generated
            private State.Type state;
            @Generated
            private String namespace;
            @Generated
            private String flowId;
            @Generated
            private Integer flowRevision;
            @Generated
            private Map<String, Object> outputs;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder executionId(String executionId) {
                this.executionId = executionId;
                return this;
            }

            @Generated
            public OutputBuilder executionLabels(Map<String, Object> executionLabels) {
                this.executionLabels = executionLabels;
                return this;
            }

            @Generated
            public OutputBuilder state(State.Type state) {
                this.state = state;
                return this;
            }

            @Generated
            public OutputBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            @Generated
            public OutputBuilder flowId(String flowId) {
                this.flowId = flowId;
                return this;
            }

            @Generated
            public OutputBuilder flowRevision(Integer flowRevision) {
                this.flowRevision = flowRevision;
                return this;
            }

            @Generated
            public OutputBuilder outputs(Map<String, Object> outputs) {
                this.outputs = outputs;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.executionId, this.executionLabels, this.state, this.namespace, this.flowId, this.flowRevision, this.outputs);
            }

            @Generated
            public String toString() {
                return "Flow.Output.OutputBuilder(executionId=" + this.executionId + ", executionLabels=" + String.valueOf(this.executionLabels) + ", state=" + String.valueOf((Object)this.state) + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", flowRevision=" + this.flowRevision + ", outputs=" + String.valueOf(this.outputs) + ")";
            }
        }
    }

    @Generated
    public static abstract class FlowBuilder<C extends Flow, B extends FlowBuilder<C, B>>
    extends AbstractTrigger.AbstractTriggerBuilder<C, B> {
        @Generated
        private Map<String, Object> inputs;
        @Generated
        private boolean states$set;
        @Generated
        private List<State.Type> states$value;
        @Generated
        private Preconditions preconditions;

        @Generated
        public B inputs(Map<String, Object> inputs) {
            this.inputs = inputs;
            return (B)this.self();
        }

        @Generated
        public B states(List<State.Type> states) {
            this.states$value = states;
            this.states$set = true;
            return (B)this.self();
        }

        @Generated
        public B preconditions(Preconditions preconditions) {
            this.preconditions = preconditions;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Flow.FlowBuilder(super=" + super.toString() + ", inputs=" + String.valueOf(this.inputs) + ", states$value=" + String.valueOf(this.states$value) + ", preconditions=" + String.valueOf(this.preconditions) + ")";
        }
    }

    @Generated
    private static final class FlowBuilderImpl
    extends FlowBuilder<Flow, FlowBuilderImpl> {
        @Generated
        private FlowBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Flow build() {
            return new Flow(this);
        }
    }

    @Hidden
    public static class FilterCondition
    extends Condition {
        private final ExecutionFilter filter;

        private FilterCondition(ExecutionFilter filter) {
            this.filter = Objects.requireNonNull(filter);
        }

        @Override
        public boolean test(ConditionContext conditionContext) throws InternalException {
            boolean simulated = ListUtils.emptyOnNull(conditionContext.getExecution().getLabels()).contains(FlowTopologyService.SIMULATED_EXECUTION);
            Stream toEvaluate = simulated ? this.filter.filters.stream().filter(filter -> filter.field == Field.NAMESPACE || filter.field == Field.FLOW_ID) : this.filter.filters.stream();
            Operand operand = this.filter.operand;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"AND", "OR"}, (Operand)operand, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> toEvaluate.allMatch(Rethrow.throwPredicate(filter -> this.evaluate(conditionContext, (Filter)filter)));
                case 1 -> toEvaluate.anyMatch(Rethrow.throwPredicate(filter -> this.evaluate(conditionContext, (Filter)filter)));
                case -1 -> toEvaluate.allMatch(Rethrow.throwPredicate(filter -> this.evaluate(conditionContext, (Filter)filter)));
            };
        }

        private boolean evaluate(ConditionContext conditionContext, Filter filter) throws IllegalVariableEvaluationException {
            String fieldValue = switch (filter.field.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> conditionContext.getExecution().getFlowId();
                case 1 -> conditionContext.getExecution().getNamespace();
                case 2 -> conditionContext.getExecution().getState().getCurrent().toString();
                case 3 -> conditionContext.getRunContext().render(filter.value);
            };
            return switch (filter.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> filter.value.equals(fieldValue);
                case 1 -> {
                    if (!filter.value.equals(fieldValue)) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> filter.values.contains(fieldValue);
                case 3 -> {
                    if (!filter.values.contains(fieldValue)) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> TruthUtils.isTruthy(fieldValue);
                case 5 -> {
                    if (!TruthUtils.isTruthy(fieldValue)) {
                        yield true;
                    }
                    yield false;
                }
                case 6 -> {
                    if (fieldValue == null) {
                        yield true;
                    }
                    yield false;
                }
                case 7 -> {
                    if (fieldValue != null) {
                        yield true;
                    }
                    yield false;
                }
                case 8 -> {
                    if (fieldValue != null && fieldValue.startsWith(filter.value)) {
                        yield true;
                    }
                    yield false;
                }
                case 9 -> {
                    if (fieldValue != null && fieldValue.endsWith(filter.value)) {
                        yield true;
                    }
                    yield false;
                }
                case 10 -> {
                    if (fieldValue != null && fieldValue.matches(filter.value)) {
                        yield true;
                    }
                    yield false;
                }
                case 11 -> fieldValue != null && fieldValue.contains(filter.value);
            };
        }
    }

    public static enum Type {
        EQUAL_TO,
        NOT_EQUAL_TO,
        IN,
        NOT_IN,
        IS_TRUE,
        IS_FALSE,
        IS_NULL,
        IS_NOT_NULL,
        STARTS_WITH,
        ENDS_WITH,
        REGEX,
        CONTAINS;

    }

    public static enum Field {
        FLOW_ID,
        NAMESPACE,
        STATE,
        EXPRESSION;

    }

    @PreconditionFilterValidation
    public static class Filter {
        @NotNull
        @PluginProperty
        @Schema(title="The field which will be filtered")
        private Field field;
        @NotNull
        @PluginProperty
        @Schema(title="The type of filter", description="Can be set to one of the following: `EQUAL_TO`, `NOT_EQUAL_TO`, `IS_NULL`, `IS_NOT_NULL`, `IS_TRUE`, `IS_FALSE`, `STARTS_WITH`, `ENDS_WITH`, `REGEX`, `CONTAINS`. Depending on the `type`, you will need to also set the `value` or `values` property.")
        private Type type;
        @PluginProperty
        @Schema(title="The single value to filter the `field` on", description="Must be set according to its `type`.")
        private String value;
        @PluginProperty
        @Schema(title="The list of values to filter the `field` on", description="Must be set for the following types: IN, NOT_IN.")
        private List<String> values;

        @ConstructorProperties(value={"field", "type", "value", "values"})
        @Generated
        Filter(Field field, Type type, String value, List<String> values) {
            this.field = field;
            this.type = type;
            this.value = value;
            this.values = values;
        }

        @Generated
        public static FilterBuilder builder() {
            return new FilterBuilder();
        }

        @Generated
        public Field getField() {
            return this.field;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public List<String> getValues() {
            return this.values;
        }

        @Generated
        public static class FilterBuilder {
            @Generated
            private Field field;
            @Generated
            private Type type;
            @Generated
            private String value;
            @Generated
            private List<String> values;

            @Generated
            FilterBuilder() {
            }

            @Generated
            public FilterBuilder field(Field field) {
                this.field = field;
                return this;
            }

            @Generated
            public FilterBuilder type(Type type) {
                this.type = type;
                return this;
            }

            @Generated
            public FilterBuilder value(String value) {
                this.value = value;
                return this;
            }

            @Generated
            public FilterBuilder values(List<String> values) {
                this.values = values;
                return this;
            }

            @Generated
            public Filter build() {
                return new Filter(this.field, this.type, this.value, this.values);
            }

            @Generated
            public String toString() {
                return "Flow.Filter.FilterBuilder(field=" + String.valueOf((Object)this.field) + ", type=" + String.valueOf((Object)this.type) + ", value=" + this.value + ", values=" + String.valueOf(this.values) + ")";
            }
        }
    }

    public static enum Operand {
        AND,
        OR;

    }

    public static class ExecutionFilter {
        @NotNull
        @NotEmpty
        @PluginProperty
        @Schema(title="A unique identifier for the filter")
        private String id;
        @PluginProperty
        @Schema(title="The operand to apply between all filters of the precondition")
        private Operand operand;
        @NotNull
        @NotEmpty
        @Valid
        @PluginProperty
        @Schema(title="The list of filters")
        private List<Filter> filters;

        @Generated
        private static Operand $default$operand() {
            return Operand.AND;
        }

        @ConstructorProperties(value={"id", "operand", "filters"})
        @Generated
        ExecutionFilter(String id, Operand operand, List<Filter> filters) {
            this.id = id;
            this.operand = operand;
            this.filters = filters;
        }

        @Generated
        public static ExecutionFilterBuilder builder() {
            return new ExecutionFilterBuilder();
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Operand getOperand() {
            return this.operand;
        }

        @Generated
        public List<Filter> getFilters() {
            return this.filters;
        }

        @Generated
        public static class ExecutionFilterBuilder {
            @Generated
            private String id;
            @Generated
            private boolean operand$set;
            @Generated
            private Operand operand$value;
            @Generated
            private List<Filter> filters;

            @Generated
            ExecutionFilterBuilder() {
            }

            @Generated
            public ExecutionFilterBuilder id(String id) {
                this.id = id;
                return this;
            }

            @Generated
            public ExecutionFilterBuilder operand(Operand operand) {
                this.operand$value = operand;
                this.operand$set = true;
                return this;
            }

            @Generated
            public ExecutionFilterBuilder filters(List<Filter> filters) {
                this.filters = filters;
                return this;
            }

            @Generated
            public ExecutionFilter build() {
                Operand operand$value = this.operand$value;
                if (!this.operand$set) {
                    operand$value = ExecutionFilter.$default$operand();
                }
                return new ExecutionFilter(this.id, operand$value, this.filters);
            }

            @Generated
            public String toString() {
                return "Flow.ExecutionFilter.ExecutionFilterBuilder(id=" + this.id + ", operand$value=" + String.valueOf((Object)this.operand$value) + ", filters=" + String.valueOf(this.filters) + ")";
            }
        }
    }

    @Hidden
    public static class UpstreamFlowCondition
    extends Condition {
        private final UpstreamFlow upstreamFlow;

        private UpstreamFlowCondition(UpstreamFlow upstreamFlow) {
            this.upstreamFlow = Objects.requireNonNull(upstreamFlow);
        }

        @Override
        public boolean test(ConditionContext conditionContext) throws InternalException {
            if (this.upstreamFlow.namespace != null && !conditionContext.getExecution().getNamespace().equals(this.upstreamFlow.namespace)) {
                return false;
            }
            if (this.upstreamFlow.flowId != null && !conditionContext.getExecution().getFlowId().equals(this.upstreamFlow.flowId)) {
                return false;
            }
            if (ListUtils.emptyOnNull(conditionContext.getExecution().getLabels()).contains(FlowTopologyService.SIMULATED_EXECUTION)) {
                return true;
            }
            if (this.upstreamFlow.states != null && !this.upstreamFlow.states.contains((Object)conditionContext.getExecution().getState().getCurrent())) {
                return false;
            }
            if (this.upstreamFlow.labels != null) {
                boolean notMatched = this.upstreamFlow.labels.entrySet().stream().map(entry -> new Label((String)entry.getKey(), String.valueOf(entry.getValue()))).anyMatch(label -> !conditionContext.getExecution().getLabels().contains(label));
                return !notMatched;
            }
            return true;
        }
    }

    public static class UpstreamFlow {
        @NotNull
        @Schema(title="The namespace of the flow")
        @PluginProperty
        private String namespace;
        @Schema(title="The flow ID")
        @PluginProperty
        private String flowId;
        @Schema(title="The execution states")
        @PluginProperty
        private List<State.Type> states;
        @Schema(title="A key/value map of labels")
        @PluginProperty
        private Map<String, Object> labels;

        @ConstructorProperties(value={"namespace", "flowId", "states", "labels"})
        @Generated
        UpstreamFlow(String namespace, String flowId, List<State.Type> states, Map<String, Object> labels) {
            this.namespace = namespace;
            this.flowId = flowId;
            this.states = states;
            this.labels = labels;
        }

        @Generated
        public static UpstreamFlowBuilder builder() {
            return new UpstreamFlowBuilder();
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getFlowId() {
            return this.flowId;
        }

        @Generated
        public List<State.Type> getStates() {
            return this.states;
        }

        @Generated
        public Map<String, Object> getLabels() {
            return this.labels;
        }

        @Generated
        public static class UpstreamFlowBuilder {
            @Generated
            private String namespace;
            @Generated
            private String flowId;
            @Generated
            private List<State.Type> states;
            @Generated
            private Map<String, Object> labels;

            @Generated
            UpstreamFlowBuilder() {
            }

            @Generated
            public UpstreamFlowBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            @Generated
            public UpstreamFlowBuilder flowId(String flowId) {
                this.flowId = flowId;
                return this;
            }

            @Generated
            public UpstreamFlowBuilder states(List<State.Type> states) {
                this.states = states;
                return this;
            }

            @Generated
            public UpstreamFlowBuilder labels(Map<String, Object> labels) {
                this.labels = labels;
                return this;
            }

            @Generated
            public UpstreamFlow build() {
                return new UpstreamFlow(this.namespace, this.flowId, this.states, this.labels);
            }

            @Generated
            public String toString() {
                return "Flow.UpstreamFlow.UpstreamFlowBuilder(namespace=" + this.namespace + ", flowId=" + this.flowId + ", states=" + String.valueOf(this.states) + ", labels=" + String.valueOf(this.labels) + ")";
            }
        }
    }
}

