/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.contexts;

import io.kestra.core.exceptions.KestraRuntimeException;
import io.kestra.core.plugins.DefaultPluginRegistry;
import io.kestra.core.plugins.PluginCatalogService;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.storages.StorageInterfaceFactory;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.annotation.Client;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

@Factory
public class KestraBeansFactory {
    @Inject
    Validator validator;
    @Inject
    StorageConfig storageConfig;
    @Value(value="${kestra.storage.type}")
    protected Optional<String> storageType;

    @Singleton
    public PluginCatalogService pluginCatalogService(@Client(value="api") HttpClient httpClient) {
        return new PluginCatalogService(httpClient, false, true);
    }

    @Requires(missingBeans={PluginRegistry.class})
    @Singleton
    public PluginRegistry pluginRegistry() {
        return DefaultPluginRegistry.getOrCreate();
    }

    @Singleton
    public StorageInterfaceFactory storageInterfaceFactory(PluginRegistry pluginRegistry) {
        return new StorageInterfaceFactory(pluginRegistry, this.validator);
    }

    @Requires(missingBeans={StorageInterface.class})
    @Singleton
    @Bean(preDestroy="close")
    public StorageInterface storageInterface(StorageInterfaceFactory storageInterfaceFactory) throws IOException {
        String pluginId = this.getStoragePluginId(storageInterfaceFactory);
        return storageInterfaceFactory.make(null, pluginId, this.storageConfig.getStorageConfig(pluginId));
    }

    public String getStoragePluginId(StorageInterfaceFactory storageInterfaceFactory) {
        return this.storageType.orElseThrow(() -> new KestraRuntimeException(String.format("No storage configured through the application property '%s'. Supported types are: %s", "kestra.storage.type", storageInterfaceFactory.getLoggableStorageIds())));
    }

    @ConfigurationProperties(value="kestra")
    public record StorageConfig(@Nullable @MapFormat(keyFormat=StringConvention.CAMEL_CASE, transformation=MapFormat.MapTransformation.NESTED) Map<String, Object> storage) {
        public Map<String, Object> getStorageConfig(String type) {
            return (Map)this.storage.get(StringConvention.CAMEL_CASE.format(type));
        }
    }
}

