/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.docs;

import com.google.common.collect.ImmutableMap;
import io.kestra.core.docs.AbstractClassDocumentation;
import io.kestra.core.docs.ClassPluginDocumentation;
import io.kestra.core.docs.Document;
import io.kestra.core.docs.JsonSchemaGenerator;
import io.kestra.core.docs.Schema;
import io.kestra.core.models.annotations.PluginSubGroup;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.logs.LogExporter;
import io.kestra.core.models.tasks.runners.TaskRunner;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.plugins.AdditionalPlugin;
import io.kestra.core.plugins.PluginClassAndMetadata;
import io.kestra.core.plugins.RegisteredPlugin;
import io.kestra.core.runners.pebble.Extension;
import io.kestra.core.runners.pebble.JsonWriter;
import io.kestra.core.runners.pebble.filters.ToJsonFilter;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.utils.Slugify;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.extension.AbstractExtension;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.loader.ClasspathLoader;
import io.pebbletemplates.pebble.loader.Loader;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;

@Singleton
public class DocumentationGenerator {
    private static final PebbleEngine PEBBLE_ENGINE;
    @Inject
    JsonSchemaGenerator jsonSchemaGenerator;

    public List<Document> generate(RegisteredPlugin registeredPlugin) throws Exception {
        ArrayList<Document> result = new ArrayList<Document>();
        result.addAll(DocumentationGenerator.index(registeredPlugin));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getTasks(), Task.class, "tasks"));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getTriggers(), AbstractTrigger.class, "triggers"));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getConditions(), Condition.class, "conditions"));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getTaskRunners(), TaskRunner.class, "task-runners"));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getLogExporters(), LogExporter.class, "log-exporters"));
        result.addAll(this.generate(registeredPlugin, registeredPlugin.getAdditionalPlugins(), AdditionalPlugin.class, "additional-plugins"));
        result.addAll(DocumentationGenerator.guides(registeredPlugin));
        return result;
    }

    private static List<Document> index(RegisteredPlugin plugin) throws IOException {
        Map<SubGroup, Map<String, List<ClassPlugin>>> groupedClass = DocumentationGenerator.indexGroupedClass(plugin);
        if (groupedClass.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"title", (Object)plugin.title().replace("plugin-", ""));
        if (plugin.description() != null) {
            builder.put((Object)"description", (Object)plugin.description());
        }
        if (plugin.license() != null) {
            builder.put((Object)"docLicense", (Object)plugin.license());
        }
        if (plugin.longDescription() != null) {
            builder.put((Object)"longDescription", (Object)plugin.longDescription());
        }
        builder.put((Object)"group", (Object)plugin.group());
        builder.put((Object)"classPlugins", groupedClass);
        if (plugin.icon("plugin-icon") != null) {
            builder.put((Object)"icon", (Object)plugin.icon("plugin-icon"));
        }
        if (!plugin.getGuides().isEmpty()) {
            builder.put((Object)"guides", plugin.getGuides());
        }
        return Collections.singletonList(new Document(DocumentationGenerator.docPath(plugin), DocumentationGenerator.render("index", (Map<String, Object>)builder.build()), plugin.icon("plugin-icon"), null));
    }

    private static Map<SubGroup, Map<String, List<ClassPlugin>>> indexGroupedClass(RegisteredPlugin plugin) {
        return plugin.allClassGrouped().entrySet().stream().filter(r -> !((String)r.getKey()).equals("controllers") && !((String)r.getKey()).equals("storages")).flatMap(entry -> ((List)entry.getValue()).stream().map(cls -> {
            ClassPlugin.ClassPluginBuilder builder = ClassPlugin.builder().name(cls.getName()).simpleName(cls.getSimpleName()).type((String)entry.getKey());
            if (cls.getPackageName().startsWith(plugin.group())) {
                PluginSubGroup pluginSubGroup = cls.getPackage().getDeclaredAnnotation(PluginSubGroup.class);
                String subGroupName = cls.getPackageName().length() > plugin.group().length() ? cls.getPackageName().substring(plugin.group().length() + 1) : "";
                String subGroupTitle = pluginSubGroup != null ? pluginSubGroup.title() : subGroupName;
                String subGroupDescription = pluginSubGroup != null ? pluginSubGroup.description() : null;
                boolean subgroupIsGroup = cls.getPackageName().length() <= plugin.group().length();
                String subGroupIcon = plugin.icon(cls.getPackageName());
                SubGroup subgroup = new SubGroup(subGroupName, subGroupTitle, subGroupDescription, subGroupIcon, subgroupIsGroup);
                builder.subgroup(subgroup);
            } else {
                builder.subgroup(new SubGroup(""));
            }
            return builder.build();
        })).filter(Objects::nonNull).distinct().sorted(Comparator.comparing(ClassPlugin::getSubgroup).thenComparing(ClassPlugin::getType).thenComparing(ClassPlugin::getName)).collect(Collectors.groupingBy(ClassPlugin::getSubgroup, Collectors.groupingBy(classPlugin -> Slugify.toStartCase(classPlugin.getType()))));
    }

    private static List<Document> guides(RegisteredPlugin plugin) throws Exception {
        String pluginName = Slugify.of(plugin.title());
        return plugin.guides().entrySet().stream().map(Rethrow.throwFunction(e -> new Document(pluginName + "/guides/" + (String)e.getKey() + ".md", (String)e.getValue(), null, null))).toList();
    }

    private <T> List<Document> generate(RegisteredPlugin registeredPlugin, List<Class<? extends T>> cls, Class<T> baseCls, String type) {
        return cls.stream().map(pluginClass -> {
            PluginClassAndMetadata metadata = PluginClassAndMetadata.create(registeredPlugin, pluginClass, baseCls, null);
            return ClassPluginDocumentation.of(this.jsonSchemaGenerator, metadata, registeredPlugin.version(), true);
        }).map(pluginDocumentation -> {
            try {
                return new Document(DocumentationGenerator.docPath(registeredPlugin, type, pluginDocumentation), DocumentationGenerator.render(pluginDocumentation), pluginDocumentation.getIcon(), new Schema(pluginDocumentation.getPropertiesSchema(), pluginDocumentation.getOutputsSchema(), pluginDocumentation.getDefs()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).toList();
    }

    private static String docPath(RegisteredPlugin registeredPlugin) {
        String pluginName = Slugify.of(registeredPlugin.path());
        return pluginName + "/index.md";
    }

    private static <T> String docPath(RegisteredPlugin registeredPlugin, String type, ClassPluginDocumentation<T> classPluginDocumentation) {
        String pluginName = Slugify.of(registeredPlugin.path());
        return pluginName + "/" + type + "/" + (String)(classPluginDocumentation.getSubGroup() != null ? classPluginDocumentation.getSubGroup() + "/" : "") + classPluginDocumentation.getCls() + ".md";
    }

    public static String render(ClassPluginDocumentation<?> classPluginDocumentation) throws IOException {
        return DocumentationGenerator.render("task", JacksonMapper.toMap(classPluginDocumentation));
    }

    public static String render(AbstractClassDocumentation classInputDocumentation) throws IOException {
        return DocumentationGenerator.render("task", JacksonMapper.toMap(classInputDocumentation));
    }

    public static String render(String templateName, Map<String, Object> vars) throws IOException {
        String pebbleTemplate = IOUtils.toString((InputStream)Objects.requireNonNull(DocumentationGenerator.class.getClassLoader().getResourceAsStream("docs/" + templateName + ".peb")), (Charset)StandardCharsets.UTF_8);
        PebbleTemplate compiledTemplate = PEBBLE_ENGINE.getLiteralTemplate(pebbleTemplate);
        JsonWriter writer = new JsonWriter();
        compiledTemplate.evaluate((Writer)writer, vars);
        String renderer = ((Object)writer).toString();
        Pattern pattern = Pattern.compile("`\\{\\{(.*?)\\}\\}`", 8);
        renderer = pattern.matcher(renderer).replaceAll("<code v-pre>{{ $1 }}</code>");
        return renderer;
    }

    static {
        ClasspathLoader classpathLoader = new ClasspathLoader();
        classpathLoader.setPrefix("docs/");
        PEBBLE_ENGINE = new PebbleEngine.Builder().newLineTrimming(false).loader((Loader)classpathLoader).extension(new io.pebbletemplates.pebble.extension.Extension[]{new AbstractExtension(){

            public Map<String, Filter> getFilters() {
                HashMap<String, Filter> filters = new HashMap<String, Filter>();
                filters.put("json", new ToJsonFilter());
                return filters;
            }
        }}).autoEscaping(false).extension(new io.pebbletemplates.pebble.extension.Extension[]{new Extension()}).build();
    }

    public static class ClassPlugin {
        String name;
        String simpleName;
        SubGroup subgroup;
        String group;
        String type;

        @Generated
        public static ClassPluginBuilder builder() {
            return new ClassPluginBuilder();
        }

        @ConstructorProperties(value={"name", "simpleName", "subgroup", "group", "type"})
        @Generated
        public ClassPlugin(String name, String simpleName, SubGroup subgroup, String group, String type) {
            this.name = name;
            this.simpleName = simpleName;
            this.subgroup = subgroup;
            this.group = group;
            this.type = type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getSimpleName() {
            return this.simpleName;
        }

        @Generated
        public SubGroup getSubgroup() {
            return this.subgroup;
        }

        @Generated
        public String getGroup() {
            return this.group;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public static class ClassPluginBuilder {
            @Generated
            private String name;
            @Generated
            private String simpleName;
            @Generated
            private SubGroup subgroup;
            @Generated
            private String group;
            @Generated
            private String type;

            @Generated
            ClassPluginBuilder() {
            }

            @Generated
            public ClassPluginBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public ClassPluginBuilder simpleName(String simpleName) {
                this.simpleName = simpleName;
                return this;
            }

            @Generated
            public ClassPluginBuilder subgroup(SubGroup subgroup) {
                this.subgroup = subgroup;
                return this;
            }

            @Generated
            public ClassPluginBuilder group(String group) {
                this.group = group;
                return this;
            }

            @Generated
            public ClassPluginBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public ClassPlugin build() {
                return new ClassPlugin(this.name, this.simpleName, this.subgroup, this.group, this.type);
            }

            @Generated
            public String toString() {
                return "DocumentationGenerator.ClassPlugin.ClassPluginBuilder(name=" + this.name + ", simpleName=" + this.simpleName + ", subgroup=" + String.valueOf(this.subgroup) + ", group=" + this.group + ", type=" + this.type + ")";
            }
        }
    }

    public static class SubGroup
    implements Comparable<SubGroup> {
        String name;
        String title;
        String description;
        String icon;
        boolean subgroupIsGroup;

        SubGroup(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(SubGroup o) {
            return this.name.compareTo(o.getName());
        }

        @ConstructorProperties(value={"name", "title", "description", "icon", "subgroupIsGroup"})
        @Generated
        public SubGroup(String name, String title, String description, String icon, boolean subgroupIsGroup) {
            this.name = name;
            this.title = title;
            this.description = description;
            this.icon = icon;
            this.subgroupIsGroup = subgroupIsGroup;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getIcon() {
            return this.icon;
        }

        @Generated
        public boolean isSubgroupIsGroup() {
            return this.subgroupIsGroup;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubGroup)) {
                return false;
            }
            SubGroup other = (SubGroup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SubGroup;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

