/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.events;

import io.kestra.core.events.CrudEventType;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import java.util.Objects;
import lombok.Generated;

public class CrudEvent<T> {
    private final T model;
    @Nullable
    private final T previousModel;
    private final CrudEventType type;
    private final HttpRequest<?> request;

    public static <T> CrudEvent<T> create(T model) {
        Objects.requireNonNull(model, "Can't create CREATE event with a null model");
        return new CrudEvent<Object>(model, null, CrudEventType.CREATE);
    }

    public static <T> CrudEvent<T> delete(T model) {
        Objects.requireNonNull(model, "Can't create DELETE event with a null model");
        return new CrudEvent<Object>(null, model, CrudEventType.DELETE);
    }

    public static <T> CrudEvent<T> of(T before, T after) {
        if (before == null && after == null) {
            throw new IllegalArgumentException("Both before and after cannot be null");
        }
        if (before == null) {
            return CrudEvent.create(after);
        }
        if (after == null) {
            return CrudEvent.delete(before);
        }
        return new CrudEvent<T>(after, before, CrudEventType.UPDATE);
    }

    @Deprecated
    public CrudEvent(T model, CrudEventType type) {
        this((CrudEventType.DELETE.equals((Object)type) ? null : (T)model), (CrudEventType.DELETE.equals((Object)type) ? model : null), type, (HttpRequest<?>)((HttpRequest)ServerRequestContext.currentRequest().orElse(null)));
    }

    public CrudEvent(T model, T previousModel, CrudEventType type) {
        this(model, previousModel, type, ServerRequestContext.currentRequest().orElse(null));
    }

    public CrudEvent(T model, T previousModel, CrudEventType type, HttpRequest<?> request) {
        this.model = model;
        this.previousModel = previousModel;
        this.type = type;
        this.request = request;
    }

    @Generated
    public T getModel() {
        return this.model;
    }

    @Generated
    public T getPreviousModel() {
        return this.previousModel;
    }

    @Generated
    public CrudEventType getType() {
        return this.type;
    }

    @Generated
    public HttpRequest<?> getRequest() {
        return this.request;
    }
}

