/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http.client;

import com.fasterxml.jackson.core.type.TypeReference;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.http.HttpRequest;
import io.kestra.core.http.HttpResponse;
import io.kestra.core.http.client.HttpClientException;
import io.kestra.core.http.client.HttpClientRequestException;
import io.kestra.core.http.client.apache.FailedResponseInterceptor;
import io.kestra.core.http.client.apache.LoggingRequestInterceptor;
import io.kestra.core.http.client.apache.LoggingResponseInterceptor;
import io.kestra.core.http.client.apache.RunContextResponseInterceptor;
import io.kestra.core.http.client.configurations.HttpConfiguration;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientContext;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationConvention;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.DefaultApacheHttpClientObservationConvention;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ObservationExecChainHandler;
import io.micrometer.observation.ObservationRegistry;
import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.ContextBuilder;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    private transient CloseableHttpClient client;
    private final RunContext runContext;
    private final HttpConfiguration configuration;
    private ObservationRegistry observationRegistry;

    public HttpClient(RunContext runContext, @Nullable HttpConfiguration configuration) throws IllegalVariableEvaluationException {
        this.runContext = runContext;
        HttpConfiguration httpConfiguration = this.configuration = configuration == null ? HttpConfiguration.builder().build() : configuration;
        if (runContext instanceof DefaultRunContext) {
            DefaultRunContext defaultRunContext = (DefaultRunContext)runContext;
            this.observationRegistry = defaultRunContext.getApplicationContext().findBean(ObservationRegistry.class).orElse(null);
        }
        this.client = this.createClient();
    }

    private CloseableHttpClient createClient() throws IllegalVariableEvaluationException {
        List<Integer> list;
        String proxyAddress;
        if (this.client != null) {
            throw new IllegalStateException("Client has already been created");
        }
        org.apache.hc.client5.http.impl.classic.HttpClientBuilder builder = HttpClients.custom().disableDefaultUserAgent().setUserAgent("Kestra");
        if (this.observationRegistry != null) {
            builder.addExecInterceptorAfter(ChainElement.RETRY.name(), "micrometer", (ExecChainHandler)new ObservationExecChainHandler(this.observationRegistry, (ApacheHttpClientObservationConvention)new CustomApacheHttpClientObservationConvention()));
        }
        if (this.configuration.getLogs() != null && this.configuration.getLogs().length > 0) {
            if (ArrayUtils.contains((Object[])this.configuration.getLogs(), (Object)((Object)HttpConfiguration.LoggingType.REQUEST_HEADERS)) || ArrayUtils.contains((Object[])this.configuration.getLogs(), (Object)((Object)HttpConfiguration.LoggingType.REQUEST_BODY))) {
                builder.addRequestInterceptorLast((HttpRequestInterceptor)new LoggingRequestInterceptor(this.runContext.logger(), this.configuration.getLogs()));
            }
            if (ArrayUtils.contains((Object[])this.configuration.getLogs(), (Object)((Object)HttpConfiguration.LoggingType.RESPONSE_HEADERS)) || ArrayUtils.contains((Object[])this.configuration.getLogs(), (Object)((Object)HttpConfiguration.LoggingType.RESPONSE_BODY))) {
                builder.addResponseInterceptorLast((HttpResponseInterceptor)new LoggingResponseInterceptor(this.runContext.logger(), this.configuration.getLogs()));
            }
        }
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        ConnectionConfig.Builder connectionConfig = ConnectionConfig.custom();
        BasicCredentialsProvider credentialsStore = new BasicCredentialsProvider();
        if (this.configuration.getTimeout() != null) {
            Optional<Duration> connectTimeout = this.runContext.render(this.configuration.getTimeout().getConnectTimeout()).as(Duration.class);
            connectTimeout.ifPresent(duration -> connectionConfig.setConnectTimeout(Timeout.of((Duration)duration)));
            Optional<Duration> readIdleTimeout = this.runContext.render(this.configuration.getTimeout().getReadIdleTimeout()).as(Duration.class);
            readIdleTimeout.ifPresent(duration -> connectionConfig.setSocketTimeout(Timeout.of((Duration)duration)));
        }
        if (this.configuration.getProxy() != null && this.configuration.getProxy().getAddress() != null && StringUtils.isNotEmpty((CharSequence)(proxyAddress = (String)this.runContext.render(this.configuration.getProxy().getAddress()).as(String.class).orElse(null)))) {
            int port = this.runContext.render(this.configuration.getProxy().getPort()).as(Integer.class).orElseThrow();
            InetSocketAddress proxyAddr = new InetSocketAddress(proxyAddress, port);
            final Proxy proxy = new Proxy(this.runContext.render(this.configuration.getProxy().getType()).as(Proxy.Type.class).orElse(null), proxyAddr);
            builder.setProxySelector(new ProxySelector(this){

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException e) {
                }

                @Override
                public List<Proxy> select(URI uri) {
                    return List.of(proxy);
                }
            });
            if (this.configuration.getProxy().getUsername() != null && this.configuration.getProxy().getPassword() != null) {
                builder.setProxyAuthenticationStrategy((AuthenticationStrategy)new DefaultAuthenticationStrategy());
                credentialsStore.setCredentials(new AuthScope(proxyAddress, port), (Credentials)new UsernamePasswordCredentials(this.runContext.render(this.configuration.getProxy().getUsername()).as(String.class).orElseThrow(), this.runContext.render(this.configuration.getProxy().getPassword()).as(String.class).orElseThrow().toCharArray()));
            }
        }
        if (this.configuration.getSsl() != null && this.configuration.getSsl().getInsecureTrustAllCertificates() != null) {
            connectionManagerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.selfSignedConnectionSocketFactory());
        }
        if (this.configuration.getAuth() != null) {
            this.configuration.getAuth().configure(builder, this.runContext);
        }
        if (!this.runContext.render(this.configuration.getFollowRedirects()).as(Boolean.class).orElseThrow().booleanValue()) {
            builder.disableRedirectHandling();
        }
        if (!this.runContext.render(this.configuration.getAllowFailed()).as(Boolean.class).orElseThrow().booleanValue()) {
            builder.addResponseInterceptorLast((HttpResponseInterceptor)new FailedResponseInterceptor());
        }
        if (this.configuration.getAllowedResponseCodes() != null && !(list = this.runContext.render(this.configuration.getAllowedResponseCodes()).asList(Integer.class)).isEmpty()) {
            builder.addResponseInterceptorLast((HttpResponseInterceptor)new FailedResponseInterceptor(list));
        }
        builder.addResponseInterceptorLast((HttpResponseInterceptor)new RunContextResponseInterceptor(this.runContext));
        connectionManagerBuilder.setDefaultConnectionConfig(connectionConfig.build());
        builder.setConnectionManager((HttpClientConnectionManager)connectionManagerBuilder.build());
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsStore);
        this.client = builder.build();
        return this.client;
    }

    private SSLConnectionSocketFactory selfSignedConnectionSocketFactory() {
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (chain, authType) -> true).build();
            return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> HttpResponse<T> request(HttpRequest request, Class<T> cls) throws HttpClientException, IllegalVariableEvaluationException {
        HttpClientContext httpClientContext = this.clientContext(request);
        return this.request(request, httpClientContext, r -> {
            Object body = this.bodyHandler(cls, r.getEntity());
            return HttpResponse.from(r, body, request, (HttpContext)httpClientContext);
        });
    }

    public HttpResponse<Void> request(HttpRequest request, Consumer<HttpResponse<InputStream>> consumer) throws HttpClientException, IllegalVariableEvaluationException {
        HttpClientContext httpClientContext = this.clientContext(request);
        return this.request(request, httpClientContext, r -> {
            HttpResponse<InputStream> from = HttpResponse.from(r, r.getEntity() != null ? r.getEntity().getContent() : null, request, (HttpContext)httpClientContext);
            consumer.accept(from);
            return HttpResponse.from(r, null, request, (HttpContext)httpClientContext);
        });
    }

    public <T> HttpResponse<T> request(HttpRequest request) throws HttpClientException, IllegalVariableEvaluationException {
        HttpClientContext httpClientContext = this.clientContext(request);
        return this.request(request, httpClientContext, response -> {
            Object body = JacksonMapper.ofJson().readValue(response.getEntity().getContent(), new TypeReference<T>(this){});
            return HttpResponse.from(response, body, request, (HttpContext)httpClientContext);
        });
    }

    private HttpClientContext clientContext(HttpRequest request) {
        ContextBuilder contextBuilder = ContextBuilder.create();
        return contextBuilder.build();
    }

    private <T> HttpResponse<T> request(HttpRequest request, HttpClientContext httpClientContext, HttpClientResponseHandler<HttpResponse<T>> responseHandler) throws HttpClientException {
        try {
            return (HttpResponse)this.client.execute((ClassicHttpRequest)request.to(this.runContext), (HttpContext)httpClientContext, responseHandler);
        }
        catch (SocketException e) {
            throw new HttpClientRequestException(e.getMessage(), request, e);
        }
        catch (IOException e) {
            if (e instanceof SSLHandshakeException) {
                throw new HttpClientRequestException(e.getMessage(), request, e);
            }
            Throwable throwable = e.getCause();
            if (throwable instanceof HttpClientException) {
                HttpClientException httpClientException = (HttpClientException)((Object)throwable);
                throw httpClientException;
            }
            throw new RuntimeException(e);
        }
    }

    private <T> T bodyHandler(Class<?> cls, HttpEntity entity) throws IOException, ParseException {
        if (entity == null) {
            return null;
        }
        if (String.class.isAssignableFrom(cls)) {
            return (T)EntityUtils.toString((HttpEntity)entity);
        }
        if (Byte[].class.isAssignableFrom(cls)) {
            return (T)ArrayUtils.toObject((byte[])EntityUtils.toByteArray((HttpEntity)entity));
        }
        if ("application/x-yaml".equals(entity.getContentType()) || "application/yaml".equals(entity.getContentType())) {
            return (T)JacksonMapper.ofYaml().readValue(entity.getContent(), cls);
        }
        return (T)JacksonMapper.ofJson(false).readValue(entity.getContent(), cls);
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Generated
    public static HttpClientBuilder builder() {
        return new HttpClientBuilder();
    }

    public static class CustomApacheHttpClientObservationConvention
    extends DefaultApacheHttpClientObservationConvention {
        public KeyValues getLowCardinalityKeyValues(ApacheHttpClientContext context) {
            return KeyValues.concat((Iterable)super.getLowCardinalityKeyValues(context), (Iterable)KeyValues.of((String)"type", (String)"core-client"));
        }
    }

    @Generated
    public static class HttpClientBuilder {
        @Generated
        private RunContext runContext;
        @Generated
        private HttpConfiguration configuration;

        @Generated
        HttpClientBuilder() {
        }

        @Generated
        public HttpClientBuilder runContext(RunContext runContext) {
            this.runContext = runContext;
            return this;
        }

        @Generated
        public HttpClientBuilder configuration(@Nullable HttpConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public HttpClient build() throws IllegalVariableEvaluationException {
            return new HttpClient(this.runContext, this.configuration);
        }

        @Generated
        public String toString() {
            return "HttpClient.HttpClientBuilder(runContext=" + String.valueOf(this.runContext) + ", configuration=" + String.valueOf(this.configuration) + ")";
        }
    }
}

