/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http.client.apache;

import io.kestra.core.http.HttpService;
import io.kestra.core.http.client.apache.AbstractLoggingInterceptor;
import io.kestra.core.http.client.configurations.HttpConfiguration;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;

public class LoggingRequestInterceptor
extends AbstractLoggingInterceptor
implements HttpRequestInterceptor {
    private Logger logger;
    private HttpConfiguration.LoggingType[] logs;

    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        if (this.logger.isDebugEnabled() && ArrayUtils.contains((Object[])this.logs, (Object)((Object)HttpConfiguration.LoggingType.REQUEST_HEADERS))) {
            this.logger.debug(this.buildRequestEntry(request));
            this.logger.debug(LoggingRequestInterceptor.buildHeadersEntry("request", request.getHeaders()));
        }
        if (this.logger.isTraceEnabled() && ArrayUtils.contains((Object[])this.logs, (Object)((Object)HttpConfiguration.LoggingType.REQUEST_BODY))) {
            ClassicHttpRequest classicHttpRequest;
            this.logger.trace(LoggingRequestInterceptor.buildEntityEntry("request", request instanceof ClassicHttpRequest ? (classicHttpRequest = (ClassicHttpRequest)request) : null));
        }
    }

    private String buildRequestEntry(HttpRequest request) {
        return "request:\n    method: " + request.getMethod() + "\n    uri: " + String.valueOf(HttpService.safeURI(request));
    }

    @ConstructorProperties(value={"logger", "logs"})
    @Generated
    public LoggingRequestInterceptor(Logger logger, HttpConfiguration.LoggingType[] logs) {
        this.logger = logger;
        this.logs = logs;
    }
}

