/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http.client.apache;

import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.runners.RunContext;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.Generated;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;

public class RunContextResponseInterceptor
implements HttpResponseInterceptor {
    RunContext runContext;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        if (context instanceof HttpClientContext) {
            HttpClientContext httpClientContext = (HttpClientContext)context;
            if (response instanceof BasicClassicHttpResponse) {
                BasicClassicHttpResponse httpResponse = (BasicClassicHttpResponse)response;
                try {
                    this.runContext.logger().debug("Request '{}' from '{}' with the response code '{}'", new Object[]{httpClientContext.getRequest().getUri(), httpClientContext.getEndpointDetails().getRemoteAddress(), response.getCode()});
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
                String[] tags = this.tags(httpClientContext.getRequest(), (ClassicHttpResponse)httpResponse);
                if (httpResponse.getEntity() != null) {
                    this.runContext.metric(Counter.of("response.length", httpResponse.getEntity().getContentLength(), tags));
                }
                this.runContext.metric(Counter.of("request.count", httpClientContext.getEndpointDetails().getRequestCount(), tags));
                this.runContext.metric(Counter.of("request.bytes", httpClientContext.getEndpointDetails().getSentBytesCount(), tags));
                this.runContext.metric(Counter.of("response.bytes", httpClientContext.getEndpointDetails().getReceivedBytesCount(), tags));
                this.runContext.metric(Counter.of("response.count", httpClientContext.getEndpointDetails().getResponseCount(), tags));
                return;
            }
        }
        this.runContext.logger().warn("Invalid response type HttpResponse => {}, HttpContext => {}", (Object)response.getClass(), (Object)context.getClass());
    }

    protected String[] tags(HttpRequest request, ClassicHttpResponse response) {
        ArrayList<String> tags = new ArrayList<String>(Arrays.asList("request.method", request.getMethod(), "request.scheme", request.getScheme(), "request.hostname", request.getAuthority().getHostName()));
        if (response != null) {
            tags.addAll(Arrays.asList("response.code", String.valueOf(response.getCode())));
        }
        return (String[])tags.toArray(String[]::new);
    }

    @ConstructorProperties(value={"runContext"})
    @Generated
    public RunContextResponseInterceptor(RunContext runContext) {
        this.runContext = runContext;
    }
}

