/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.metrics;

import io.kestra.core.metrics.MetricConfig;
import io.kestra.core.models.ServerType;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.micronaut.configuration.metrics.aggregator.MeterRegistryConfigurer;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.stream.Stream;

@Singleton
@Requires(beans={MetricConfig.class})
public class GlobalTagsConfigurer
implements MeterRegistryConfigurer<SimpleMeterRegistry> {
    @Inject
    MetricConfig metricConfig;
    @Nullable
    @Value(value="${kestra.server-type}")
    ServerType serverType;

    public void configure(SimpleMeterRegistry meterRegistry) {
        String[] tags = (String[])Stream.concat(this.metricConfig.getTags() != null ? this.metricConfig.getTags().entrySet().stream().flatMap(e -> Stream.of((String)e.getKey(), (String)e.getValue())) : Stream.empty(), this.serverType != null ? Stream.of("server_type", this.serverType.name()) : Stream.empty()).toList().toArray(String[]::new);
        meterRegistry.config().commonTags(tags);
    }

    public boolean supports(SimpleMeterRegistry meterRegistry) {
        return true;
    }

    public Class<SimpleMeterRegistry> getType() {
        return SimpleMeterRegistry.class;
    }
}

