/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models;

import io.micronaut.http.multipart.CompletedFileUpload;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public interface HasSource {
    public String source();

    public static <T extends HasSource> byte[] asZipFile(List<? extends T> sources, Function<T, String> zipEntryName) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            Object object;
            try (ZipOutputStream archive = new ZipOutputStream(bos);){
                for (HasSource source : sources) {
                    ZipEntry zipEntry = new ZipEntry(zipEntryName.apply(source));
                    archive.putNextEntry(zipEntry);
                    archive.write(source.source().getBytes());
                    archive.closeEntry();
                }
                archive.finish();
                object = bos.toByteArray();
            }
            return object;
        }
    }

    public static void readSourceFile(CompletedFileUpload fileUpload, BiConsumer<String, String> reader) throws IOException {
        block15: {
            String fileName = fileUpload.getFilename().toLowerCase();
            try (InputStream inputStream = fileUpload.getInputStream();){
                if (HasSource.isYAML(fileName)) {
                    byte[] bytes = inputStream.readAllBytes();
                    List<String> sources = List.of(new String(bytes).split("---"));
                    for (int i = 0; i < sources.size(); ++i) {
                        String source = sources.get(i);
                        reader.accept(source, String.valueOf(i));
                    }
                    break block15;
                }
                if (fileName.endsWith(".zip")) {
                    try (ZipInputStream archive = new ZipInputStream(inputStream);){
                        ZipEntry entry;
                        while ((entry = archive.getNextEntry()) != null) {
                            if (entry.isDirectory() || !HasSource.isYAML(entry.getName())) continue;
                            reader.accept(new String(archive.readAllBytes()), entry.getName());
                        }
                        break block15;
                    }
                }
                throw new IllegalArgumentException("Cannot import file of type " + fileName.substring(fileName.lastIndexOf(46)));
            }
        }
    }

    private static boolean isYAML(String fileName) {
        return fileName.endsWith(".yaml") || fileName.endsWith(".yml");
    }
}

