/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.TenantInterface;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.ExecutionKind;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.executions.metrics.Timer;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;

public final class MetricEntry
implements DeletedInterface,
TenantInterface {
    @Hidden
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*")
    private final @Pattern(regexp="^[a-z0-9][a-z0-9_-]*") String tenantId;
    @NotNull
    private final String namespace;
    @NotNull
    private final String flowId;
    @Nullable
    private final String taskId;
    @Nullable
    private final String executionId;
    @Nullable
    private final String taskRunId;
    @NotNull
    private final String type;
    @NotNull
    private final String name;
    @NotNull
    @JsonInclude
    private final Double value;
    @NotNull
    private final Instant timestamp;
    @Nullable
    private final Map<String, String> tags;
    @NotNull
    private final boolean deleted;
    @Nullable
    private final ExecutionKind executionKind;

    public static MetricEntry of(TaskRun taskRun, AbstractMetricEntry<?> metricEntry, ExecutionKind executionKind) {
        return MetricEntry.builder().tenantId(taskRun.getTenantId()).namespace(taskRun.getNamespace()).flowId(taskRun.getFlowId()).executionId(taskRun.getExecutionId()).taskId(taskRun.getTaskId()).taskRunId(taskRun.getId()).type(metricEntry.getType()).name(metricEntry.getName()).tags(metricEntry.getTags()).value(MetricEntry.computeValue(metricEntry)).timestamp(metricEntry.getTimestamp()).executionKind(executionKind).build();
    }

    private static Double computeValue(AbstractMetricEntry<?> metricEntry) {
        if (metricEntry instanceof Counter) {
            Counter counter = (Counter)metricEntry;
            return counter.getValue();
        }
        if (metricEntry instanceof Timer) {
            Timer timer = (Timer)metricEntry;
            return timer.getValue().toMillis();
        }
        throw new IllegalArgumentException("Unknown metric type: " + String.valueOf(metricEntry.getClass()));
    }

    @Generated
    private static boolean $default$deleted() {
        return false;
    }

    @ConstructorProperties(value={"tenantId", "namespace", "flowId", "taskId", "executionId", "taskRunId", "type", "name", "value", "timestamp", "tags", "deleted", "executionKind"})
    @Generated
    MetricEntry(String tenantId, String namespace, String flowId, @Nullable String taskId, @Nullable String executionId, @Nullable String taskRunId, String type, String name, Double value, Instant timestamp, @Nullable Map<String, String> tags, boolean deleted, @Nullable ExecutionKind executionKind) {
        this.tenantId = tenantId;
        this.namespace = namespace;
        this.flowId = flowId;
        this.taskId = taskId;
        this.executionId = executionId;
        this.taskRunId = taskRunId;
        this.type = type;
        this.name = name;
        this.value = value;
        this.timestamp = timestamp;
        this.tags = tags;
        this.deleted = deleted;
        this.executionKind = executionKind;
    }

    @Generated
    public static MetricEntryBuilder builder() {
        return new MetricEntryBuilder();
    }

    @Generated
    public MetricEntryBuilder toBuilder() {
        return new MetricEntryBuilder().tenantId(this.tenantId).namespace(this.namespace).flowId(this.flowId).taskId(this.taskId).executionId(this.executionId).taskRunId(this.taskRunId).type(this.type).name(this.name).value(this.value).timestamp(this.timestamp).tags(this.tags).deleted(this.deleted).executionKind(this.executionKind);
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Nullable
    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Nullable
    @Generated
    public String getExecutionId() {
        return this.executionId;
    }

    @Nullable
    @Generated
    public String getTaskRunId() {
        return this.taskRunId;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Double getValue() {
        return this.value;
    }

    @Generated
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    @Generated
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Nullable
    @Generated
    public ExecutionKind getExecutionKind() {
        return this.executionKind;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricEntry)) {
            return false;
        }
        MetricEntry other = (MetricEntry)o;
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Double this$value = this.getValue();
        Double other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$taskRunId = this.getTaskRunId();
        String other$taskRunId = other.getTaskRunId();
        if (this$taskRunId == null ? other$taskRunId != null : !this$taskRunId.equals(other$taskRunId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Instant this$timestamp = this.getTimestamp();
        Instant other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Map<String, String> this$tags = this.getTags();
        Map<String, String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        ExecutionKind this$executionKind = this.getExecutionKind();
        ExecutionKind other$executionKind = other.getExecutionKind();
        return !(this$executionKind == null ? other$executionKind != null : !((Object)((Object)this$executionKind)).equals((Object)other$executionKind));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Double $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $taskRunId = this.getTaskRunId();
        result = result * 59 + ($taskRunId == null ? 43 : $taskRunId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Instant $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Map<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        ExecutionKind $executionKind = this.getExecutionKind();
        result = result * 59 + ($executionKind == null ? 43 : ((Object)((Object)$executionKind)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetricEntry(tenantId=" + this.getTenantId() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", taskId=" + this.getTaskId() + ", executionId=" + this.getExecutionId() + ", taskRunId=" + this.getTaskRunId() + ", type=" + this.getType() + ", name=" + this.getName() + ", value=" + this.getValue() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", tags=" + String.valueOf(this.getTags()) + ", deleted=" + this.isDeleted() + ", executionKind=" + String.valueOf((Object)this.getExecutionKind()) + ")";
    }

    @Generated
    public static class MetricEntryBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private String taskId;
        @Generated
        private String executionId;
        @Generated
        private String taskRunId;
        @Generated
        private String type;
        @Generated
        private String name;
        @Generated
        private Double value;
        @Generated
        private Instant timestamp;
        @Generated
        private Map<String, String> tags;
        @Generated
        private boolean deleted$set;
        @Generated
        private boolean deleted$value;
        @Generated
        private ExecutionKind executionKind;

        @Generated
        MetricEntryBuilder() {
        }

        @Generated
        public MetricEntryBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public MetricEntryBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public MetricEntryBuilder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        @Generated
        public MetricEntryBuilder taskId(@Nullable String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Generated
        public MetricEntryBuilder executionId(@Nullable String executionId) {
            this.executionId = executionId;
            return this;
        }

        @Generated
        public MetricEntryBuilder taskRunId(@Nullable String taskRunId) {
            this.taskRunId = taskRunId;
            return this;
        }

        @Generated
        public MetricEntryBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public MetricEntryBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MetricEntryBuilder value(Double value) {
            this.value = value;
            return this;
        }

        @Generated
        public MetricEntryBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public MetricEntryBuilder tags(@Nullable Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public MetricEntryBuilder deleted(boolean deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return this;
        }

        @Generated
        public MetricEntryBuilder executionKind(@Nullable ExecutionKind executionKind) {
            this.executionKind = executionKind;
            return this;
        }

        @Generated
        public MetricEntry build() {
            boolean deleted$value = this.deleted$value;
            if (!this.deleted$set) {
                deleted$value = MetricEntry.$default$deleted();
            }
            return new MetricEntry(this.tenantId, this.namespace, this.flowId, this.taskId, this.executionId, this.taskRunId, this.type, this.name, this.value, this.timestamp, this.tags, deleted$value, this.executionKind);
        }

        @Generated
        public String toString() {
            return "MetricEntry.MetricEntryBuilder(tenantId=" + this.tenantId + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", taskId=" + this.taskId + ", executionId=" + this.executionId + ", taskRunId=" + this.taskRunId + ", type=" + this.type + ", name=" + this.name + ", value=" + this.value + ", timestamp=" + String.valueOf(this.timestamp) + ", tags=" + String.valueOf(this.tags) + ", deleted$value=" + this.deleted$value + ", executionKind=" + String.valueOf((Object)this.executionKind) + ")";
        }
    }
}

