/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.HasSource;
import io.kestra.core.models.HasUID;
import io.kestra.core.models.Label;
import io.kestra.core.models.TenantInterface;
import io.kestra.core.models.flows.Concurrency;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.flows.Output;
import io.kestra.core.models.flows.sla.SLA;
import io.kestra.core.models.tasks.WorkerGroup;
import io.kestra.core.serializers.JacksonMapper;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@JsonDeserialize(as=GenericFlow.class)
public interface FlowInterface
extends FlowId,
DeletedInterface,
TenantInterface,
HasUID,
HasSource {
    public static final Pattern YAML_REVISION_MATCHER = Pattern.compile("(?m)^revision: \\d+\n?");

    public String getDescription();

    public boolean isDisabled();

    @Override
    public boolean isDeleted();

    public List<Label> getLabels();

    public List<Input<?>> getInputs();

    public List<Output> getOutputs();

    public Map<String, Object> getVariables();

    public WorkerGroup getWorkerGroup();

    default public Concurrency getConcurrency() {
        return null;
    }

    default public List<SLA> getSla() {
        return List.of();
    }

    public String getSource();

    @Override
    @JsonIgnore
    default public String source() {
        return this.getSource();
    }

    @Override
    @JsonIgnore
    default public String uid() {
        return FlowId.uid(this);
    }

    @JsonIgnore
    default public String uidWithoutRevision() {
        return FlowId.uidWithoutRevision(this);
    }

    @JsonIgnore
    default public boolean isSameWithSource(FlowInterface flow) {
        return Objects.equals(this.uidWithoutRevision(), flow.uidWithoutRevision()) && Objects.equals(this.isDeleted(), flow.isDeleted()) && Objects.equals(this.isDisabled(), flow.isDisabled()) && Objects.equals(FlowInterface.sourceWithoutRevision(this.getSource()), FlowInterface.sourceWithoutRevision(flow.getSource()));
    }

    @JsonIgnore
    default public boolean isSameId(FlowId that) {
        if (that == null) {
            return false;
        }
        return Objects.equals(this.getTenantId(), that.getTenantId()) && Objects.equals(this.getNamespace(), that.getNamespace()) && Objects.equals(this.getId(), that.getId());
    }

    public static String sourceWithoutRevision(String source) {
        return YAML_REVISION_MATCHER.matcher(source).replaceFirst("");
    }

    default public String sourceOrGenerateIfNull() {
        return this.getSource() != null ? this.getSource() : SourceGenerator.generate(this);
    }

    public static class SourceGenerator {
        private static final ObjectMapper NON_DEFAULT_OBJECT_MAPPER = JacksonMapper.ofJson().copy().setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);

        static String generate(FlowInterface flow) {
            try {
                String json = NON_DEFAULT_OBJECT_MAPPER.writeValueAsString((Object)flow);
                Object map = SourceGenerator.fixSnakeYaml(JacksonMapper.toMap(json));
                String source = JacksonMapper.ofYaml().writeValueAsString(map);
                return FlowInterface.sourceWithoutRevision(source);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }

        private static Object fixSnakeYaml(Object object) {
            String item;
            if (object instanceof Map) {
                Map mapValue = (Map)object;
                return mapValue.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<Object, Object>(SourceGenerator.fixSnakeYaml(entry.getKey()), SourceGenerator.fixSnakeYaml(entry.getValue()))).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
                    throw new IllegalStateException(String.format("Duplicate key %s", u));
                }, LinkedHashMap::new));
            }
            if (object instanceof Collection) {
                Collection collectionValue = (Collection)object;
                return collectionValue.stream().map(SourceGenerator::fixSnakeYaml).toList();
            }
            if (object instanceof String && (item = (String)object).contains("\n")) {
                return item.replaceAll("\\s+\\n", "\\\n");
            }
            return object;
        }
    }
}

