/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import com.fasterxml.jackson.databind.JsonNode;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.serializers.JacksonMapper;
import io.micronaut.core.annotation.Introspected;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;

@Introspected
public class FlowWithException
extends FlowWithSource {
    String exception;

    public static FlowWithException from(FlowInterface flow, Exception exception) {
        return ((FlowWithExceptionBuilder)((FlowWithExceptionBuilder)((Flow.FlowBuilder)((FlowWithExceptionBuilder)((FlowWithExceptionBuilder)((FlowWithExceptionBuilder)((FlowWithExceptionBuilder)((FlowWithExceptionBuilder)FlowWithException.builder().id(flow.getId())).tenantId(flow.getTenantId())).namespace(flow.getNamespace())).revision(flow.getRevision())).deleted(flow.isDeleted())).exception(exception.getMessage())).tasks(List.of())).source(flow.getSource())).build();
    }

    public static Optional<FlowWithException> from(String source, Exception exception, Logger log) {
        log.error("Unable to deserialize a flow: {}", (Object)exception.getMessage());
        try {
            JsonNode jsonNode = JacksonMapper.ofJson().readTree(source);
            return FlowWithException.from(jsonNode, exception);
        }
        catch (IOException e) {
            log.error("Unexpected exception when trying to handle a deserialization error", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<FlowWithException> from(JsonNode jsonNode, Exception exception) {
        if (jsonNode.hasNonNull("id") && jsonNode.hasNonNull("namespace")) {
            String tenantId = jsonNode.hasNonNull("tenant_id") ? jsonNode.get("tenant_id").asText() : (jsonNode.hasNonNull("tenantId") ? jsonNode.get("tenantId").asText() : null);
            FlowWithSource flow = ((FlowWithExceptionBuilder)((FlowWithExceptionBuilder)((Flow.FlowBuilder)((FlowWithExceptionBuilder)((FlowWithExceptionBuilder)((FlowWithExceptionBuilder)((FlowWithExceptionBuilder)((FlowWithExceptionBuilder)FlowWithException.builder().id(jsonNode.get("id").asText())).tenantId(tenantId)).namespace(jsonNode.get("namespace").asText())).revision(jsonNode.hasNonNull("revision") ? jsonNode.get("revision").asInt() : 1)).deleted(jsonNode.hasNonNull("deleted") && jsonNode.get("deleted").asBoolean())).exception(exception.getMessage())).tasks(List.of())).source(jsonNode.hasNonNull("source") ? jsonNode.get("source").asText() : null)).build();
            return Optional.of(flow);
        }
        return Optional.empty();
    }

    @Override
    public Flow toFlow() {
        return this;
    }

    @Generated
    protected FlowWithException(FlowWithExceptionBuilder<?, ?> b) {
        super((FlowWithSource.FlowWithSourceBuilder<?, ?>)b);
        this.exception = b.exception;
    }

    @Generated
    public static FlowWithExceptionBuilder<?, ?> builder() {
        return new FlowWithExceptionBuilderImpl();
    }

    @Override
    @Generated
    public FlowWithExceptionBuilder<?, ?> toBuilder() {
        return new FlowWithExceptionBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getException() {
        return this.exception;
    }

    @Generated
    public FlowWithException() {
    }

    @Override
    @Generated
    public String toString() {
        return "FlowWithException(super=" + super.toString() + ", exception=" + this.getException() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowWithException)) {
            return false;
        }
        FlowWithException other = (FlowWithException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$exception = this.getException();
        String other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlowWithException;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    @Generated
    public static abstract class FlowWithExceptionBuilder<C extends FlowWithException, B extends FlowWithExceptionBuilder<C, B>>
    extends FlowWithSource.FlowWithSourceBuilder<C, B> {
        @Generated
        private String exception;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FlowWithExceptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(FlowWithException instance, FlowWithExceptionBuilder<?, ?> b) {
            b.exception(instance.exception);
        }

        @Generated
        public B exception(String exception) {
            this.exception = exception;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "FlowWithException.FlowWithExceptionBuilder(super=" + super.toString() + ", exception=" + this.exception + ")";
        }
    }

    @Generated
    private static final class FlowWithExceptionBuilderImpl
    extends FlowWithExceptionBuilder<FlowWithException, FlowWithExceptionBuilderImpl> {
        @Generated
        private FlowWithExceptionBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowWithExceptionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public FlowWithException build() {
            return new FlowWithException(this);
        }
    }
}

