/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.property;

import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.Namespace;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;

public class URIFetcher {
    private static final List<String> SUPPORTED_SCHEMES = List.of("kestra", "file", "nsfile");
    private final URI uri;

    public URIFetcher(String uri) {
        this(URI.create(uri));
    }

    public URIFetcher(URI uri) {
        if (SUPPORTED_SCHEMES.stream().noneMatch(s -> s.equals(uri.getScheme()))) {
            throw new IllegalArgumentException("Scheme not supported: " + uri.getScheme() + ". Supported schemes are: " + String.valueOf(SUPPORTED_SCHEMES));
        }
        this.uri = uri;
    }

    public static URIFetcher of(String uri) {
        return new URIFetcher(uri);
    }

    public static URIFetcher of(URI uri) {
        return new URIFetcher(uri);
    }

    public static boolean supports(String uri) {
        return SUPPORTED_SCHEMES.stream().anyMatch(scheme -> uri.startsWith(scheme + "://"));
    }

    public static boolean supports(URI uri) {
        return uri.getScheme() != null && SUPPORTED_SCHEMES.contains(uri.getScheme());
    }

    public InputStream fetch(RunContext runContext) throws IOException {
        if (this.uri == null) {
            return InputStream.nullInputStream();
        }
        return switch (this.uri.getScheme()) {
            case "kestra" -> runContext.storage().getFile(this.uri);
            case "file" -> runContext.localPath().get(this.uri);
            case "nsfile" -> {
                Namespace namespace = this.uri.getAuthority() == null ? runContext.storage().namespace() : runContext.storage().namespace(this.uri.getAuthority());
                URI nsFileUri = namespace.get(Path.of(this.uri.getPath(), new String[0])).uri();
                yield runContext.storage().getFile(nsFileUri);
            }
            default -> throw new IllegalArgumentException("Scheme not supported: " + this.uri.getScheme());
        };
    }
}

