/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.tasks.Task;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

public final class ResolvedTask {
    @NotNull
    private final Task task;
    private final String value;
    private final Integer iteration;
    private final String parentId;

    public NextTaskRun toNextTaskRun(Execution execution) {
        return new NextTaskRun(TaskRun.of(execution, this), this.getTask());
    }

    public NextTaskRun toNextTaskRunIncrementIteration(Execution execution, Integer iteration) {
        return new NextTaskRun(TaskRun.of(execution, this).withIteration(iteration != null ? iteration : 1), this.getTask());
    }

    public static ResolvedTask of(Task task) {
        return ResolvedTask.builder().task(task).build();
    }

    public static List<ResolvedTask> of(List<Task> tasks) {
        if (tasks == null) {
            return null;
        }
        return tasks.stream().map(ResolvedTask::of).toList();
    }

    @ConstructorProperties(value={"task", "value", "iteration", "parentId"})
    @Generated
    ResolvedTask(Task task, String value, Integer iteration, String parentId) {
        this.task = task;
        this.value = value;
        this.iteration = iteration;
        this.parentId = parentId;
    }

    @Generated
    public static ResolvedTaskBuilder builder() {
        return new ResolvedTaskBuilder();
    }

    @Generated
    public Task getTask() {
        return this.task;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public Integer getIteration() {
        return this.iteration;
    }

    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedTask)) {
            return false;
        }
        ResolvedTask other = (ResolvedTask)o;
        Integer this$iteration = this.getIteration();
        Integer other$iteration = other.getIteration();
        if (this$iteration == null ? other$iteration != null : !((Object)this$iteration).equals(other$iteration)) {
            return false;
        }
        Task this$task = this.getTask();
        Task other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        return !(this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $iteration = this.getIteration();
        result = result * 59 + ($iteration == null ? 43 : ((Object)$iteration).hashCode());
        Task $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ResolvedTask(task=" + String.valueOf(this.getTask()) + ", value=" + this.getValue() + ", iteration=" + this.getIteration() + ", parentId=" + this.getParentId() + ")";
    }

    @Generated
    public static class ResolvedTaskBuilder {
        @Generated
        private Task task;
        @Generated
        private String value;
        @Generated
        private Integer iteration;
        @Generated
        private String parentId;

        @Generated
        ResolvedTaskBuilder() {
        }

        @Generated
        public ResolvedTaskBuilder task(Task task) {
            this.task = task;
            return this;
        }

        @Generated
        public ResolvedTaskBuilder value(String value) {
            this.value = value;
            return this;
        }

        @Generated
        public ResolvedTaskBuilder iteration(Integer iteration) {
            this.iteration = iteration;
            return this;
        }

        @Generated
        public ResolvedTaskBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        @Generated
        public ResolvedTask build() {
            return new ResolvedTask(this.task, this.value, this.iteration, this.parentId);
        }

        @Generated
        public String toString() {
            return "ResolvedTask.ResolvedTaskBuilder(task=" + String.valueOf(this.task) + ", value=" + this.value + ", iteration=" + this.iteration + ", parentId=" + this.parentId + ")";
        }
    }
}

