/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.retrys;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.kestra.core.models.tasks.retrys.Constant;
import io.kestra.core.models.tasks.retrys.Exponential;
import io.kestra.core.models.tasks.retrys.Random;
import io.micronaut.core.annotation.Introspected;
import jakarta.validation.constraints.Min;
import java.time.Duration;
import java.time.Instant;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Constant.class, name="constant"), @JsonSubTypes.Type(value=Exponential.class, name="exponential"), @JsonSubTypes.Type(value=Random.class, name="random")})
@Introspected
public abstract class AbstractRetry {
    private Duration maxDuration;
    @Min(value=1L)
    private @Min(value=1L) Integer maxAttempts;
    private Boolean warningOnRetry;
    private Behavior behavior;

    public abstract String getType();

    @Deprecated(forRemoval=true)
    public Integer getMaxAttempt() {
        return this.maxAttempts;
    }

    @Deprecated(forRemoval=true)
    public void setMaxAttempt(@Min(value=1L) @Min(value=1L) Integer maxAttempt) {
        this.maxAttempts = maxAttempt;
    }

    public abstract Instant nextRetryDate(Integer var1, Instant var2);

    public <T> RetryPolicyBuilder<T> toPolicy() {
        RetryPolicyBuilder builder = RetryPolicy.builder();
        if (this.maxDuration != null) {
            builder.withMaxDuration(this.maxDuration);
        }
        if (this.maxAttempts != null) {
            builder.withMaxAttempts(this.maxAttempts.intValue());
        }
        return builder;
    }

    public static <T> RetryPolicyBuilder<T> retryPolicy(AbstractRetry retry) {
        if (retry != null) {
            return retry.toPolicy();
        }
        return RetryPolicy.builder().withMaxAttempts(1);
    }

    @Generated
    private static Boolean $default$warningOnRetry() {
        return false;
    }

    @Generated
    private static Behavior $default$behavior() {
        return Behavior.RETRY_FAILED_TASK;
    }

    @Generated
    protected AbstractRetry(AbstractRetryBuilder<?, ?> b) {
        this.maxDuration = b.maxDuration;
        this.maxAttempts = b.maxAttempts;
        this.warningOnRetry = b.warningOnRetry$set ? b.warningOnRetry$value : AbstractRetry.$default$warningOnRetry();
        this.behavior = b.behavior$set ? b.behavior$value : AbstractRetry.$default$behavior();
    }

    @Generated
    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    @Generated
    public Integer getMaxAttempts() {
        return this.maxAttempts;
    }

    @Generated
    public Boolean getWarningOnRetry() {
        return this.warningOnRetry;
    }

    @Generated
    public Behavior getBehavior() {
        return this.behavior;
    }

    @Generated
    public AbstractRetry() {
        this.warningOnRetry = AbstractRetry.$default$warningOnRetry();
        this.behavior = AbstractRetry.$default$behavior();
    }

    public static enum Behavior {
        RETRY_FAILED_TASK,
        CREATE_NEW_EXECUTION;

    }

    @Generated
    public static abstract class AbstractRetryBuilder<C extends AbstractRetry, B extends AbstractRetryBuilder<C, B>> {
        @Generated
        private Duration maxDuration;
        @Generated
        private Integer maxAttempts;
        @Generated
        private boolean warningOnRetry$set;
        @Generated
        private Boolean warningOnRetry$value;
        @Generated
        private boolean behavior$set;
        @Generated
        private Behavior behavior$value;

        @Generated
        public B maxDuration(Duration maxDuration) {
            this.maxDuration = maxDuration;
            return this.self();
        }

        @Generated
        public B maxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this.self();
        }

        @Generated
        public B warningOnRetry(Boolean warningOnRetry) {
            this.warningOnRetry$value = warningOnRetry;
            this.warningOnRetry$set = true;
            return this.self();
        }

        @Generated
        public B behavior(Behavior behavior) {
            this.behavior$value = behavior;
            this.behavior$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "AbstractRetry.AbstractRetryBuilder(maxDuration=" + String.valueOf(this.maxDuration) + ", maxAttempts=" + this.maxAttempts + ", warningOnRetry$value=" + this.warningOnRetry$value + ", behavior$value=" + String.valueOf((Object)this.behavior$value) + ")";
        }
    }
}

