/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.retrys;

import com.fasterxml.jackson.annotation.JsonInclude;
import dev.failsafe.RetryPolicyBuilder;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.validations.ExponentialRetryValidation;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import lombok.Generated;

@ExponentialRetryValidation
public class Exponential
extends AbstractRetry {
    @NotNull
    @JsonInclude
    protected String type;
    @NotNull
    private Duration interval;
    @NotNull
    private Duration maxInterval;
    private Double delayFactor;

    @Override
    public <T> RetryPolicyBuilder<T> toPolicy() {
        RetryPolicyBuilder policy = super.toPolicy();
        if (this.delayFactor != null) {
            policy.withBackoff(this.interval.toMillis(), this.maxInterval.toMillis(), ChronoUnit.MILLIS, this.delayFactor.doubleValue());
        } else {
            policy.withBackoff(this.interval.toMillis(), this.maxInterval.toMillis(), ChronoUnit.MILLIS);
        }
        return policy;
    }

    @Override
    public Instant nextRetryDate(Integer attemptCount, Instant lastAttempt) {
        Duration computedInterval = this.interval.multipliedBy((long)(this.delayFactor == null ? 2 : this.delayFactor.intValue()) * (long)(attemptCount - 1));
        Instant next = lastAttempt.plus(computedInterval);
        if (next.isAfter(lastAttempt.plus(this.maxInterval))) {
            return lastAttempt.plus(this.maxInterval);
        }
        return next;
    }

    @Generated
    private static String $default$type() {
        return "exponential";
    }

    @Generated
    protected Exponential(ExponentialBuilder<?, ?> b) {
        super(b);
        this.type = b.type$set ? b.type$value : Exponential.$default$type();
        this.interval = b.interval;
        this.maxInterval = b.maxInterval;
        this.delayFactor = b.delayFactor;
    }

    @Generated
    public static ExponentialBuilder<?, ?> builder() {
        return new ExponentialBuilderImpl();
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Duration getInterval() {
        return this.interval;
    }

    @Generated
    public Duration getMaxInterval() {
        return this.maxInterval;
    }

    @Generated
    public Double getDelayFactor() {
        return this.delayFactor;
    }

    @Generated
    public Exponential() {
        this.type = Exponential.$default$type();
    }

    @Generated
    public static abstract class ExponentialBuilder<C extends Exponential, B extends ExponentialBuilder<C, B>>
    extends AbstractRetry.AbstractRetryBuilder<C, B> {
        @Generated
        private boolean type$set;
        @Generated
        private String type$value;
        @Generated
        private Duration interval;
        @Generated
        private Duration maxInterval;
        @Generated
        private Double delayFactor;

        @Generated
        public B type(String type) {
            this.type$value = type;
            this.type$set = true;
            return (B)this.self();
        }

        @Generated
        public B interval(Duration interval) {
            this.interval = interval;
            return (B)this.self();
        }

        @Generated
        public B maxInterval(Duration maxInterval) {
            this.maxInterval = maxInterval;
            return (B)this.self();
        }

        @Generated
        public B delayFactor(Double delayFactor) {
            this.delayFactor = delayFactor;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Exponential.ExponentialBuilder(super=" + super.toString() + ", type$value=" + this.type$value + ", interval=" + String.valueOf(this.interval) + ", maxInterval=" + String.valueOf(this.maxInterval) + ", delayFactor=" + this.delayFactor + ")";
        }
    }

    @Generated
    private static final class ExponentialBuilderImpl
    extends ExponentialBuilder<Exponential, ExponentialBuilderImpl> {
        @Generated
        private ExponentialBuilderImpl() {
        }

        @Override
        @Generated
        protected ExponentialBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Exponential build() {
            return new Exponential(this);
        }
    }
}

