/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.runners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.tasks.runners.TaskLogLineMatcher;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.services.FlowService;
import io.kestra.core.utils.Rethrow;
import jakarta.validation.constraints.NotNull;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class PluginUtilsService {
    private static final TypeReference<Map<String, String>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, String>>(){};

    public static Map<String, String> createOutputFiles(Path tempDirectory, List<String> outputFiles, Map<String, Object> additionalVars) throws IOException {
        return PluginUtilsService.createOutputFiles(tempDirectory, outputFiles, additionalVars, false);
    }

    public static Map<String, String> createOutputFiles(Path tempDirectory, List<String> outputFiles, Map<String, Object> additionalVars, Boolean isDir) throws IOException {
        ArrayList<String> outputs = new ArrayList<String>();
        if (outputFiles != null && !outputFiles.isEmpty()) {
            outputs.addAll(outputFiles);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (!outputs.isEmpty()) {
            outputs.forEach(Rethrow.throwConsumer(s -> {
                File tempFile;
                PluginUtilsService.validFilename(s);
                if (isDir.booleanValue()) {
                    tempFile = Files.createTempDirectory(tempDirectory, s + "_", new FileAttribute[0]).toFile();
                } else {
                    String prefix = StringUtils.leftPad((String)(s + "_"), (int)3, (String)"_");
                    tempFile = File.createTempFile(prefix, null, tempDirectory.toFile());
                }
                result.put((String)s, String.valueOf(additionalVars.get("workingDir")) + "/" + tempFile.getName());
            }));
            if (!isDir.booleanValue()) {
                additionalVars.put("temp", result);
            }
            additionalVars.put(isDir != false ? "outputDirs" : "outputFiles", result);
        }
        return result;
    }

    private static void validFilename(String s) {
        if (s.startsWith("./") || s.startsWith("..") || s.startsWith("/")) {
            throw new IllegalArgumentException("Invalid outputFile (only relative path is supported) for path '" + s + "'");
        }
    }

    public static Map<String, String> transformInputFiles(RunContext runContext, @NotNull Object inputFiles) throws IllegalVariableEvaluationException, JsonProcessingException {
        return PluginUtilsService.transformInputFiles(runContext, Collections.emptyMap(), inputFiles);
    }

    public static Map<String, String> transformInputFiles(RunContext runContext, Map<String, Object> additionalVars, @NotNull Object inputFiles) throws IllegalVariableEvaluationException, JsonProcessingException {
        if (inputFiles instanceof Map) {
            Map castedInputFiles = (Map)inputFiles;
            HashMap<String, String> nullFilteredInputFiles = new HashMap<String, String>();
            castedInputFiles.forEach((key, val) -> {
                if (val != null) {
                    nullFilteredInputFiles.put((String)key, (String)val);
                }
            });
            return runContext.renderMap(nullFilteredInputFiles, additionalVars);
        }
        if (inputFiles instanceof String) {
            String inputFileString = (String)inputFiles;
            return (Map)JacksonMapper.ofJson(false).readValue(runContext.render(inputFileString, additionalVars), MAP_TYPE_REFERENCE);
        }
        throw new IllegalVariableEvaluationException("Invalid `files` properties with type '" + String.valueOf(inputFiles != null ? inputFiles.getClass() : "null") + "'");
    }

    public static void createInputFiles(RunContext runContext, Path workingDirectory, Map<String, String> inputFiles, Map<String, Object> additionalVars) throws IOException, IllegalVariableEvaluationException, URISyntaxException {
        if (inputFiles != null && inputFiles.size() > 0) {
            for (String fileName : inputFiles.keySet()) {
                Path subFolder;
                String finalFileName = runContext.render(fileName);
                PluginUtilsService.validFilename(finalFileName);
                File file = new File(fileName);
                if (file.getParent() != null && !(subFolder = Paths.get(workingDirectory.toAbsolutePath().toString(), new File(finalFileName).getParent())).toFile().exists()) {
                    Files.createDirectories(subFolder, new FileAttribute[0]);
                }
                String filePath = String.valueOf(workingDirectory) + "/" + finalFileName;
                String render = runContext.render(inputFiles.get(fileName), additionalVars);
                if (render.startsWith("kestra://")) {
                    InputStream inputStream = runContext.storage().getFile(new URI(render));
                    try {
                        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(filePath));
                        try {
                            int byteRead;
                            while ((byteRead = inputStream.read()) != -1) {
                                ((OutputStream)outputStream).write(byteRead);
                            }
                            ((OutputStream)outputStream).flush();
                            continue;
                        }
                        finally {
                            ((OutputStream)outputStream).close();
                            continue;
                        }
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        continue;
                    }
                }
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
                    writer.write(render);
                }
            }
        }
    }

    public static Map<String, Object> parseOut(String line, Logger logger, RunContext runContext, boolean isStdErr, Instant customInstant) {
        TaskLogLineMatcher logLineMatcher = (TaskLogLineMatcher)((DefaultRunContext)runContext).getApplicationContext().getBean(TaskLogLineMatcher.class);
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        try {
            Optional<TaskLogLineMatcher.TaskLogMatch> matches = logLineMatcher.matches(line, logger, runContext, customInstant);
            if (matches.isPresent()) {
                TaskLogLineMatcher.TaskLogMatch taskLogMatch = matches.get();
                outputs.putAll(taskLogMatch.outputs());
            } else if (isStdErr) {
                runContext.logger().error(line);
            } else {
                runContext.logger().info(line);
            }
        }
        catch (IOException e) {
            logger.warn("Invalid outputs '{}'", (Object)e.getMessage(), (Object)e);
        }
        return outputs;
    }

    public static ExecutionInfo executionFromTaskParameters(RunContext runContext, String namespace, String flowId, String executionId) throws IllegalVariableEvaluationException {
        String realFlowId;
        String realNamespace;
        String realExecutionId;
        RunContext.FlowInfo flowInfo = runContext.flowInfo();
        String realTenantId = flowInfo.tenantId();
        if (executionId != null) {
            realExecutionId = runContext.render(executionId);
            if (namespace != null && flowId != null) {
                realNamespace = runContext.render(namespace);
                realFlowId = runContext.render(flowId);
                FlowService flowService = (FlowService)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowService.class);
                flowService.checkAllowedNamespace(flowInfo.tenantId(), realNamespace, flowInfo.tenantId(), flowInfo.namespace());
            } else {
                if (namespace != null || flowId != null) {
                    throw new IllegalArgumentException("Both `namespace` and `flowId` must be set when `executionId` is set.");
                }
                realNamespace = flowInfo.namespace();
                realFlowId = flowInfo.id();
            }
        } else {
            if (namespace != null || flowId != null) {
                throw new IllegalArgumentException("`namespace` and `flowId` should only be set when `executionId` is set.");
            }
            realExecutionId = (String)new HashMap((Map)runContext.getVariables().get("execution")).get("id");
            realNamespace = flowInfo.namespace();
            realFlowId = flowInfo.id();
        }
        return new ExecutionInfo(realTenantId, realNamespace, realFlowId, realExecutionId);
    }

    public record ExecutionInfo(String tenantId, String namespace, String flowId, String id) {
    }
}

