/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import io.kestra.core.models.flows.State;
import io.kestra.core.models.triggers.Backfill;
import io.kestra.core.utils.IdUtils;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;

@Introspected
public class TriggerContext {
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]")
    private @Pattern(regexp="^[a-z0-9][a-z0-9_-]") String tenantId;
    @NotNull
    private String namespace;
    @NotNull
    private String flowId;
    @NotNull
    private String triggerId;
    @NotNull
    private ZonedDateTime date;
    @Nullable
    private ZonedDateTime nextExecutionDate;
    @Nullable
    private Backfill backfill;
    @Nullable
    private List<State.Type> stopAfter;
    private Boolean disabled = Boolean.FALSE;

    protected TriggerContext(TriggerContextBuilder<?, ?> b) {
        this.tenantId = b.tenantId;
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.triggerId = b.triggerId;
        this.date = b.date;
        this.nextExecutionDate = b.nextExecutionDate;
        this.backfill = b.backfill;
        this.stopAfter = b.stopAfter;
        this.disabled = b.disabled;
    }

    public static TriggerContextBuilder<?, ?> builder() {
        return new TriggerContextBuilderImpl();
    }

    public String uid() {
        return TriggerContext.uid(this);
    }

    public static String uid(TriggerContext trigger) {
        return IdUtils.fromParts(trigger.getTenantId(), trigger.getNamespace(), trigger.getFlowId(), trigger.getTriggerId());
    }

    public Boolean getDisabled() {
        return this.disabled != null ? this.disabled : Boolean.FALSE;
    }

    @Generated
    public TriggerContextBuilder<?, ?> toBuilder() {
        return new TriggerContextBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String toString() {
        return "TriggerContext(tenantId=" + this.getTenantId() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", triggerId=" + this.getTriggerId() + ", date=" + String.valueOf(this.getDate()) + ", nextExecutionDate=" + String.valueOf(this.getNextExecutionDate()) + ", backfill=" + String.valueOf(this.getBackfill()) + ", stopAfter=" + String.valueOf(this.getStopAfter()) + ", disabled=" + this.getDisabled() + ")";
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public String getTriggerId() {
        return this.triggerId;
    }

    @Generated
    public ZonedDateTime getDate() {
        return this.date;
    }

    @Generated
    public ZonedDateTime getNextExecutionDate() {
        return this.nextExecutionDate;
    }

    @Generated
    public Backfill getBackfill() {
        return this.backfill;
    }

    @Generated
    public List<State.Type> getStopAfter() {
        return this.stopAfter;
    }

    @Generated
    public TriggerContext() {
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public static abstract class TriggerContextBuilder<C extends TriggerContext, B extends TriggerContextBuilder<C, B>> {
        @Generated
        private String tenantId;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private String triggerId;
        @Generated
        private ZonedDateTime date;
        @Generated
        private ZonedDateTime nextExecutionDate;
        @Generated
        private Backfill backfill;
        @Generated
        private List<State.Type> stopAfter;
        @Generated
        private Boolean disabled;

        @Generated
        protected B $fillValuesFrom(C instance) {
            TriggerContextBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(TriggerContext instance, TriggerContextBuilder<?, ?> b) {
            b.tenantId(instance.tenantId);
            b.namespace(instance.namespace);
            b.flowId(instance.flowId);
            b.triggerId(instance.triggerId);
            b.date(instance.date);
            b.nextExecutionDate(instance.nextExecutionDate);
            b.backfill(instance.backfill);
            b.stopAfter(instance.stopAfter);
            b.disabled(instance.disabled);
        }

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B flowId(String flowId) {
            this.flowId = flowId;
            return this.self();
        }

        @Generated
        public B triggerId(String triggerId) {
            this.triggerId = triggerId;
            return this.self();
        }

        @Generated
        public B date(ZonedDateTime date) {
            this.date = date;
            return this.self();
        }

        @Generated
        public B nextExecutionDate(ZonedDateTime nextExecutionDate) {
            this.nextExecutionDate = nextExecutionDate;
            return this.self();
        }

        @Generated
        public B backfill(Backfill backfill) {
            this.backfill = backfill;
            return this.self();
        }

        @Generated
        public B stopAfter(List<State.Type> stopAfter) {
            this.stopAfter = stopAfter;
            return this.self();
        }

        @Generated
        public B disabled(Boolean disabled) {
            this.disabled = disabled;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TriggerContext.TriggerContextBuilder(tenantId=" + this.tenantId + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", triggerId=" + this.triggerId + ", date=" + String.valueOf(this.date) + ", nextExecutionDate=" + String.valueOf(this.nextExecutionDate) + ", backfill=" + String.valueOf(this.backfill) + ", stopAfter=" + String.valueOf(this.stopAfter) + ", disabled=" + this.disabled + ")";
        }
    }

    @Generated
    private static final class TriggerContextBuilderImpl
    extends TriggerContextBuilder<TriggerContext, TriggerContextBuilderImpl> {
        @Generated
        private TriggerContextBuilderImpl() {
        }

        @Override
        @Generated
        protected TriggerContextBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TriggerContext build() {
            return new TriggerContext(this);
        }
    }
}

