/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.validations;

import io.kestra.core.models.flows.Input;
import io.kestra.core.models.tasks.Task;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KestraConstraintViolationException
extends ConstraintViolationException {
    private static final long serialVersionUID = 1L;

    public KestraConstraintViolationException(Set<? extends ConstraintViolation<?>> constraintViolations) {
        super(constraintViolations);
    }

    public String getMessage() {
        StringBuilder message = new StringBuilder();
        for (ConstraintViolation violation : this.getConstraintViolations()) {
            String errorMessage = String.valueOf(violation.getPropertyPath()) + ": " + violation.getMessage();
            try {
                Object object = violation.getLeafBean();
                if (object instanceof Task) {
                    Task task = (Task)object;
                    errorMessage = this.replaceId("tasks", violation.getPropertyPath().toString(), task.getId()) + ": " + violation.getMessage();
                }
                if ((object = violation.getLeafBean()) instanceof Input) {
                    Input input = (Input)object;
                    errorMessage = this.replaceId("inputs", violation.getPropertyPath().toString(), input.getId()) + ": " + violation.getMessage();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            message.append(errorMessage).append("\n");
        }
        return message.toString();
    }

    private String replaceId(String type, String errorMessage, String taskId) {
        String regex = type + "\\[\\d+\\]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(errorMessage);
        return matcher.replaceAll(taskId);
    }
}

