/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.models.Plugin;
import io.kestra.core.plugins.ExternalPlugin;
import io.kestra.core.plugins.PluginClassAndMetadata;
import io.kestra.core.plugins.PluginIdentifier;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.plugins.PluginScanner;
import io.kestra.core.plugins.RegisteredPlugin;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginRegistry
implements PluginRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginRegistry.class);
    protected final Map<PluginIdentifier, PluginClassAndMetadata<? extends Plugin>> pluginClassByIdentifier = new ConcurrentHashMap<PluginIdentifier, PluginClassAndMetadata<? extends Plugin>>();
    private final Map<PluginBundleIdentifier, RegisteredPlugin> plugins = new ConcurrentHashMap<PluginBundleIdentifier, RegisteredPlugin>();
    private final PluginScanner scanner = new PluginScanner(DefaultPluginRegistry.class.getClassLoader());
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Set<Path> scannedPluginPaths = new HashSet<Path>();
    private final ReentrantLock lock = new ReentrantLock();

    public static DefaultPluginRegistry getOrCreate() {
        DefaultPluginRegistry instance = LazyHolder.INSTANCE;
        if (!instance.isInitialized()) {
            instance.init();
        }
        return instance;
    }

    protected DefaultPluginRegistry() {
    }

    private boolean isInitialized() {
        return this.initialized.get();
    }

    protected void init() {
        if (this.initialized.compareAndSet(false, true)) {
            this.register(this.scanner.scan());
        }
    }

    @Override
    public List<String> getAllVersionsForType(String type) {
        return this.plugins.values().stream().filter(registered -> registered.allClass().stream().map(Class::getName).anyMatch(cls -> cls.equalsIgnoreCase(type))).findFirst().map(RegisteredPlugin::version).filter(Objects::nonNull).map(List::of).orElse(List.of());
    }

    @Override
    public void registerIfAbsent(Path pluginPath) {
        long start = System.currentTimeMillis();
        if (DefaultPluginRegistry.isPluginPathValid(pluginPath) && !this.isPluginPathScanned(pluginPath)) {
            List<RegisteredPlugin> scanned = this.scanner.scan(pluginPath);
            scanned.forEach(this::register);
            this.scannedPluginPaths.add(pluginPath);
        }
        log.debug("Registered if absent plugins from path {} in {} ms", (Object)pluginPath, (Object)(System.currentTimeMillis() - start));
    }

    private boolean isPluginPathScanned(Path pluginPath) {
        return this.scannedPluginPaths.contains(pluginPath);
    }

    @Override
    public void register(Path pluginPath) {
        long start = System.currentTimeMillis();
        if (DefaultPluginRegistry.isPluginPathValid(pluginPath)) {
            List<RegisteredPlugin> scanned = this.scanner.scan(pluginPath);
            scanned.forEach(this::register);
        }
        log.debug("Registered plugins from path {} in {} ms", (Object)pluginPath, (Object)(System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(List<RegisteredPlugin> pluginsToUnregister) {
        if (pluginsToUnregister == null || pluginsToUnregister.isEmpty()) {
            return;
        }
        ArrayList<RegisteredPlugin> mutablePluginsToUnregister = new ArrayList<RegisteredPlugin>(pluginsToUnregister);
        this.lock.lock();
        try {
            ListIterator<RegisteredPlugin> iter = mutablePluginsToUnregister.listIterator();
            while (iter.hasNext()) {
                RegisteredPlugin current = iter.next();
                PluginBundleIdentifier identifier = PluginBundleIdentifier.of(current);
                if (identifier.equals(PluginBundleIdentifier.CORE)) continue;
                this.plugins.remove(identifier);
                this.pluginClassByIdentifier.entrySet().removeIf(entry -> {
                    PluginClassAndMetadata metadata = (PluginClassAndMetadata)entry.getValue();
                    return metadata.type().getClassLoader().equals(current.getClassLoader());
                });
                ClassLoader classLoader = current.getClassLoader();
                if (classLoader instanceof Closeable) {
                    Closeable closeable = (Closeable)((Object)classLoader);
                    try {
                        closeable.close();
                    }
                    catch (IOException e) {
                        log.warn("Unexpected error while closing ClassLoader for plugins under {}", (Object)identifier.location(), (Object)e);
                    }
                }
                iter.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void registerClassForIdentifier(PluginIdentifier identifier, PluginClassAndMetadata<? extends Plugin> plugin) {
        this.pluginClassByIdentifier.put(identifier, plugin);
    }

    private static boolean isPluginPathValid(Path pluginPath) {
        return pluginPath != null && pluginPath.toFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RegisteredPlugin plugin) {
        PluginBundleIdentifier identifier = PluginBundleIdentifier.of(plugin);
        RegisteredPlugin existing = this.plugins.get(identifier);
        if (existing != null && existing.crc32() == plugin.crc32()) {
            return;
        }
        this.lock.lock();
        try {
            if (existing != null) {
                this.unregister(List.of(existing));
            }
            this.plugins.put(PluginBundleIdentifier.of(plugin), plugin);
            this.registerAll(this.getPluginClassesByIdentifier(plugin));
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void registerAll(Map<PluginIdentifier, PluginClassAndMetadata<? extends Plugin>> plugins) {
        this.pluginClassByIdentifier.putAll(plugins);
    }

    protected Map<PluginIdentifier, PluginClassAndMetadata<? extends Plugin>> getPluginClassesByIdentifier(RegisteredPlugin plugin) {
        HashMap<PluginIdentifier, PluginClassAndMetadata<? extends Plugin>> classes = new HashMap<PluginIdentifier, PluginClassAndMetadata<? extends Plugin>>();
        classes.putAll(plugin.allClass().stream().map(cls -> {
            Class pluginClass = cls;
            Class pluginBaseClass = plugin.baseClass(pluginClass.getName());
            return new AbstractMap.SimpleEntry(ClassTypeIdentifier.create(cls.getName()), PluginClassAndMetadata.create(plugin, pluginClass, pluginBaseClass, null));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        classes.putAll(plugin.getAliases().values().stream().map(e -> {
            Class pluginClass = (Class)e.getValue();
            Class pluginBaseClass = plugin.baseClass(pluginClass.getName());
            return new AbstractMap.SimpleEntry(ClassTypeIdentifier.create((String)e.getKey()), PluginClassAndMetadata.create(plugin, pluginClass, pluginBaseClass, (String)e.getKey()));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return classes;
    }

    private boolean containsPluginBundle(PluginBundleIdentifier identifier) {
        return this.plugins.containsKey(identifier);
    }

    @Override
    public List<RegisteredPlugin> plugins() {
        return this.plugins(null);
    }

    @Override
    public List<RegisteredPlugin> externalPlugins() {
        return this.plugins(plugin -> plugin.getExternalPlugin() != null);
    }

    @Override
    public List<RegisteredPlugin> plugins(Predicate<RegisteredPlugin> predicate) {
        if (predicate == null) {
            return new ArrayList<RegisteredPlugin>(this.plugins.values());
        }
        return this.plugins.values().stream().filter(predicate).toList();
    }

    @Override
    public Class<? extends Plugin> findClassByIdentifier(PluginIdentifier identifier) {
        Objects.requireNonNull(identifier, "Cannot found plugin for null identifier");
        this.lock.lock();
        try {
            Class clazz = this.findMetadataByIdentifier(identifier).map(PluginClassAndMetadata::type).orElse(null);
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Class<? extends Plugin> findClassByIdentifier(String identifier) {
        Objects.requireNonNull(identifier, "Cannot found plugin for null identifier");
        this.lock.lock();
        try {
            Class<? extends Plugin> clazz = this.findClassByIdentifier(ClassTypeIdentifier.create(identifier));
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Optional<PluginClassAndMetadata<? extends Plugin>> findMetadataByIdentifier(String identifier) {
        return this.findMetadataByIdentifier(ClassTypeIdentifier.create(identifier));
    }

    @Override
    public Optional<PluginClassAndMetadata<? extends Plugin>> findMetadataByIdentifier(PluginIdentifier identifier) {
        Objects.requireNonNull(identifier, "Cannot found plugin for null identifier");
        this.lock.lock();
        try {
            Optional<PluginClassAndMetadata<? extends Plugin>> optional = Optional.ofNullable(this.pluginClassByIdentifier.get(identifier));
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.pluginClassByIdentifier.clear();
    }

    @Override
    public boolean isVersioningSupported() {
        return false;
    }

    private static class LazyHolder {
        static final DefaultPluginRegistry INSTANCE = new DefaultPluginRegistry();

        private LazyHolder() {
        }
    }

    public record PluginBundleIdentifier(@Nullable URL location) {
        public static PluginBundleIdentifier CORE = new PluginBundleIdentifier(null);

        public static PluginBundleIdentifier of(RegisteredPlugin plugin) {
            return Optional.ofNullable(plugin.getExternalPlugin()).map(ExternalPlugin::getLocation).map(PluginBundleIdentifier::new).orElse(CORE);
        }
    }

    public record ClassTypeIdentifier(@NotNull String type) implements PluginIdentifier
    {
        public static ClassTypeIdentifier create(String identifier) {
            if (identifier == null || identifier.isBlank()) {
                throw new IllegalArgumentException("Cannot create plugin identifier from null or empty string");
            }
            return new ClassTypeIdentifier(identifier);
        }

        @Override
        public String toString() {
            return "Plugin@[type=" + this.type + "]";
        }
    }
}

