/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import java.beans.ConstructorProperties;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import lombok.Generated;

public class ExternalPlugin {
    private final URL location;
    private final URL[] resources;
    private volatile Long crc32;

    public ExternalPlugin(URL location, URL[] resources) {
        this.location = location;
        this.resources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getCrc32() {
        if (this.crc32 == null) {
            ExternalPlugin externalPlugin = this;
            synchronized (externalPlugin) {
                if (this.crc32 == null) {
                    this.crc32 = ExternalPlugin.computeJarCrc32(this.location);
                }
            }
        }
        return this.crc32;
    }

    private static long computeJarCrc32(URL location) {
        long l;
        CRC32 crc = new CRC32();
        JarFile jar = new JarFile(location.toURI().getPath(), false);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            byte[] buffer = new byte[8];
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                crc.update(entry.getName().getBytes(StandardCharsets.UTF_8));
                ExternalPlugin.updateCrc32WithLong(crc, buffer, entry.getSize());
                ExternalPlugin.updateCrc32WithLong(crc, buffer, entry.getCrc());
            }
            l = crc.getValue();
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return -1L;
            }
        }
        jar.close();
        return l;
    }

    private static void updateCrc32WithLong(CRC32 crc32, byte[] reusable, long val) {
        reusable[0] = (byte)(val >>> 56);
        reusable[1] = (byte)(val >>> 48);
        reusable[2] = (byte)(val >>> 40);
        reusable[3] = (byte)(val >>> 32);
        reusable[4] = (byte)(val >>> 24);
        reusable[5] = (byte)(val >>> 16);
        reusable[6] = (byte)(val >>> 8);
        reusable[7] = (byte)val;
        crc32.update(reusable);
    }

    @ConstructorProperties(value={"location", "resources", "crc32"})
    @Generated
    public ExternalPlugin(URL location, URL[] resources, Long crc32) {
        this.location = location;
        this.resources = resources;
        this.crc32 = crc32;
    }

    @Generated
    public URL getLocation() {
        return this.location;
    }

    @Generated
    public URL[] getResources() {
        return this.resources;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalPlugin)) {
            return false;
        }
        ExternalPlugin other = (ExternalPlugin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$crc32 = this.getCrc32();
        Long other$crc32 = other.getCrc32();
        if (this$crc32 == null ? other$crc32 != null : !((Object)this$crc32).equals(other$crc32)) {
            return false;
        }
        URL this$location = this.getLocation();
        URL other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        return Arrays.deepEquals(this.getResources(), other.getResources());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExternalPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $crc32 = this.getCrc32();
        result = result * 59 + ($crc32 == null ? 43 : ((Object)$crc32).hashCode());
        URL $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getResources());
        return result;
    }

    @Generated
    public String toString() {
        return "ExternalPlugin(location=" + String.valueOf(this.getLocation()) + ", resources=" + Arrays.deepToString(this.getResources()) + ", crc32=" + this.getCrc32() + ")";
    }
}

