/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.contexts.MavenPluginRepositoryConfig;
import io.kestra.core.exceptions.KestraRuntimeException;
import io.kestra.core.plugins.MavenPluginDownloader;
import io.kestra.core.plugins.PluginArtifact;
import io.kestra.core.plugins.PluginArtifactMetadata;
import io.kestra.core.plugins.PluginClassLoader;
import io.kestra.core.plugins.PluginManager;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.plugins.PluginResolutionResult;
import io.kestra.core.plugins.RegisteredPlugin;
import io.micronaut.context.annotation.Value;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalPluginManager
implements PluginManager {
    private static final Logger log = LoggerFactory.getLogger(LocalPluginManager.class);
    private final Provider<PluginRegistry> pluginRegistryProvider;
    private final MavenPluginDownloader mavenPluginDownloader;
    private final Path localRepositoryPath;

    public LocalPluginManager(MavenPluginDownloader mavenPluginDownloader) {
        this(null, mavenPluginDownloader, null);
    }

    @Inject
    public LocalPluginManager(Provider<PluginRegistry> pluginRegistryProvider, MavenPluginDownloader mavenPluginDownloader, @Nullable @Value(value="${kestra.plugins.management.localRepositoryPath}") String localRepositoryPath) {
        this.pluginRegistryProvider = pluginRegistryProvider;
        this.mavenPluginDownloader = mavenPluginDownloader;
        this.localRepositoryPath = PluginManager.getLocalManagedRepositoryPathOrDefault(localRepositoryPath);
    }

    @Override
    public void start() {
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public List<PluginArtifactMetadata> list() {
        List<PluginArtifactMetadata> list;
        block8: {
            Stream<Path> files = Files.list(this.localRepositoryPath);
            try {
                list = files.filter(file -> Files.isRegularFile(file, new LinkOption[0]) && Files.isReadable(file) && file.toString().endsWith(".jar")).map(file -> {
                    try {
                        BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                        return new PluginArtifactMetadata(file.toUri(), file.getFileName().toString(), attrs.size(), attrs.creationTime().toMillis(), attrs.lastModifiedTime().toMillis());
                    }
                    catch (IOException e) {
                        log.warn("Failed to get file attribute from file {}", (Object)file.getFileName());
                        return null;
                    }
                }).filter(Objects::nonNull).toList();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new KestraRuntimeException(e);
                }
            }
            files.close();
        }
        return list;
    }

    @Override
    public PluginArtifact install(PluginArtifact artifact, List<MavenPluginRepositoryConfig> repositoryConfigs, boolean installForRegistration, @Nullable Path localRepositoryPath) {
        Objects.requireNonNull(artifact, "cannot install null artifact");
        log.info("Installing managed plugin artifact '{}'", (Object)artifact);
        PluginArtifact resolvedPluginArtifact = this.mavenPluginDownloader.resolve(artifact.toString(), repositoryConfigs);
        return this.install(resolvedPluginArtifact, installForRegistration, localRepositoryPath);
    }

    private PluginArtifact install(PluginArtifact artifact, boolean installForRegistration, Path localRepositoryPath) {
        localRepositoryPath = PluginManager.createLocalRepositoryIfNotExist(Optional.ofNullable(localRepositoryPath).orElse(this.localRepositoryPath));
        Path localPluginPath = this.getLocalPluginPath(localRepositoryPath, artifact);
        try {
            Files.createDirectories(localPluginPath.getParent(), new FileAttribute[0]);
            Files.copy(Path.of(artifact.uri()), localPluginPath, StandardCopyOption.REPLACE_EXISTING);
            if (installForRegistration && this.pluginRegistryProvider != null) {
                ((PluginRegistry)this.pluginRegistryProvider.get()).register(localRepositoryPath);
            }
            log.info("Plugin '{}' installed successfully in local repository: {}", (Object)artifact, (Object)localRepositoryPath);
            return artifact.relocateTo(localPluginPath.toUri());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PluginArtifact install(File file, boolean installForRegistration, @Nullable Path localRepositoryPath, boolean forceInstallOnExistingVersions) {
        try {
            PluginArtifact artifact = PluginArtifact.fromFile(file);
            log.info("Installing managed plugin artifact '{}'", (Object)artifact);
            return this.install(artifact, installForRegistration, localRepositoryPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<PluginArtifact> install(List<PluginArtifact> artifacts, List<MavenPluginRepositoryConfig> repositoryConfigs, boolean refreshPluginRegistry, @Nullable Path localRepositoryPath) {
        return artifacts.stream().map(artifact -> this.install((PluginArtifact)artifact, repositoryConfigs, refreshPluginRegistry, localRepositoryPath)).toList();
    }

    private Path getLocalPluginPath(Path localRepositoryPath, PluginArtifact artifact) {
        return localRepositoryPath.resolve(artifact.toFileName());
    }

    @Override
    public List<PluginArtifact> uninstall(List<PluginArtifact> artifacts, boolean refreshPluginRegistry, @Nullable Path localRepositoryPath) {
        Path repositoryPath = Optional.ofNullable(localRepositoryPath).orElse(this.localRepositoryPath);
        List<PluginArtifact> uninstalled = artifacts.stream().map(artifact -> this.doUninstall((PluginArtifact)artifact, repositoryPath) ? artifact : null).filter(Objects::nonNull).toList();
        if (refreshPluginRegistry && this.pluginRegistryProvider != null) {
            ((PluginRegistry)this.pluginRegistryProvider.get()).register(localRepositoryPath);
        }
        return uninstalled;
    }

    @Override
    public List<PluginResolutionResult> resolveVersions(List<PluginArtifact> artifacts) {
        return this.mavenPluginDownloader.resolveVersions(artifacts);
    }

    private boolean doUninstall(PluginArtifact artifact, Path localRepositoryPath) {
        Path localPluginPath = this.getLocalPluginPath(localRepositoryPath, artifact);
        if (Files.exists(localPluginPath, new LinkOption[0])) {
            log.info("Removing plugin artifact from local repository: {}", (Object)localPluginPath);
            if (this.pluginRegistryProvider != null) {
                PluginRegistry registry = (PluginRegistry)this.pluginRegistryProvider.get();
                registry.unregister(new ArrayList<RegisteredPlugin>(registry.plugins(plugin -> {
                    ClassLoader patt0$temp = plugin.getClassLoader();
                    if (patt0$temp instanceof PluginClassLoader) {
                        PluginClassLoader pluginClassLoader = (PluginClassLoader)patt0$temp;
                        URI location = URI.create(pluginClassLoader.location());
                        return localPluginPath.equals(Path.of(location));
                    }
                    return false;
                })));
            }
            try {
                if (Files.deleteIfExists(localPluginPath)) {
                    log.info("Removed plugin artifact from local repository: {}", (Object)localPluginPath);
                }
                return true;
            }
            catch (IOException e) {
                log.error("Unexpected error while removing plugin artifact from plugin repository: {}", (Object)localPluginPath, (Object)e);
                return false;
            }
        }
        return false;
    }
}

