/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.models.Plugin;
import io.kestra.core.plugins.PluginConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Singleton
public final class PluginConfigurations {
    private final List<PluginConfiguration> configurations;

    @Inject
    public PluginConfigurations(List<PluginConfiguration> configurations) {
        Objects.requireNonNull(configurations, "configuration cannot be null");
        this.configurations = new ArrayList<PluginConfiguration>(configurations);
        this.configurations.sort(PluginConfiguration.COMPARATOR);
    }

    public Map<String, Object> getConfigurationByPluginType(String pluginType) {
        return this.configurations.stream().filter(config -> config.type().equalsIgnoreCase(pluginType)).map(PluginConfiguration::values).reduce(new HashMap(), (accumulator, map) -> {
            accumulator.putAll(map);
            return accumulator;
        });
    }

    public Map<String, Object> getConfigurationByPluginTypeOrAliases(String pluginType, Class<? extends Plugin> plugin) {
        Map<String, Object> configuration;
        block1: {
            String alias;
            configuration = this.getConfigurationByPluginType(pluginType);
            if (!configuration.isEmpty()) break block1;
            Set aliases = Plugin.getAliases(plugin);
            Iterator iterator = aliases.iterator();
            while (iterator.hasNext() && (configuration = this.getConfigurationByPluginType(alias = (String)iterator.next())).isEmpty()) {
            }
        }
        return configuration;
    }
}

