/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins.serdes;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.kestra.core.contexts.KestraContext;
import io.kestra.core.models.Plugin;
import io.kestra.core.models.dashboards.charts.DataChart;
import io.kestra.core.plugins.DefaultPluginRegistry;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.serializers.JacksonMapper;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginDeserializer<T extends Plugin>
extends JsonDeserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(PluginDeserializer.class);
    private static final String TYPE = "type";
    private static final String VERSION = "version";
    private volatile PluginRegistry pluginRegistry;

    public PluginDeserializer() {
    }

    PluginDeserializer(PluginRegistry pluginRegistry) {
        this.pluginRegistry = pluginRegistry;
    }

    public T deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        this.checkState();
        JsonNode node = (JsonNode)parser.readValueAsTree();
        if (node.isObject()) {
            return this.fromObjectNode(parser, node, context);
        }
        return null;
    }

    private void checkState() {
        if (this.pluginRegistry == null) {
            try {
                this.pluginRegistry = KestraContext.getContext().getPluginRegistry();
            }
            catch (IllegalStateException ignore) {
                log.error("No plugin registry was initialized. Use default implementation.");
                this.pluginRegistry = DefaultPluginRegistry.getOrCreate();
            }
        }
    }

    private T fromObjectNode(JsonParser jp, JsonNode node, DeserializationContext context) throws IOException {
        Class<? extends Plugin> pluginType = null;
        String identifier = PluginDeserializer.extractPluginRawIdentifier(node, this.pluginRegistry.isVersioningSupported());
        if (identifier != null) {
            log.trace("Looking for Plugin for: {}", (Object)identifier);
            pluginType = this.pluginRegistry.findClassByIdentifier(identifier);
        }
        if (pluginType == null) {
            String type = Optional.ofNullable(identifier).orElse("<null>");
            PluginDeserializer.throwInvalidTypeException(context, type);
        } else if (Plugin.class.isAssignableFrom(pluginType)) {
            log.trace("Read plugin for: {}", (Object)pluginType.getName());
            if (DataChart.class.isAssignableFrom(pluginType)) {
                Class<? extends Plugin> dataFilterClass = this.pluginRegistry.findClassByIdentifier(PluginDeserializer.extractPluginRawIdentifier(node.get("data"), this.pluginRegistry.isVersioningSupported()));
                ParameterizedType genericDataFilterClass = (ParameterizedType)dataFilterClass.getGenericSuperclass();
                Type dataFieldsEnum = genericDataFilterClass.getActualTypeArguments()[0];
                TypeFactory typeFactory = JacksonMapper.ofJson().getTypeFactory();
                Type chartAwareColumnDescriptorClass = ((ParameterizedType)((WildcardType)((ParameterizedType)((TypeVariable)((ParameterizedType)pluginType.getGenericSuperclass()).getActualTypeArguments()[1]).getBounds()[0]).getActualTypeArguments()[1]).getUpperBounds()[0]).getRawType();
                return (T)((Plugin)JacksonMapper.ofJson().convertValue((Object)node, typeFactory.constructParametricType(pluginType, new JavaType[]{typeFactory.constructType(dataFieldsEnum), typeFactory.constructParametricType(dataFilterClass, new JavaType[]{typeFactory.constructParametricType((Class)chartAwareColumnDescriptorClass, new Class[]{(Class)dataFieldsEnum})})})));
            }
            return (T)((Plugin)jp.getCodec().treeToValue((TreeNode)node, pluginType));
        }
        log.warn("Failed get plugin type from JsonNode");
        return null;
    }

    private static void throwInvalidTypeException(DeserializationContext context, String type) throws JsonMappingException {
        throw context.invalidTypeIdException(context.constructType(Plugin.class), type, "No plugin registered for the defined type: '" + type + "'");
    }

    static String extractPluginRawIdentifier(JsonNode node, boolean isVersioningSupported) {
        String type = Optional.ofNullable(node.get(TYPE)).map(JsonNode::textValue).orElse(null);
        String version = Optional.ofNullable(node.get(VERSION)).map(JsonNode::textValue).orElse(null);
        if (type == null || type.isEmpty()) {
            return null;
        }
        return isVersioningSupported && version != null && !version.isEmpty() ? type + ":" + version : type;
    }
}

