/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter.reports;

import io.kestra.core.models.collectors.ConfigurationUsage;
import io.kestra.core.models.collectors.HostUsage;
import io.kestra.core.reporter.AbstractReportable;
import io.kestra.core.reporter.Reportable;
import io.kestra.core.reporter.Schedules;
import io.kestra.core.reporter.Types;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Introspected;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.Set;
import lombok.Generated;

@Singleton
public class SystemInformationReport
extends AbstractReportable<SystemInformationEvent> {
    private final Environment environment;
    private final ApplicationContext applicationContext;
    private final String kestraUrl;
    private final Instant startTime;

    @Inject
    public SystemInformationReport(ApplicationContext applicationContext) {
        super(Types.SYSTEM_INFORMATION, Schedules.daily(), false);
        this.environment = applicationContext.getEnvironment();
        this.applicationContext = applicationContext;
        this.kestraUrl = applicationContext.getProperty("kestra.url", String.class).orElse(null);
        this.startTime = Instant.ofEpochMilli(ManagementFactory.getRuntimeMXBean().getStartTime());
    }

    @Override
    public SystemInformationEvent report(Instant now, Reportable.TimeInterval timeInterval) {
        return SystemInformationEvent.builder().environments(this.environment.getActiveNames()).configurations(ConfigurationUsage.of(this.applicationContext)).startTime(this.startTime).host(HostUsage.of()).uri(this.kestraUrl).build();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Introspected
    public record SystemInformationEvent(Set<String> environments, HostUsage host, ConfigurationUsage configurations, Instant startTime, String uri) implements Reportable.Event
    {
        @Generated
        public static SystemInformationEventBuilder builder() {
            return new SystemInformationEventBuilder();
        }

        @Generated
        public static class SystemInformationEventBuilder {
            @Generated
            private Set<String> environments;
            @Generated
            private HostUsage host;
            @Generated
            private ConfigurationUsage configurations;
            @Generated
            private Instant startTime;
            @Generated
            private String uri;

            @Generated
            SystemInformationEventBuilder() {
            }

            @Generated
            public SystemInformationEventBuilder environments(Set<String> environments) {
                this.environments = environments;
                return this;
            }

            @Generated
            public SystemInformationEventBuilder host(HostUsage host) {
                this.host = host;
                return this;
            }

            @Generated
            public SystemInformationEventBuilder configurations(ConfigurationUsage configurations) {
                this.configurations = configurations;
                return this;
            }

            @Generated
            public SystemInformationEventBuilder startTime(Instant startTime) {
                this.startTime = startTime;
                return this;
            }

            @Generated
            public SystemInformationEventBuilder uri(String uri) {
                this.uri = uri;
                return this;
            }

            @Generated
            public SystemInformationEvent build() {
                return new SystemInformationEvent(this.environments, this.host, this.configurations, this.startTime, this.uri);
            }

            @Generated
            public String toString() {
                return "SystemInformationReport.SystemInformationEvent.SystemInformationEventBuilder(environments=" + String.valueOf(this.environments) + ", host=" + String.valueOf(this.host) + ", configurations=" + String.valueOf(this.configurations) + ", startTime=" + String.valueOf(this.startTime) + ", uri=" + this.uri + ")";
            }
        }
    }
}

