/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.Dashboard;
import io.kestra.core.models.dashboards.DataFilter;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.models.dashboards.charts.DataChart;
import io.kestra.core.models.dashboards.charts.DataChartKPI;
import io.kestra.core.repositories.ArrayListTotal;
import io.micronaut.data.model.Pageable;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface DashboardRepositoryInterface {
    public long count();

    public Boolean isEnabled();

    public Optional<Dashboard> get(String var1, String var2);

    public ArrayListTotal<Dashboard> list(Pageable var1, String var2, String var3);

    public List<Dashboard> findAll(String var1);

    public List<Dashboard> findAllWithNoAcl(String var1);

    default public Dashboard save(Dashboard dashboard, String source) {
        return this.save(null, dashboard, source);
    }

    public Dashboard save(@Nullable Dashboard var1, Dashboard var2, String var3);

    public Dashboard delete(String var1, String var2);

    public <F extends Enum<F>> ArrayListTotal<Map<String, Object>> generate(String var1, DataChart<?, DataFilter<F, ? extends ColumnDescriptor<F>>> var2, ZonedDateTime var3, ZonedDateTime var4, Pageable var5) throws IOException;

    public <F extends Enum<F>> List<Map<String, Object>> generateKPI(String var1, DataChartKPI<?, DataFilterKPI<F, ? extends ColumnDescriptor<F>>> var2, ZonedDateTime var3, ZonedDateTime var4) throws IOException;
}

