/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.exceptions.FlowProcessingException;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.models.validations.ModelValidator;
import io.kestra.core.repositories.FlowRepositoryInterface;
import io.kestra.core.serializers.YamlParser;
import io.kestra.core.services.PluginDefaultService;
import io.kestra.core.utils.Rethrow;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolationException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalFlowRepositoryLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalFlowRepositoryLoader.class);
    @Inject
    private FlowRepositoryInterface flowRepository;
    @Inject
    private ModelValidator modelValidator;
    @Inject
    private PluginDefaultService pluginDefaultService;

    public void load(URL basePath) throws IOException, URISyntaxException {
        this.load("main", basePath);
    }

    public void load(String tenantId, URL basePath) throws IOException, URISyntaxException {
        URI uri = basePath.toURI();
        if (uri.getScheme().equals("jar")) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                String substring = uri.toString().substring(uri.toString().indexOf("!") + 1);
                Path tempDirectory = Files.createTempDirectory("loader", new FileAttribute[0]);
                for (Path path1 : fileSystem.getRootDirectories()) {
                    Stream<Path> files = Files.walk(path1, new FileVisitOption[0]);
                    try {
                        files.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.startsWith(substring)).forEach(Rethrow.throwConsumer(path -> FileUtils.copyURLToFile((URL)path.toUri().toURL(), (File)tempDirectory.resolve(path.toString().substring(1)).toFile())));
                    }
                    finally {
                        if (files == null) continue;
                        files.close();
                    }
                }
                this.load(tenantId, tempDirectory.toFile());
            }
        }
        this.load(tenantId, Paths.get(uri).toFile());
    }

    public void load(File basePath) throws IOException {
        this.load("main", basePath);
    }

    public void load(String tenantId, File basePath) throws IOException {
        Map flowByUidInRepository = this.flowRepository.findAllForAllTenants().stream().collect(Collectors.toMap(FlowId::uidWithoutRevision, Function.identity()));
        try (Stream<Path> pathStream = Files.walk(basePath.toPath(), new FileVisitOption[0]);){
            pathStream.filter(YamlParser::isValidExtension).forEach(Rethrow.throwConsumer(file -> {
                try {
                    String source = Files.readString(Path.of(file.toFile().getPath(), new String[0]), Charset.defaultCharset());
                    GenericFlow parsed = GenericFlow.fromYaml(tenantId, source);
                    FlowWithSource flowWithSource = this.pluginDefaultService.injectAllDefaults((FlowInterface)parsed, false);
                    this.modelValidator.validate(flowWithSource);
                    FlowInterface existing = (FlowInterface)flowByUidInRepository.get(flowWithSource.uidWithoutRevision());
                    if (existing == null) {
                        this.flowRepository.create(parsed);
                        log.trace("Created flow {}.{}", (Object)parsed.getNamespace(), (Object)parsed.getId());
                    } else {
                        this.flowRepository.update(parsed, existing);
                        log.trace("Updated flow {}.{}", (Object)parsed.getNamespace(), (Object)parsed.getId());
                    }
                }
                catch (FlowProcessingException | ConstraintViolationException e) {
                    log.warn("Unable to create flow {}", file, (Object)e);
                }
            }));
        }
    }
}

