/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.metrics.MetricRegistry;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.runners.LocalPath;
import io.kestra.core.runners.LocalPathFactory;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.runners.RunContextProperty;
import io.kestra.core.runners.Secret;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.runners.WorkingDir;
import io.kestra.core.runners.WorkingDirFactory;
import io.kestra.core.services.KVStoreService;
import io.kestra.core.storages.Storage;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.storages.kv.KVStore;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.MapUtils;
import io.kestra.core.utils.Rethrow;
import io.kestra.core.utils.VersionProvider;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Introspected;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.beans.ConstructorProperties;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;

@Introspected
public class DefaultRunContext
extends RunContext {
    private ApplicationContext applicationContext;
    private VariableRenderer variableRenderer;
    private MetricRegistry meterRegistry;
    private VersionProvider version;
    private KVStoreService kvStoreService;
    private Optional<String> secretKey;
    private WorkingDir workingDir;
    private Validator validator;
    private LocalPath localPath;
    private Map<String, Object> variables;
    private List<AbstractMetricEntry<?>> metrics = new ArrayList();
    private RunContextLogger logger;
    private final List<WorkerTaskResult> dynamicWorkerTaskResult = new ArrayList<WorkerTaskResult>();
    private String triggerExecutionId;
    private Storage storage;
    private Map<String, Object> pluginConfiguration;
    private List<String> secretInputs;
    private String traceParent;
    private Task task;
    private AbstractTrigger trigger;
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);

    @Override
    @JsonIgnore
    public String getTriggerExecutionId() {
        if (this.triggerExecutionId == null) {
            throw new IllegalStateException("triggerExecutionId is not defined");
        }
        return this.triggerExecutionId;
    }

    @Override
    @JsonInclude
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    @JsonInclude
    public List<String> getSecretInputs() {
        return this.secretInputs;
    }

    @Override
    @JsonInclude
    public String getTraceParent() {
        return this.traceParent;
    }

    @Override
    public void setTraceParent(String traceParent) {
        this.traceParent = traceParent;
    }

    @JsonIgnore
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @JsonIgnore
    Task getTask() {
        return this.task;
    }

    @JsonIgnore
    AbstractTrigger getTrigger() {
        return this.trigger;
    }

    void init(ApplicationContext applicationContext) {
        if (this.isInitialized.compareAndSet(false, true)) {
            this.applicationContext = applicationContext;
            if (this.workingDir == null) {
                this.workingDir = ((WorkingDirFactory)applicationContext.getBean(WorkingDirFactory.class)).createWorkingDirectory();
            }
            this.variableRenderer = (VariableRenderer)applicationContext.getBean(VariableRenderer.class);
            this.meterRegistry = (MetricRegistry)applicationContext.getBean(MetricRegistry.class);
            this.version = (VersionProvider)applicationContext.getBean(VersionProvider.class);
            this.kvStoreService = (KVStoreService)applicationContext.getBean(KVStoreService.class);
            this.secretKey = applicationContext.getProperty("kestra.encryption.secret-key", String.class);
            this.validator = (Validator)applicationContext.getBean(Validator.class);
            this.localPath = ((LocalPathFactory)applicationContext.getBean(LocalPathFactory.class)).createLocalPath(this);
        }
    }

    void setVariables(Map<String, Object> variables) {
        this.variables = Collections.unmodifiableMap(variables);
    }

    void setStorage(Storage storage) {
        this.storage = storage;
    }

    void setLogger(RunContextLogger logger) {
        this.logger = logger;
        if (!ListUtils.isEmpty(this.secretInputs) && this.getVariables().containsKey("inputs")) {
            Map inputs = (Map)this.getVariables().get("inputs");
            for (String secretInput : this.secretInputs) {
                String secret = this.findSecret(secretInput, inputs);
                if (secret == null) continue;
                logger.usedSecret(secret);
            }
        }
    }

    private String findSecret(String secretInput, Map<String, Object> inputs) {
        if (secretInput.indexOf(46) > 0) {
            String prefix = secretInput.substring(0, secretInput.indexOf(46));
            String suffix = secretInput.substring(secretInput.indexOf(46) + 1);
            Map subInputs = (Map)inputs.get(prefix);
            return this.findSecret(suffix, subInputs);
        }
        return (String)inputs.get(secretInput);
    }

    void setPluginConfiguration(Map<String, Object> pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    void setTriggerExecutionId(String triggerExecutionId) {
        this.triggerExecutionId = triggerExecutionId;
    }

    void setTask(Task task) {
        this.task = task;
    }

    void setTrigger(AbstractTrigger trigger) {
        this.trigger = trigger;
    }

    public DefaultRunContext clone() {
        DefaultRunContext runContext = new DefaultRunContext();
        runContext.variables = new HashMap<String, Object>(this.variables);
        runContext.workingDir = this.workingDir;
        runContext.logger = this.logger;
        runContext.metrics = new ArrayList();
        runContext.storage = this.storage;
        runContext.pluginConfiguration = this.pluginConfiguration;
        runContext.secretInputs = this.secretInputs;
        if (this.isInitialized()) {
            runContext.init(this.applicationContext);
        }
        return runContext;
    }

    @Override
    public String render(String inline) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, this.variables);
    }

    @Override
    public Object renderTyped(String inline) throws IllegalVariableEvaluationException {
        return this.variableRenderer.renderTyped(inline, this.variables);
    }

    @Override
    public <T> RunContextProperty<T> render(Property<T> inline) {
        return new RunContextProperty<T>(inline, this);
    }

    @Override
    public String render(String inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, MapUtils.mergeWithNullableValues(this.variables, this.decryptVariables(variables)));
    }

    @Override
    public List<String> render(List<String> inline) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, this.variables);
    }

    @Override
    public List<String> render(List<String> inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, MapUtils.mergeWithNullableValues(this.variables, this.decryptVariables(variables)));
    }

    @Override
    public Set<String> render(Set<String> inline) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, this.variables);
    }

    @Override
    public Set<String> render(Set<String> inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, MapUtils.mergeWithNullableValues(this.variables, this.decryptVariables(variables)));
    }

    @Override
    public Map<String, Object> render(Map<String, Object> inline) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, this.variables);
    }

    @Override
    public Map<String, Object> render(Map<String, Object> inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.variableRenderer.render(inline, MapUtils.mergeWithNullableValues(this.variables, this.decryptVariables(variables)));
    }

    @Override
    public Map<String, String> renderMap(Map<String, String> inline) throws IllegalVariableEvaluationException {
        return this.renderMap(inline, Collections.emptyMap());
    }

    @Override
    public Map<String, String> renderMap(Map<String, String> inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        if (inline == null) {
            return null;
        }
        Map<String, Object> allVariables = MapUtils.mergeWithNullableValues(this.variables, this.decryptVariables(variables));
        return inline.entrySet().stream().map(Rethrow.throwFunction(entry -> new AbstractMap.SimpleEntry<String, String>(this.render((String)entry.getKey(), allVariables), this.render((String)entry.getValue(), allVariables)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public <T> void validate(T bean) {
        Validator theValidator = this.validator != null ? this.validator : (Validator)this.applicationContext.getBean(Validator.class);
        Set violations = theValidator.validate(bean, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public String decrypt(String encrypted) throws GeneralSecurityException {
        return new Secret(this.secretKey, this::logger).decrypt(encrypted);
    }

    @Override
    public String encrypt(String plaintext) throws GeneralSecurityException {
        return new Secret(this.secretKey, this::logger).encrypt(plaintext);
    }

    @Override
    public Logger logger() {
        return this.logger.get();
    }

    @Override
    public URI logFileURI() {
        if (this.logger.getLogFile() != null) {
            try {
                this.logger.closeLogFile();
                String logName = "log-" + RandomStringUtils.secure().nextAlphanumeric(5).toLowerCase() + ".txt";
                Path logFile = this.workingDir.createFile(logName);
                try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(logFile, new OpenOption[0]));){
                    Files.copy(this.logger.getLogFile().toPath(), out);
                }
                URI logFileURI = this.storage.putFile(logFile.toFile());
                if (!this.logger.getLogFile().delete()) {
                    this.logger().warn("Unable to delete the log file {}", (Object)this.logger.getLogFile().toPath());
                }
                return logFileURI;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    @JsonIgnore
    public URI getStorageOutputPrefix() {
        return this.storage.getContextBaseURI();
    }

    @Override
    public Storage storage() {
        return this.storage;
    }

    @Override
    public List<AbstractMetricEntry<?>> metrics() {
        return this.metrics;
    }

    @Override
    public <T> RunContext metric(AbstractMetricEntry<T> metricEntry) {
        block4: {
            int index = this.metrics.indexOf(metricEntry);
            if (index >= 0) {
                AbstractMetricEntry<?> current = this.metrics.get(index);
                current.increment(metricEntry.getValue());
            } else {
                this.metrics.add(metricEntry);
            }
            try {
                metricEntry.register(this.meterRegistry, this.metricPrefix(), metricEntry.getDescription(), this.metricsTags());
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("Collector already registered")) break block4;
                throw e;
            }
        }
        return this;
    }

    private Map<String, Object> decryptVariables(Map<String, Object> variables) {
        if (this.secretKey.isPresent()) {
            Secret secret = new Secret(this.secretKey, this.logger);
            return secret.decrypt(variables);
        }
        return variables;
    }

    private Map<String, String> metricsTags() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.variables.containsKey("flow")) {
            Map flowVars = (Map)this.variables.get("flow");
            builder.put((Object)"flow_id", (Object)((String)flowVars.get("id"))).put((Object)"namespace_id", (Object)((String)flowVars.get("namespace")));
            if (flowVars.containsKey("tenantId")) {
                builder.put((Object)"tenant_id", (Object)((String)flowVars.get("tenantId")));
            }
        }
        return builder.build();
    }

    private String metricPrefix() {
        if (!this.variables.containsKey("task")) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(((String)((Map)this.variables.get("task")).get("type")).split("\\.")));
        String clsName = (String)values.removeLast();
        values.add(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, clsName));
        return String.join((CharSequence)".", values);
    }

    @Override
    public void dynamicWorkerResult(List<WorkerTaskResult> workerTaskResults) {
        this.dynamicWorkerTaskResult.addAll(workerTaskResults);
    }

    @Override
    public List<WorkerTaskResult> dynamicWorkerResults() {
        return this.dynamicWorkerTaskResult;
    }

    @Override
    public WorkingDir workingDir() {
        return this.workingDir;
    }

    @Override
    public void cleanup() {
        try {
            this.workingDir.cleanup();
        }
        catch (IOException ex) {
            this.logger().warn("Unable to cleanup worker task", (Throwable)ex);
        }
        if (this.logger != null) {
            this.logger.resetMDC();
        }
    }

    @Override
    public String tenantId() {
        Map flow = (Map)this.getVariables().get("flow");
        return flow != null ? (String)flow.get("tenantId") : null;
    }

    @Override
    public RunContext.FlowInfo flowInfo() {
        Map flow = (Map)this.getVariables().get("flow");
        return flow == null ? new RunContext.FlowInfo(null, null, null, null) : new RunContext.FlowInfo((String)flow.get("tenantId"), (String)flow.get("namespace"), (String)flow.get("id"), (Integer)flow.get("revision"));
    }

    @Override
    public <T> Optional<T> pluginConfiguration(String name) {
        Objects.requireNonNull(name, "Cannot get plugin configuration from null name");
        return Optional.ofNullable(this.pluginConfiguration.get(name));
    }

    @Override
    public Map<String, Object> pluginConfigurations() {
        return this.pluginConfiguration;
    }

    @Override
    public String version() {
        return this.isInitialized() ? this.version.getVersion() : null;
    }

    @Override
    public KVStore namespaceKv(String namespace) {
        return this.kvStoreService.get(this.flowInfo().tenantId(), namespace, this.flowInfo().namespace());
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized.get();
    }

    @Override
    public LocalPath localPath() {
        return this.localPath;
    }

    public static class Builder {
        private ApplicationContext applicationContext;
        private VariableRenderer variableRenderer;
        private StorageInterface storageInterface;
        private MetricRegistry meterRegistry;
        private Map<String, Object> variables;
        private List<WorkerTaskResult> dynamicWorkerResults;
        private Map<String, Object> pluginConfiguration;
        private Optional<String> secretKey = Optional.empty();
        private WorkingDir workingDir;
        private Storage storage;
        private String triggerExecutionId;
        private RunContextLogger logger;
        private KVStoreService kvStoreService;
        private List<String> secretInputs;
        private Task task;
        private AbstractTrigger trigger;

        public DefaultRunContext build() {
            DefaultRunContext context = new DefaultRunContext();
            context.applicationContext = this.applicationContext;
            context.variableRenderer = this.variableRenderer;
            context.meterRegistry = this.meterRegistry;
            context.variables = (Map)Optional.ofNullable(this.variables).map(ImmutableMap::copyOf).orElse(ImmutableMap.of());
            context.pluginConfiguration = (Map)Optional.ofNullable(this.pluginConfiguration).map(ImmutableMap::copyOf).orElse(ImmutableMap.of());
            context.logger = this.logger;
            context.secretKey = this.secretKey;
            context.workingDir = this.workingDir;
            context.storage = this.storage;
            context.triggerExecutionId = this.triggerExecutionId;
            context.kvStoreService = this.kvStoreService;
            context.secretInputs = this.secretInputs;
            context.task = this.task;
            context.trigger = this.trigger;
            return context;
        }

        @Generated
        public Builder() {
        }

        @ConstructorProperties(value={"applicationContext", "variableRenderer", "storageInterface", "meterRegistry", "variables", "dynamicWorkerResults", "pluginConfiguration", "secretKey", "workingDir", "storage", "triggerExecutionId", "logger", "kvStoreService", "secretInputs", "task", "trigger"})
        @Generated
        public Builder(ApplicationContext applicationContext, VariableRenderer variableRenderer, StorageInterface storageInterface, MetricRegistry meterRegistry, Map<String, Object> variables, List<WorkerTaskResult> dynamicWorkerResults, Map<String, Object> pluginConfiguration, Optional<String> secretKey, WorkingDir workingDir, Storage storage, String triggerExecutionId, RunContextLogger logger, KVStoreService kvStoreService, List<String> secretInputs, Task task, AbstractTrigger trigger) {
            this.applicationContext = applicationContext;
            this.variableRenderer = variableRenderer;
            this.storageInterface = storageInterface;
            this.meterRegistry = meterRegistry;
            this.variables = variables;
            this.dynamicWorkerResults = dynamicWorkerResults;
            this.pluginConfiguration = pluginConfiguration;
            this.secretKey = secretKey;
            this.workingDir = workingDir;
            this.storage = storage;
            this.triggerExecutionId = triggerExecutionId;
            this.logger = logger;
            this.kvStoreService = kvStoreService;
            this.secretInputs = secretInputs;
            this.task = task;
            this.trigger = trigger;
        }

        @Generated
        public Builder withApplicationContext(ApplicationContext applicationContext) {
            return this.applicationContext == applicationContext ? this : new Builder(applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withVariableRenderer(VariableRenderer variableRenderer) {
            return this.variableRenderer == variableRenderer ? this : new Builder(this.applicationContext, variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withStorageInterface(StorageInterface storageInterface) {
            return this.storageInterface == storageInterface ? this : new Builder(this.applicationContext, this.variableRenderer, storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withMeterRegistry(MetricRegistry meterRegistry) {
            return this.meterRegistry == meterRegistry ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withVariables(Map<String, Object> variables) {
            return this.variables == variables ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withDynamicWorkerResults(List<WorkerTaskResult> dynamicWorkerResults) {
            return this.dynamicWorkerResults == dynamicWorkerResults ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withPluginConfiguration(Map<String, Object> pluginConfiguration) {
            return this.pluginConfiguration == pluginConfiguration ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withSecretKey(Optional<String> secretKey) {
            return this.secretKey == secretKey ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withWorkingDir(WorkingDir workingDir) {
            return this.workingDir == workingDir ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withStorage(Storage storage) {
            return this.storage == storage ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withTriggerExecutionId(String triggerExecutionId) {
            return this.triggerExecutionId == triggerExecutionId ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withLogger(RunContextLogger logger) {
            return this.logger == logger ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, logger, this.kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withKvStoreService(KVStoreService kvStoreService) {
            return this.kvStoreService == kvStoreService ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, kvStoreService, this.secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withSecretInputs(List<String> secretInputs) {
            return this.secretInputs == secretInputs ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, secretInputs, this.task, this.trigger);
        }

        @Generated
        public Builder withTask(Task task) {
            return this.task == task ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, task, this.trigger);
        }

        @Generated
        public Builder withTrigger(AbstractTrigger trigger) {
            return this.trigger == trigger ? this : new Builder(this.applicationContext, this.variableRenderer, this.storageInterface, this.meterRegistry, this.variables, this.dynamicWorkerResults, this.pluginConfiguration, this.secretKey, this.workingDir, this.storage, this.triggerExecutionId, this.logger, this.kvStoreService, this.secretInputs, this.task, trigger);
        }
    }
}

