/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.HasUID;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.runners.ExecutionRunning;
import io.kestra.core.utils.IdUtils;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.time.Instant;
import lombok.Generated;

public final class ExecutionQueued
implements HasUID {
    private final String tenantId;
    @NotNull
    private final String namespace;
    @NotNull
    private final String flowId;
    @NotNull
    private final Execution execution;
    @NotNull
    private final Instant date;

    public static ExecutionQueued fromExecutionRunning(ExecutionRunning executionRunning) {
        return new ExecutionQueued(executionRunning.getTenantId(), executionRunning.getNamespace(), executionRunning.getFlowId(), executionRunning.getExecution(), Instant.now());
    }

    @Override
    public String uid() {
        return IdUtils.fromParts(this.tenantId, this.namespace, this.flowId, this.execution.getId());
    }

    @Generated
    public static ExecutionQueuedBuilder builder() {
        return new ExecutionQueuedBuilder();
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getFlowId() {
        return this.flowId;
    }

    @Generated
    public Execution getExecution() {
        return this.execution;
    }

    @Generated
    public Instant getDate() {
        return this.date;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionQueued)) {
            return false;
        }
        ExecutionQueued other = (ExecutionQueued)o;
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$flowId = this.getFlowId();
        String other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !this$flowId.equals(other$flowId)) {
            return false;
        }
        Execution this$execution = this.getExecution();
        Execution other$execution = other.getExecution();
        if (this$execution == null ? other$execution != null : !((Object)this$execution).equals(other$execution)) {
            return false;
        }
        Instant this$date = this.getDate();
        Instant other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : $flowId.hashCode());
        Execution $execution = this.getExecution();
        result = result * 59 + ($execution == null ? 43 : ((Object)$execution).hashCode());
        Instant $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExecutionQueued(tenantId=" + this.getTenantId() + ", namespace=" + this.getNamespace() + ", flowId=" + this.getFlowId() + ", execution=" + String.valueOf(this.getExecution()) + ", date=" + String.valueOf(this.getDate()) + ")";
    }

    @ConstructorProperties(value={"tenantId", "namespace", "flowId", "execution", "date"})
    @Generated
    public ExecutionQueued(String tenantId, String namespace, String flowId, Execution execution, Instant date) {
        this.tenantId = tenantId;
        this.namespace = namespace;
        this.flowId = flowId;
        this.execution = execution;
        this.date = date;
    }

    @Generated
    public static class ExecutionQueuedBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String namespace;
        @Generated
        private String flowId;
        @Generated
        private Execution execution;
        @Generated
        private Instant date;

        @Generated
        ExecutionQueuedBuilder() {
        }

        @Generated
        public ExecutionQueuedBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public ExecutionQueuedBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public ExecutionQueuedBuilder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        @Generated
        public ExecutionQueuedBuilder execution(Execution execution) {
            this.execution = execution;
            return this;
        }

        @Generated
        public ExecutionQueuedBuilder date(Instant date) {
            this.date = date;
            return this;
        }

        @Generated
        public ExecutionQueued build() {
            return new ExecutionQueued(this.tenantId, this.namespace, this.flowId, this.execution, this.date);
        }

        @Generated
        public String toString() {
            return "ExecutionQueued.ExecutionQueuedBuilder(tenantId=" + this.tenantId + ", namespace=" + this.namespace + ", flowId=" + this.flowId + ", execution=" + String.valueOf(this.execution) + ", date=" + String.valueOf(this.date) + ")";
        }
    }
}

