/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.google.common.collect.Lists;
import io.kestra.core.models.Plugin;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.plugins.PluginConfigurations;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.runners.RunContextLoggerFactory;
import io.kestra.core.runners.RunVariables;
import io.kestra.core.runners.Secret;
import io.kestra.core.runners.WorkerTask;
import io.kestra.core.runners.WorkerTaskResult;
import io.kestra.core.runners.WorkerTrigger;
import io.kestra.core.services.FlowService;
import io.kestra.core.storages.InternalStorage;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.IdUtils;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Value;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

@Singleton
public class RunContextInitializer {
    @Inject
    protected ApplicationContext applicationContext;
    @Inject
    protected PluginConfigurations pluginConfigurations;
    @Inject
    protected RunContextLoggerFactory contextLoggerFactory;
    @Inject
    protected StorageInterface storageInterface;
    @Inject
    protected FlowService flowService;
    @Value(value="${kestra.encryption.secret-key}")
    protected Optional<String> secretKey;

    public DefaultRunContext forPlugin(DefaultRunContext runContext, Plugin plugin) {
        runContext.init(this.applicationContext);
        runContext.setPluginConfiguration(this.pluginConfigurations.getConfigurationByPluginTypeOrAliases(plugin.getType(), plugin.getClass()));
        return runContext;
    }

    public DefaultRunContext forExecutor(DefaultRunContext runContext) {
        runContext.init(this.applicationContext);
        return runContext;
    }

    public DefaultRunContext forWorker(DefaultRunContext runContext, WorkerTask workerTask) {
        return this.forWorker(runContext, workerTask, Function.identity());
    }

    public DefaultRunContext forWorkingDirectory(DefaultRunContext runContext, WorkerTask workerTask) {
        return this.forWorker(runContext, workerTask, (Map<String, Object> variables) -> {
            variables.put("workerTaskrun", variables.get("taskrun"));
            return variables;
        });
    }

    private DefaultRunContext forWorker(DefaultRunContext runContext, WorkerTask workerTask, Function<Map<String, Object>, Map<String, Object>> variablesModifier) {
        runContext.init(this.applicationContext);
        Task task = workerTask.getTask();
        TaskRun taskRun = workerTask.getTaskRun();
        Map<String, Object> enrichedVariables = new HashMap<String, Object>(runContext.getVariables());
        enrichedVariables.put("taskrun", RunVariables.of(taskRun));
        enrichedVariables.put("task", RunVariables.of(task));
        Map workerTaskRun = (Map)enrichedVariables.get("workerTaskrun");
        if (workerTaskRun != null && workerTaskRun.containsKey("value")) {
            HashMap taskrun = new HashMap((Map)enrichedVariables.get("taskrun"));
            taskrun.put("value", workerTaskRun.get("value"));
            enrichedVariables.put("taskrun", taskrun);
        }
        enrichedVariables.put("outputs", this.rehydrateOutputs((Map)enrichedVariables.get("outputs")));
        RunContextLogger runContextLogger = this.contextLoggerFactory.create(workerTask);
        enrichedVariables.put("addSecretConsumer", runContextLogger::usedSecret);
        enrichedVariables = variablesModifier.apply(enrichedVariables);
        runContext.setVariables(enrichedVariables);
        runContext.setPluginConfiguration(this.pluginConfigurations.getConfigurationByPluginTypeOrAliases(task.getType(), task.getClass()));
        runContext.setStorage(new InternalStorage(runContextLogger.logger(), StorageContext.forTask(taskRun), this.storageInterface, this.flowService));
        runContext.setLogger(runContextLogger);
        runContext.setTask(task);
        return runContext;
    }

    protected Map<String, Object> rehydrateOutputs(Map<String, Object> outputs) {
        return outputs;
    }

    public DefaultRunContext forWorker(DefaultRunContext runContext, WorkerTaskResult workerTaskResult, TaskRun parent) {
        HashMap<String, Object> result;
        HashMap<String, Object> variables = new HashMap<String, Object>(runContext.getVariables());
        HashMap<String, Object> outputs = variables.containsKey("outputs") ? new HashMap<String, Object>((Map)variables.get("outputs")) : new HashMap();
        HashMap<String, Object> current = result = new HashMap<String, Object>();
        if (variables.containsKey("parents")) {
            for (Map t : Lists.reverse((List)((List)variables.get("parents")))) {
                if (t.get("taskrun") == null || ((Map)t.get("taskrun")).get("value") == null) continue;
                HashMap item = new HashMap();
                current.put((String)((Map)t.get("taskrun")).get("value"), item);
                current = item;
            }
        }
        if (parent.getValue() != null) {
            HashMap item = new HashMap();
            current.put(parent.getValue(), item);
            current = item;
        }
        if (workerTaskResult.getTaskRun().getOutputs() != null) {
            current.putAll(workerTaskResult.getTaskRun().getOutputs());
        }
        outputs.put(workerTaskResult.getTaskRun().getTaskId(), result);
        variables.put("outputs", new Secret(this.secretKey, runContext::logger).decrypt(outputs));
        runContext.setVariables(variables);
        return runContext;
    }

    public DefaultRunContext forScheduler(DefaultRunContext runContext, TriggerContext triggerContext, AbstractTrigger trigger) {
        runContext.init(this.applicationContext);
        String triggerExecutionId = IdUtils.create();
        RunContextLogger runContextLogger = this.contextLoggerFactory.create(triggerContext, trigger, null);
        HashMap<String, Object> variables = new HashMap<String, Object>(runContext.getVariables());
        variables.put("addSecretConsumer", runContextLogger::usedSecret);
        StorageContext.Trigger context = StorageContext.forTrigger(triggerContext.getTenantId(), triggerContext.getNamespace(), triggerContext.getFlowId(), triggerExecutionId, trigger.getId());
        InternalStorage storage = new InternalStorage(runContextLogger.logger(), context, this.storageInterface, this.flowService);
        runContext.setLogger(runContextLogger);
        runContext.setVariables(variables);
        runContext.setStorage(storage);
        runContext.setPluginConfiguration(this.pluginConfigurations.getConfigurationByPluginTypeOrAliases(trigger.getType(), trigger.getClass()));
        runContext.setTriggerExecutionId(triggerExecutionId);
        runContext.setTrigger(trigger);
        return runContext;
    }

    public RunContext forWorker(DefaultRunContext runContext, WorkerTrigger workerTrigger) {
        return this.forScheduler(runContext, workerTrigger.getTriggerContext(), workerTrigger.getTrigger());
    }
}

