/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionKind;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.queues.QueueInterface;
import io.kestra.core.runners.RunContextLogger;
import io.kestra.core.runners.WorkerTask;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;

@Singleton
public class RunContextLoggerFactory {
    @Inject
    @Named(value="workerTaskLogQueue")
    private QueueInterface<LogEntry> logQueue;

    public RunContextLogger create(WorkerTask workerTask) {
        return this.create(workerTask.getTaskRun(), workerTask.getTask(), workerTask.getExecutionKind());
    }

    public RunContextLogger create(TaskRun taskRun, Task task, ExecutionKind executionKind) {
        return new RunContextLogger(this.logQueue, LogEntry.of(taskRun, executionKind), task.getLogLevel(), task.isLogToFile());
    }

    public RunContextLogger create(Execution execution) {
        return new RunContextLogger(this.logQueue, LogEntry.of(execution), null, false);
    }

    public RunContextLogger create(TriggerContext triggerContext, AbstractTrigger trigger, ExecutionKind executionKind) {
        return new RunContextLogger(this.logQueue, LogEntry.of(triggerContext, trigger, executionKind), trigger.getLogLevel(), trigger.isLogToFile());
    }

    public RunContextLogger create(Flow flow, AbstractTrigger trigger, ExecutionKind executionKind) {
        return new RunContextLogger(this.logQueue, LogEntry.of(flow, trigger, executionKind), trigger.getLogLevel(), trigger.isLogToFile());
    }
}

