/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.pebble.JsonWriter;
import io.kestra.core.runners.pebble.OutputWriter;
import io.kestra.core.runners.pebble.PebbleEngineFactory;
import io.kestra.core.runners.pebble.TypedObjectWriter;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Nullable;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.error.AttributeNotFoundException;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

@Singleton
public class VariableRenderer {
    private static final Pattern RAW_PATTERN = Pattern.compile("(\\{%-*\\s*raw\\s*-*%}(.*?)\\{%-*\\s*endraw\\s*-*%})");
    public static final int MAX_RENDERING_AMOUNT = 100;
    private PebbleEngine pebbleEngine;
    private final VariableConfiguration variableConfiguration;

    @Inject
    public VariableRenderer(ApplicationContext applicationContext, @Nullable VariableConfiguration variableConfiguration) {
        this((PebbleEngineFactory)applicationContext.getBean(PebbleEngineFactory.class), variableConfiguration);
    }

    public VariableRenderer(PebbleEngineFactory pebbleEngineFactory, @Nullable VariableConfiguration variableConfiguration) {
        this.variableConfiguration = variableConfiguration != null ? variableConfiguration : new VariableConfiguration();
        this.pebbleEngine = pebbleEngineFactory.create();
    }

    public void setPebbleEngine(PebbleEngine pebbleEngine) {
        this.pebbleEngine = pebbleEngine;
    }

    public static IllegalVariableEvaluationException properPebbleException(PebbleException initialExtension) {
        if (initialExtension instanceof AttributeNotFoundException) {
            AttributeNotFoundException current = (AttributeNotFoundException)initialExtension;
            return new IllegalVariableEvaluationException("Unable to find `" + current.getAttributeName() + "` used in the expression `" + current.getFileName() + "` at line " + current.getLineNumber());
        }
        return new IllegalVariableEvaluationException(initialExtension);
    }

    public String render(String inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.render(inline, variables, (boolean)this.variableConfiguration.getRecursiveRendering());
    }

    public Object renderTyped(String inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.render(inline, variables, this.variableConfiguration.getRecursiveRendering(), false);
    }

    public String render(String inline, Map<String, Object> variables, boolean recursive) throws IllegalVariableEvaluationException {
        return (String)this.render(inline, variables, recursive, true);
    }

    public Object render(Object inline, Map<String, Object> variables, boolean recursive, boolean stringify) throws IllegalVariableEvaluationException {
        Object render;
        String inlineStr;
        if (inline == null) {
            return null;
        }
        if (inline instanceof String && (inlineStr = (String)inline).indexOf(123) == -1) {
            return inline;
        }
        Object object = render = recursive ? this.renderRecursively(inline, variables, stringify) : this.renderOnce(inline, variables, stringify);
        if (render instanceof String) {
            String renderStr = (String)render;
            return RAW_PATTERN.matcher(renderStr).replaceAll("$2");
        }
        return render;
    }

    public Object renderOnce(Object inline, Map<String, Object> variables, boolean stringify) throws IllegalVariableEvaluationException {
        Object result = inline;
        HashMap<String, String> replacers = null;
        if (inline instanceof String) {
            String inlineStr = (String)inline;
            Matcher rawMatcher = RAW_PATTERN.matcher(inlineStr);
            replacers = new HashMap<String, String>((int)Math.ceil((double)rawMatcher.groupCount() / 0.75));
            result = VariableRenderer.replaceRawTags(rawMatcher, replacers);
        }
        try {
            PebbleTemplate compiledTemplate = this.pebbleEngine.getLiteralTemplate((String)result);
            OutputWriter writer = stringify ? new JsonWriter() : new TypedObjectWriter();
            compiledTemplate.evaluate((Writer)writer, variables);
            result = writer.output();
        }
        catch (PebbleException | IOException e) {
            String alternativeRender = this.alternativeRender((Exception)e, (String)inline, variables);
            if (alternativeRender == null) {
                if (e instanceof PebbleException) {
                    PebbleException pebbleException = (PebbleException)e;
                    throw VariableRenderer.properPebbleException(pebbleException);
                }
                throw new IllegalVariableEvaluationException(e);
            }
            result = alternativeRender;
        }
        if (result instanceof String) {
            String stringValue = (String)result;
            if (replacers != null) {
                result = VariableRenderer.putBackRawTags(replacers, stringValue);
            }
        }
        return result;
    }

    protected String alternativeRender(Exception e, String inline, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return null;
    }

    private static String putBackRawTags(Map<String, String> replacers, String result) {
        for (Map.Entry<String, String> entry : replacers.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static String replaceRawTags(Matcher rawMatcher, Map<String, String> replacers) {
        return rawMatcher.replaceAll(matchResult -> {
            String uuid = UUID.randomUUID().toString();
            replacers.put(uuid, matchResult.group(1));
            return uuid;
        });
    }

    public Object renderRecursively(Object inline, Map<String, Object> variables, boolean stringify) throws IllegalVariableEvaluationException {
        return this.renderRecursively(0, inline, variables, stringify);
    }

    private Object renderRecursively(int renderingCount, Object inline, Map<String, Object> variables, boolean stringify) throws IllegalVariableEvaluationException {
        if (renderingCount > 100) {
            throw new IllegalVariableEvaluationException("Too many rendering attempts");
        }
        Object result = this.renderOnce(inline, variables, stringify);
        if (result.equals(inline)) {
            return result;
        }
        return this.renderRecursively(++renderingCount, result, variables, stringify);
    }

    public Map<String, Object> render(Map<String, Object> in, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.render(in, variables, (boolean)this.variableConfiguration.getRecursiveRendering());
    }

    public Map<String, Object> render(Map<String, Object> in, Map<String, Object> variables, boolean recursive) throws IllegalVariableEvaluationException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> r : in.entrySet()) {
            String key = this.render(r.getKey(), variables);
            Object value = this.renderObject(r.getValue(), variables, recursive).orElse(r.getValue());
            map.putIfAbsent(key, value);
        }
        return map;
    }

    public Optional<Object> renderObject(Object object, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.renderObject(object, variables, this.variableConfiguration.getRecursiveRendering());
    }

    public Optional<Object> renderObject(Object object, Map<String, Object> variables, boolean recursive) throws IllegalVariableEvaluationException {
        if (object instanceof Map) {
            Map map = (Map)object;
            return Optional.of(this.render(map, variables, recursive));
        }
        if (object instanceof List) {
            List list = (List)object;
            return Optional.of(this.renderList(list, variables, recursive));
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            return Optional.of(this.render(set, variables, recursive));
        }
        if (object instanceof String) {
            String string = (String)object;
            return Optional.of(this.render(string, variables, recursive));
        }
        return Optional.ofNullable(object);
    }

    public List<Object> renderList(List<Object> list, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.renderList(list, variables, this.variableConfiguration.getRecursiveRendering());
    }

    public List<Object> renderList(List<Object> list, Map<String, Object> variables, boolean recursive) throws IllegalVariableEvaluationException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object inline : list) {
            result.add(this.renderObject(inline, variables, recursive).orElse(inline));
        }
        return result;
    }

    public List<String> render(List<String> list, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.render(list, variables, (boolean)this.variableConfiguration.getRecursiveRendering());
    }

    public List<String> render(List<String> list, Map<String, Object> variables, boolean recursive) throws IllegalVariableEvaluationException {
        ArrayList<String> result = new ArrayList<String>();
        for (String inline : list) {
            result.add(this.render(inline, variables, recursive));
        }
        return result;
    }

    public Set<String> render(Set<String> set, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        return this.render(set, variables, (boolean)this.variableConfiguration.getRecursiveRendering());
    }

    public Set<String> render(Set<String> list, Map<String, Object> variables, boolean recursive) throws IllegalVariableEvaluationException {
        HashSet<String> result = new HashSet<String>();
        for (String inline : list) {
            result.add(this.render(inline, variables, recursive));
        }
        return result;
    }

    @ConfigurationProperties(value="kestra.variables")
    public static class VariableConfiguration {
        Boolean cacheEnabled = true;
        Integer cacheSize = 1000;
        Boolean recursiveRendering = false;

        @Generated
        public Boolean getCacheEnabled() {
            return this.cacheEnabled;
        }

        @Generated
        public Integer getCacheSize() {
            return this.cacheSize;
        }

        @Generated
        public Boolean getRecursiveRendering() {
            return this.recursiveRendering;
        }
    }
}

