/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.models.executions.ExecutionKind;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.WorkerJob;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class WorkerTask
extends WorkerJob {
    public static final String TYPE = "task";
    @NotNull
    @JsonInclude
    private final String type = "task";
    @NotNull
    private TaskRun taskRun;
    @NotNull
    private Task task;
    @NotNull
    private RunContext runContext;
    @Nullable
    private ExecutionKind executionKind;

    @Override
    public String uid() {
        return this.taskRun.getId();
    }

    public TaskRun fail() {
        State.Type state = State.Type.fail(this.task);
        return this.getTaskRun().withState(state);
    }

    @ConstructorProperties(value={"taskRun", "task", "runContext", "executionKind"})
    @Generated
    WorkerTask(TaskRun taskRun, Task task, RunContext runContext, @Nullable ExecutionKind executionKind) {
        this.taskRun = taskRun;
        this.task = task;
        this.runContext = runContext;
        this.executionKind = executionKind;
    }

    @Generated
    public static WorkerTaskBuilder builder() {
        return new WorkerTaskBuilder();
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public TaskRun getTaskRun() {
        return this.taskRun;
    }

    @Generated
    public Task getTask() {
        return this.task;
    }

    @Generated
    public RunContext getRunContext() {
        return this.runContext;
    }

    @Nullable
    @Generated
    public ExecutionKind getExecutionKind() {
        return this.executionKind;
    }

    @Generated
    public void setTaskRun(TaskRun taskRun) {
        this.taskRun = taskRun;
    }

    @Generated
    public void setTask(Task task) {
        this.task = task;
    }

    @Generated
    public void setRunContext(RunContext runContext) {
        this.runContext = runContext;
    }

    @Generated
    public void setExecutionKind(@Nullable ExecutionKind executionKind) {
        this.executionKind = executionKind;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerTask)) {
            return false;
        }
        WorkerTask other = (WorkerTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        TaskRun this$taskRun = this.getTaskRun();
        TaskRun other$taskRun = other.getTaskRun();
        if (this$taskRun == null ? other$taskRun != null : !((Object)this$taskRun).equals(other$taskRun)) {
            return false;
        }
        Task this$task = this.getTask();
        Task other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        RunContext this$runContext = this.getRunContext();
        RunContext other$runContext = other.getRunContext();
        if (this$runContext == null ? other$runContext != null : !this$runContext.equals(other$runContext)) {
            return false;
        }
        ExecutionKind this$executionKind = this.getExecutionKind();
        ExecutionKind other$executionKind = other.getExecutionKind();
        return !(this$executionKind == null ? other$executionKind != null : !((Object)((Object)this$executionKind)).equals((Object)other$executionKind));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkerTask;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        TaskRun $taskRun = this.getTaskRun();
        result = result * 59 + ($taskRun == null ? 43 : ((Object)$taskRun).hashCode());
        Task $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        RunContext $runContext = this.getRunContext();
        result = result * 59 + ($runContext == null ? 43 : $runContext.hashCode());
        ExecutionKind $executionKind = this.getExecutionKind();
        result = result * 59 + ($executionKind == null ? 43 : ((Object)((Object)$executionKind)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkerTask(super=" + super.toString() + ", type=" + this.getType() + ", taskRun=" + String.valueOf(this.getTaskRun()) + ", task=" + String.valueOf(this.getTask()) + ", runContext=" + String.valueOf(this.getRunContext()) + ", executionKind=" + String.valueOf((Object)this.getExecutionKind()) + ")";
    }

    @Generated
    public WorkerTask withTaskRun(TaskRun taskRun) {
        return this.taskRun == taskRun ? this : new WorkerTask(taskRun, this.task, this.runContext, this.executionKind);
    }

    @Generated
    public static class WorkerTaskBuilder {
        @Generated
        private TaskRun taskRun;
        @Generated
        private Task task;
        @Generated
        private RunContext runContext;
        @Generated
        private ExecutionKind executionKind;

        @Generated
        WorkerTaskBuilder() {
        }

        @Generated
        public WorkerTaskBuilder taskRun(TaskRun taskRun) {
            this.taskRun = taskRun;
            return this;
        }

        @Generated
        public WorkerTaskBuilder task(Task task) {
            this.task = task;
            return this;
        }

        @Generated
        public WorkerTaskBuilder runContext(RunContext runContext) {
            this.runContext = runContext;
            return this;
        }

        @Generated
        public WorkerTaskBuilder executionKind(@Nullable ExecutionKind executionKind) {
            this.executionKind = executionKind;
            return this;
        }

        @Generated
        public WorkerTask build() {
            return new WorkerTask(this.taskRun, this.task, this.runContext, this.executionKind);
        }

        @Generated
        public String toString() {
            return "WorkerTask.WorkerTaskBuilder(taskRun=" + String.valueOf(this.taskRun) + ", task=" + String.valueOf(this.task) + ", runContext=" + String.valueOf(this.runContext) + ", executionKind=" + String.valueOf((Object)this.executionKind) + ")";
        }
    }
}

