/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import io.kestra.core.runners.pebble.AbstractDate;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

public class TimestampMilliFilter
extends AbstractDate
implements Filter {
    @Override
    public List<String> getArgumentNames() {
        return List.of("timeZone", "existingFormat");
    }

    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        String timeZone = (String)args.get("timeZone");
        String existingFormat = (String)args.get("existingFormat");
        ZoneId zoneId = TimestampMilliFilter.zoneId(timeZone);
        ZonedDateTime date = TimestampMilliFilter.convert(input, zoneId, existingFormat);
        return date.toInstant().toEpochMilli();
    }
}

