/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.pebble.functions.RenderingFunctionInterface;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Requires;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Function;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.EvaluationContextImpl;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
@Requires(property="kestra.variables.recursive-rendering", value="false", defaultValue="false")
public class RenderFunction
implements Function,
RenderingFunctionInterface {
    @Inject
    private ApplicationContext applicationContext;

    public List<String> getArgumentNames() {
        return List.of("toRender", "recursive");
    }

    public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
        if (!args.containsKey("toRender")) {
            throw new PebbleException(null, "The 'render' function expects an argument 'toRender'.", Integer.valueOf(lineNumber), self.getName());
        }
        Object toRender = args.get("toRender");
        Object recursiveArg = args.get("recursive");
        if (recursiveArg == null) {
            recursiveArg = true;
        }
        if (!(recursiveArg instanceof Boolean)) {
            throw new PebbleException(null, "The 'render' function expects an optional argument 'recursive' with type boolean.", Integer.valueOf(lineNumber), self.getName());
        }
        Boolean recursive = (Boolean)recursiveArg;
        EvaluationContextImpl evaluationContext = (EvaluationContextImpl)context;
        Map variables = evaluationContext.getScopeChain().getGlobalScopes().stream().flatMap(scope -> scope.getKeys().stream()).distinct().collect(HashMap::new, (m, v) -> m.put(v, context.getVariable(v)), HashMap::putAll);
        try {
            return ((RenderingFunctionInterface)evaluationContext.getExtensionRegistry().getFunction(this.functionName())).variableRenderer(this.applicationContext).renderObject(toRender, variables, recursive).orElse(null);
        }
        catch (IllegalVariableEvaluationException e) {
            throw new PebbleException((Throwable)e, e.getMessage());
        }
    }

    @Override
    public String functionName() {
        return "render";
    }
}

