/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.server;

import io.kestra.core.contexts.KestraContext;
import io.kestra.core.models.ServerType;
import io.kestra.core.server.ServerInstance;
import io.kestra.core.utils.Network;
import io.micronaut.context.env.Environment;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Singleton
public class ServerInstanceFactory {
    private final KestraContext context;
    private final Environment environment;

    @Inject
    public ServerInstanceFactory(KestraContext context, Environment environment) {
        this.context = Objects.requireNonNull(context, "KestraContext cannot be null");
        this.environment = environment;
    }

    public ServerInstance newServerInstance() {
        return new ServerInstance(this.getInstanceType(), this.context.getVersion(), Network.localHostname(), Map.of("server.port", this.getServerPort(), "server.management.port", this.getServerManagementPort()), Set.of());
    }

    private ServerInstance.Type getInstanceType() {
        return this.getServerType() == ServerType.STANDALONE ? ServerInstance.Type.STANDALONE : ServerInstance.Type.SERVER;
    }

    private ServerType getServerType() {
        return this.context.getServerType();
    }

    private int getServerPort() {
        return Optional.ofNullable(this.environment).flatMap(env -> env.getProperty("micronaut.server.port", Integer.class)).orElse(8080);
    }

    private int getServerManagementPort() {
        return Optional.ofNullable(this.environment).flatMap(env -> env.getProperty("endpoints.all.port", Integer.class)).orElse(8081);
    }
}

