/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.server;

import io.kestra.core.server.LocalServiceState;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceType;
import io.kestra.core.utils.Await;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;

@Singleton
public final class ServiceRegistry {
    private final ConcurrentHashMap<ServiceType, LocalServiceState> services = new ConcurrentHashMap();

    public void register(LocalServiceState service) {
        this.services.put(service.service().getType(), service);
    }

    public void unregister(LocalServiceState service) {
        this.services.remove((Object)service.service().getType());
    }

    public boolean containsService(ServiceType type) {
        return this.services.containsKey((Object)type);
    }

    public Service getServiceByType(ServiceType type) {
        return this.services.get((Object)type).service();
    }

    public Service waitForServiceAndGet(ServiceType type) {
        Await.until(() -> this.containsService(type));
        return this.getServiceByType(type);
    }

    public LocalServiceState get(ServiceType type) {
        return this.services.get((Object)type);
    }

    public List<LocalServiceState> all() {
        return new ArrayList<LocalServiceState>(this.services.values());
    }

    public boolean waitForServiceInState(ServiceType type, Service.ServiceState state, Duration maxWaitDuration) {
        if (!this.containsService(type)) {
            return false;
        }
        try {
            Await.until(() -> {
                LocalServiceState service = this.get(type);
                return service != null && service.instance().is(state);
            }, Duration.ofMillis(100L), maxWaitDuration);
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.services.isEmpty();
    }
}

