/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.models.dashboards.filters.AbstractFilter;
import io.kestra.core.models.dashboards.filters.Contains;
import io.kestra.core.models.dashboards.filters.EndsWith;
import io.kestra.core.models.dashboards.filters.EqualTo;
import io.kestra.core.models.dashboards.filters.GreaterThan;
import io.kestra.core.models.dashboards.filters.GreaterThanOrEqualTo;
import io.kestra.core.models.dashboards.filters.In;
import io.kestra.core.models.dashboards.filters.IsFalse;
import io.kestra.core.models.dashboards.filters.IsNotNull;
import io.kestra.core.models.dashboards.filters.IsNull;
import io.kestra.core.models.dashboards.filters.IsTrue;
import io.kestra.core.models.dashboards.filters.LessThan;
import io.kestra.core.models.dashboards.filters.LessThanOrEqualTo;
import io.kestra.core.models.dashboards.filters.NotEqualTo;
import io.kestra.core.models.dashboards.filters.NotIn;
import io.kestra.core.models.dashboards.filters.Or;
import io.kestra.core.models.dashboards.filters.Regex;
import io.kestra.core.models.dashboards.filters.StartsWith;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractFilterService<Q> {
    public <F extends Enum<F>> Q addFilters(Q query, Map<F, String> fieldsMapping, List<AbstractFilter<F>> filters) {
        if (filters == null) {
            return query;
        }
        AtomicReference<Q> finalQuery = new AtomicReference<Q>(query);
        filters.forEach(filter -> {
            AbstractFilter abstractFilter = filter;
            Objects.requireNonNull(abstractFilter);
            AbstractFilter selector0$temp = abstractFilter;
            int index$1 = 0;
            finalQuery.set(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Contains.class, EndsWith.class, EqualTo.class, GreaterThan.class, GreaterThanOrEqualTo.class, In.class, IsFalse.class, IsNotNull.class, IsNull.class, IsTrue.class, LessThan.class, LessThanOrEqualTo.class, NotEqualTo.class, NotIn.class, Or.class, Regex.class, StartsWith.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    Contains f = (Contains)selector0$temp;
                    yield this.contains(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 1 -> {
                    EndsWith f = (EndsWith)selector0$temp;
                    yield this.endsWith(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 2 -> {
                    EqualTo f = (EqualTo)selector0$temp;
                    yield this.equalTo(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 3 -> {
                    GreaterThan f = (GreaterThan)selector0$temp;
                    yield this.greaterThan(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 4 -> {
                    GreaterThanOrEqualTo f = (GreaterThanOrEqualTo)selector0$temp;
                    yield this.greaterThanOrEqualTo(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 5 -> {
                    In f = (In)selector0$temp;
                    yield this.in(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 6 -> {
                    IsFalse f = (IsFalse)selector0$temp;
                    yield this.isFalse(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 7 -> {
                    IsNotNull f = (IsNotNull)selector0$temp;
                    yield this.isNotNull(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 8 -> {
                    IsNull f = (IsNull)selector0$temp;
                    yield this.isNull(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 9 -> {
                    IsTrue f = (IsTrue)selector0$temp;
                    yield this.isTrue(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 10 -> {
                    LessThan f = (LessThan)selector0$temp;
                    yield this.lessThan(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 11 -> {
                    LessThanOrEqualTo f = (LessThanOrEqualTo)selector0$temp;
                    yield this.lessThanOrEqualTo(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 12 -> {
                    NotEqualTo f = (NotEqualTo)selector0$temp;
                    yield this.notEqualTo(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 13 -> {
                    NotIn f = (NotIn)selector0$temp;
                    yield this.notIn(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 14 -> {
                    Or f = (Or)selector0$temp;
                    yield this.or(finalQuery.get(), fieldsMapping, f);
                }
                case 15 -> {
                    Regex f = (Regex)selector0$temp;
                    yield this.regex(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                case 16 -> {
                    StartsWith f = (StartsWith)selector0$temp;
                    yield this.startsWith(finalQuery.get(), (String)fieldsMapping.get(f.getField()), f);
                }
                default -> throw new UnsupportedOperationException(filter.getClass().getName() + " is not implemented.");
            });
        });
        return finalQuery.get();
    }

    protected abstract <F extends Enum<F>> Q contains(Q var1, String var2, Contains<F> var3);

    protected abstract <F extends Enum<F>> Q endsWith(Q var1, String var2, EndsWith<F> var3);

    protected abstract <F extends Enum<F>> Q equalTo(Q var1, String var2, EqualTo<F> var3);

    protected abstract <F extends Enum<F>> Q greaterThan(Q var1, String var2, GreaterThan<F> var3);

    protected abstract <F extends Enum<F>> Q greaterThanOrEqualTo(Q var1, String var2, GreaterThanOrEqualTo<F> var3);

    protected abstract <F extends Enum<F>> Q in(Q var1, String var2, In<F> var3);

    protected abstract <F extends Enum<F>> Q isFalse(Q var1, String var2, IsFalse<F> var3);

    protected abstract <F extends Enum<F>> Q isNotNull(Q var1, String var2, IsNotNull<F> var3);

    protected abstract <F extends Enum<F>> Q isNull(Q var1, String var2, IsNull<F> var3);

    protected abstract <F extends Enum<F>> Q isTrue(Q var1, String var2, IsTrue<F> var3);

    protected abstract <F extends Enum<F>> Q lessThan(Q var1, String var2, LessThan<F> var3);

    protected abstract <F extends Enum<F>> Q lessThanOrEqualTo(Q var1, String var2, LessThanOrEqualTo<F> var3);

    protected abstract <F extends Enum<F>> Q notEqualTo(Q var1, String var2, NotEqualTo<F> var3);

    protected abstract <F extends Enum<F>> Q notIn(Q var1, String var2, NotIn<F> var3);

    protected abstract <F extends Enum<F>> Q or(Q var1, Map<F, String> var2, Or<F> var3);

    protected abstract <F extends Enum<F>> Q regex(Q var1, String var2, Regex<F> var3);

    protected abstract <F extends Enum<F>> Q startsWith(Q var1, String var2, StartsWith<F> var3);
}

