/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.LogEntry;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.FlowId;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@Singleton
public class LogService {
    private static final String FLOW_PREFIX_WITH_TENANT = "[tenant: {}] [namespace: {}] [flow: {}] ";
    private static final String EXECUTION_PREFIX_WITH_TENANT = "[tenant: {}] [namespace: {}] [flow: {}] [execution: {}] ";
    private static final String TRIGGER_PREFIX_WITH_TENANT = "[tenant: {}] [namespace: {}] [flow: {}] [trigger: {}] ";
    private static final String TASKRUN_PREFIX_WITH_TENANT = "[tenant: {}] [namespace: {}] [flow: {}] [task: {}] [execution: {}] [taskrun: {}] ";
    private final LogRepositoryInterface logRepository;

    @Inject
    public LogService(LogRepositoryInterface logRepository) {
        this.logRepository = logRepository;
    }

    public void logExecution(FlowId flow, Logger logger, Level level, String message, Object ... args) {
        String finalMsg = FLOW_PREFIX_WITH_TENANT + message;
        Object[] executionArgs = new Object[]{flow.getTenantId(), flow.getNamespace(), flow.getId()};
        Object[] finalArgs = ArrayUtils.addAll((Object[])executionArgs, (Object[])args);
        logger.atLevel(level).log(finalMsg, finalArgs);
    }

    public void logExecution(Execution execution, Level level, String message, Object ... args) {
        Logger logger = this.logger(execution);
        this.logExecution(execution, logger, level, message, args);
    }

    public void logExecution(Execution execution, Logger logger, Level level, String message, Object ... args) {
        Object[] executionArgs = new Object[]{execution.getTenantId(), execution.getNamespace(), execution.getFlowId(), execution.getId()};
        Object[] finalArgs = ArrayUtils.addAll((Object[])executionArgs, (Object[])args);
        logger.atLevel(level).log(EXECUTION_PREFIX_WITH_TENANT + message, finalArgs);
    }

    public void logTrigger(TriggerContext triggerContext, Level level, String message, Object ... args) {
        Logger logger = this.logger(triggerContext);
        this.logTrigger(triggerContext, logger, level, message, args);
    }

    public void logTrigger(TriggerContext triggerContext, Logger logger, Level level, String message, Object ... args) {
        Object[] executionArgs = new Object[]{triggerContext.getTenantId(), triggerContext.getNamespace(), triggerContext.getFlowId(), triggerContext.getTriggerId()};
        Object[] finalArgs = ArrayUtils.addAll((Object[])executionArgs, (Object[])args);
        logger.atLevel(level).log(TRIGGER_PREFIX_WITH_TENANT + message, finalArgs);
    }

    public void logTaskRun(TaskRun taskRun, Level level, String message, Object ... args) {
        String prefix = TASKRUN_PREFIX_WITH_TENANT;
        String finalMsg = taskRun.getValue() == null ? prefix + message : prefix + "[value: {}] " + message;
        Object[] executionArgs = new Object[]{taskRun.getTenantId(), taskRun.getNamespace(), taskRun.getFlowId(), taskRun.getTaskId(), taskRun.getExecutionId(), taskRun.getId()};
        if (taskRun.getValue() != null) {
            executionArgs = ArrayUtils.add((Object[])executionArgs, (Object)taskRun.getValue());
        }
        Object[] finalArgs = ArrayUtils.addAll((Object[])executionArgs, (Object[])args);
        Logger logger = this.logger(taskRun);
        logger.atLevel(level).log(finalMsg, finalArgs);
    }

    public int purge(String tenantId, String namespace, String flowId, String executionId, List<Level> logLevels, ZonedDateTime startDate, ZonedDateTime endDate) {
        return this.logRepository.deleteByQuery(tenantId, namespace, flowId, executionId, logLevels, startDate, endDate);
    }

    public List<LogEntry> errorLogs(String tenantId, String executionId) {
        return this.logRepository.findByExecutionId(tenantId, executionId, Level.ERROR, Pageable.from((int)1, (int)25, (Sort)Sort.of((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"timestamp")})));
    }

    private Logger logger(TaskRun taskRun) {
        return LoggerFactory.getLogger((String)("task." + taskRun.getFlowId() + "." + taskRun.getTaskId()));
    }

    private Logger logger(TriggerContext triggerContext) {
        return LoggerFactory.getLogger((String)("trigger." + triggerContext.getFlowId() + "." + triggerContext.getTriggerId()));
    }

    private Logger logger(Execution execution) {
        return LoggerFactory.getLogger((String)("execution." + execution.getFlowId()));
    }
}

