/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import com.google.common.annotations.VisibleForTesting;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.TaskRun;
import jakarta.annotation.Nullable;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;

@Singleton
public class SkipExecutionService {
    private volatile List<String> skipExecutions = Collections.emptyList();
    private volatile List<FlowId> skipFlows = Collections.emptyList();
    private volatile List<NamespaceId> skipNamespaces = Collections.emptyList();
    private volatile List<String> skipTenants = Collections.emptyList();
    private volatile List<String> skipIndexerRecords = Collections.emptyList();

    public synchronized void setSkipExecutions(List<String> skipExecutions) {
        this.skipExecutions = skipExecutions == null ? Collections.emptyList() : skipExecutions;
    }

    public synchronized void setSkipFlows(List<String> skipFlows) {
        this.skipFlows = skipFlows == null ? Collections.emptyList() : skipFlows.stream().map(FlowId::from).toList();
    }

    public synchronized void setSkipNamespaces(List<String> skipNamespaces) {
        this.skipNamespaces = skipNamespaces == null ? Collections.emptyList() : skipNamespaces.stream().map(NamespaceId::from).toList();
    }

    public synchronized void setSkipTenants(List<String> skipTenants) {
        this.skipTenants = skipTenants == null ? Collections.emptyList() : skipTenants;
    }

    public synchronized void setSkipIndexerRecords(List<String> skipIndexerRecords) {
        this.skipIndexerRecords = skipIndexerRecords == null ? Collections.emptyList() : skipIndexerRecords;
    }

    public boolean skipExecution(String executionId) {
        return this.skipExecutions.contains(executionId);
    }

    public boolean skipExecution(Execution execution) {
        return this.skipExecution(execution.getTenantId(), execution.getNamespace(), execution.getFlowId(), execution.getId());
    }

    public boolean skipExecution(TaskRun taskRun) {
        return this.skipExecution(taskRun.getTenantId(), taskRun.getNamespace(), taskRun.getFlowId(), taskRun.getExecutionId());
    }

    public boolean skipIndexerRecord(@Nullable String key) {
        return key != null && this.skipIndexerRecords.contains(key);
    }

    @VisibleForTesting
    boolean skipExecution(String tenant, String namespace, String flow, String executionId) {
        return tenant != null && this.skipTenants.contains(tenant) || this.skipNamespaces.contains(new NamespaceId(tenant, namespace)) || this.skipFlows.contains(new FlowId(tenant, namespace, flow)) || executionId != null && this.skipExecutions.contains(executionId);
    }

    private static String[] splitIdParts(String id) {
        return id.split("\\|");
    }

    record NamespaceId(String tenant, String namespace) {
        static NamespaceId from(String namespaceId) {
            String[] parts = SkipExecutionService.splitIdParts(namespaceId);
            return new NamespaceId(parts[0], parts[1]);
        }
    }

    record FlowId(String tenant, String namespace, String flow) {
        static FlowId from(String flowId) {
            String[] parts = SkipExecutionService.splitIdParts(flowId);
            if (parts.length == 3) {
                return new FlowId(parts[0], parts[1], parts[2]);
            }
            return new FlowId(null, parts[0], parts[1]);
        }
    }
}

