/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.runners.RunContext;
import io.kestra.core.storages.StorageSplitInterface;
import io.kestra.core.utils.Rethrow;
import io.micronaut.core.convert.format.ReadableBytesTypeConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public abstract class StorageService {
    public static List<URI> split(RunContext runContext, StorageSplitInterface storageSplitInterface, URI from) throws IOException, IllegalVariableEvaluationException {
        String fromPath = from.getPath();
        String extension = ".tmp";
        if (fromPath.indexOf(46) >= 0) {
            extension = fromPath.substring(fromPath.lastIndexOf(46));
        }
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(runContext.storage().getFile(from)));){
            List<Path> splited;
            if (storageSplitInterface.getBytes() != null) {
                ReadableBytesTypeConverter readableBytesTypeConverter = new ReadableBytesTypeConverter();
                Number convert = (Number)readableBytesTypeConverter.convert((Object)runContext.render(storageSplitInterface.getBytes()).as(String.class).orElseThrow(), Number.class).orElseThrow(() -> new IllegalArgumentException("Invalid size with value '" + String.valueOf(storageSplitInterface.getBytes()) + "'"));
                splited = StorageService.split(runContext, extension, runContext.render(storageSplitInterface.getSeparator()).as(String.class).orElseThrow(), bufferedReader, (bytes, size) -> (long)bytes.intValue() >= convert.longValue());
            } else if (storageSplitInterface.getPartitions() != null) {
                splited = StorageService.partition(runContext, extension, runContext.render(storageSplitInterface.getSeparator()).as(String.class).orElseThrow(), bufferedReader, runContext.render(storageSplitInterface.getPartitions()).as(Integer.class).orElseThrow());
            } else if (storageSplitInterface.getRows() != null) {
                Integer renderedRows = runContext.render(storageSplitInterface.getRows()).as(Integer.class).orElseThrow();
                splited = StorageService.split(runContext, extension, runContext.render(storageSplitInterface.getSeparator()).as(String.class).orElseThrow(), bufferedReader, (bytes, size) -> size >= renderedRows);
            } else {
                throw new IllegalArgumentException("Invalid configuration with no size, count, nor rows");
            }
            List<URI> list = splited.stream().map(Rethrow.throwFunction(path -> runContext.storage().putFile(path.toFile()))).toList();
            return list;
        }
    }

    private static List<Path> split(RunContext runContext, String extension, String separator, BufferedReader bufferedReader, BiFunction<Integer, Integer, Boolean> predicate) throws IOException {
        String row;
        ArrayList<Path> files = new ArrayList<Path>();
        RandomAccessFile write = null;
        int totalBytes = 0;
        int totalRows = 0;
        while ((row = bufferedReader.readLine()) != null) {
            if (write == null || predicate.apply(totalBytes, totalRows).booleanValue()) {
                if (write != null) {
                    write.close();
                }
                totalBytes = 0;
                totalRows = 0;
                Path path = runContext.workingDir().createTempFile(extension);
                files.add(path);
                write = new RandomAccessFile(path.toFile(), "rw");
            }
            byte[] bytes = (row + separator).getBytes(StandardCharsets.UTF_8);
            write.getChannel().write(ByteBuffer.wrap(bytes));
            totalBytes += bytes.length;
            ++totalRows;
        }
        if (write != null) {
            write.close();
        }
        return files;
    }

    private static List<Path> partition(RunContext runContext, String extension, String separator, BufferedReader bufferedReader, int partition) throws IOException {
        String row;
        ArrayList<Path> files = new ArrayList<Path>();
        ArrayList<RandomAccessFile> writers = new ArrayList<RandomAccessFile>();
        for (int i = 0; i < partition; ++i) {
            Path path = runContext.workingDir().createTempFile(extension);
            files.add(path);
            writers.add(new RandomAccessFile(path.toFile(), "rw"));
        }
        int index = 0;
        while ((row = bufferedReader.readLine()) != null) {
            ((RandomAccessFile)writers.get(index)).getChannel().write(ByteBuffer.wrap((row + separator).getBytes(StandardCharsets.UTF_8)));
            index = index >= writers.size() - 1 ? 0 : index + 1;
        }
        writers.forEach(Rethrow.throwConsumer(RandomAccessFile::close));
        return files.stream().filter(p -> p.toFile().length() > 0L).toList();
    }
}

