/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.storages.Namespace;
import io.kestra.core.storages.NamespaceFile;
import io.kestra.core.storages.StorageInterface;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalNamespace
implements Namespace {
    private static final Logger LOG = LoggerFactory.getLogger(InternalNamespace.class);
    private final String namespace;
    private final String tenant;
    private final StorageInterface storage;
    private final Logger logger;

    public InternalNamespace(@Nullable String tenant, String namespace, StorageInterface storage) {
        this(LOG, tenant, namespace, storage);
    }

    public InternalNamespace(Logger logger, @Nullable String tenant, String namespace, StorageInterface storage) {
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
        this.namespace = Objects.requireNonNull(namespace, "namespace cannot be null");
        this.storage = Objects.requireNonNull(storage, "storage cannot be null");
        this.tenant = tenant;
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public String tenantId() {
        return this.tenant;
    }

    @Override
    public List<NamespaceFile> all() throws IOException {
        return this.all(false);
    }

    @Override
    public List<NamespaceFile> all(boolean includeDirectories) throws IOException {
        return this.all(null, includeDirectories);
    }

    @Override
    public List<NamespaceFile> all(String prefix, boolean includeDirectories) throws IOException {
        URI namespacePrefix = URI.create(NamespaceFile.of(this.namespace, Optional.ofNullable(prefix).map(x$0 -> Path.of(x$0, new String[0])).orElse(null)).storagePath().toString().replace("\\", "/") + "/");
        return this.storage.allByPrefix(this.tenant, this.namespace, namespacePrefix, includeDirectories).stream().map(uri -> new NamespaceFile(this.relativize((URI)uri), (URI)uri, this.namespace)).toList();
    }

    @Override
    public NamespaceFile get(Path path) {
        return NamespaceFile.of(this.namespace, path);
    }

    public Path relativize(URI uri) {
        return NamespaceFile.of(this.namespace).storagePath().relativize(Path.of(uri.getPath(), new String[0]));
    }

    @Override
    public List<NamespaceFile> findAllFilesMatching(Predicate<Path> predicate) throws IOException {
        return this.all().stream().filter(it -> predicate.test(it.path(true))).toList();
    }

    @Override
    public InputStream getFileContent(Path path) throws IOException {
        Path namespaceFilePath = NamespaceFile.of(this.namespace, path).storagePath();
        return this.storage.get(this.tenant, this.namespace, namespaceFilePath.toUri());
    }

    @Override
    public NamespaceFile putFile(Path path, InputStream content, Namespace.Conflicts onAlreadyExist) throws IOException, URISyntaxException {
        Path namespaceFilesPrefix = NamespaceFile.of(this.namespace, path).storagePath();
        URI cleanUri = new URI(namespaceFilesPrefix.toUri().toString().replaceFirst("^file:///[a-zA-Z]:", ""));
        boolean exists = this.storage.exists(this.tenant, this.namespace, cleanUri);
        return switch (onAlreadyExist) {
            default -> throw new MatchException(null, null);
            case Namespace.Conflicts.OVERWRITE -> {
                URI uri = this.storage.put(this.tenant, this.namespace, cleanUri, content);
                NamespaceFile namespaceFile = new NamespaceFile(this.relativize(uri), uri, this.namespace);
                if (exists) {
                    this.logger.debug(String.format("File '%s' overwritten into namespace '%s'.", path, this.namespace));
                } else {
                    this.logger.debug(String.format("File '%s' added to namespace '%s'.", path, this.namespace));
                }
                yield namespaceFile;
            }
            case Namespace.Conflicts.ERROR -> {
                if (!exists) {
                    URI uri = this.storage.put(this.tenant, this.namespace, namespaceFilesPrefix.toUri(), content);
                    yield new NamespaceFile(this.relativize(uri), uri, this.namespace);
                }
                throw new IOException(String.format("File '%s' already exists in namespace '%s' and conflict is set to %s", new Object[]{path, this.namespace, Namespace.Conflicts.ERROR}));
            }
            case Namespace.Conflicts.SKIP -> {
                if (!exists) {
                    URI uri = this.storage.put(this.tenant, this.namespace, namespaceFilesPrefix.toUri(), content);
                    NamespaceFile namespaceFile = new NamespaceFile(this.relativize(uri), uri, this.namespace);
                    this.logger.debug(String.format("File '%s' added to namespace '%s'.", path, this.namespace));
                    yield namespaceFile;
                }
                this.logger.debug(String.format("File '%s' already exists in namespace '%s' and conflict is set to %s. Skipping.", new Object[]{path, this.namespace, Namespace.Conflicts.SKIP}));
                URI uri = URI.create("kestra://" + String.valueOf(namespaceFilesPrefix));
                yield new NamespaceFile(this.relativize(uri), uri, this.namespace);
            }
        };
    }

    @Override
    public URI createDirectory(Path path) throws IOException {
        return this.storage.createDirectory(this.tenant, this.namespace, NamespaceFile.of(this.namespace, path).storagePath().toUri());
    }

    @Override
    public boolean delete(Path path) throws IOException {
        return this.storage.delete(this.tenant, this.namespace, URI.create(path.toString().replace("\\", "/")));
    }
}

