/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.storages.Namespace;
import io.kestra.core.storages.StorageContext;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public interface Storage {
    public Namespace namespace();

    public Namespace namespace(String var1);

    public boolean isFileExist(URI var1);

    public InputStream getFile(URI var1) throws IOException;

    public boolean deleteFile(URI var1) throws IOException;

    public List<URI> deleteExecutionFiles() throws IOException;

    public URI getContextBaseURI();

    public URI putFile(InputStream var1, String var2) throws IOException;

    public URI putFile(InputStream var1, URI var2) throws IOException;

    public URI putFile(File var1) throws IOException;

    public URI putFile(File var1, String var2) throws IOException;

    default public Optional<InputStream> getCacheFile(String cacheId, @Nullable String objectId) throws IOException {
        return this.getCacheFile(cacheId, objectId, null);
    }

    public Optional<InputStream> getCacheFile(String var1, @Nullable String var2, @Nullable Duration var3) throws IOException;

    public URI putCacheFile(File var1, String var2, @Nullable String var3) throws IOException;

    public Optional<Boolean> deleteCacheFile(String var1, @Nullable String var2) throws IOException;

    public Optional<StorageContext.Task> getTaskStorageContext();
}

